/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.TokenUser;
import org.odpi.openmetadata.userinterface.uichassis.springboot.domain.User;
import org.springframework.security.core.Authentication;
import org.springframework.security.ldap.userdetails.InetOrgPerson;

public interface AuthService {
    public static final String AUTH_HEADER_NAME = "x-auth-token";

    public Authentication getAuthentication(HttpServletRequest var1);

    public User addAuthentication(HttpServletRequest var1, HttpServletResponse var2, Authentication var3);

    default public TokenUser getTokenUser(Authentication authentication) {
        Object principal = authentication.getPrincipal();
        TokenUser tokenUser = principal instanceof TokenUser ? (TokenUser)principal : new TokenUser((InetOrgPerson)principal);
        return tokenUser;
    }

    default public User fromJSON(String userJSON) {
        try {
            return (User)new ObjectMapper().readValue(userJSON, User.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    default public String toJSON(User user) {
        try {
            return new ObjectMapper().writeValueAsString((Object)user);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    default public TokenUser parseUserFromToken(String token, String secret) {
        String userJSON = ((Claims)Jwts.parser().setSigningKey(secret).parseClaimsJws(token).getBody()).getSubject();
        return new TokenUser(this.fromJSON(userJSON));
    }

    default public String createTokenForUser(User user, String secret) {
        return Jwts.builder().setExpiration(new Date(System.currentTimeMillis() + this.getTokenTimeout())).setSubject(this.toJSON(user)).signWith(SignatureAlgorithm.HS512, secret).compact();
    }

    public long getTokenTimeout();
}

