/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.AuthService;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.AuthenticationExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class LoginFilter
extends AbstractAuthenticationProcessingFilter {
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private final AuthService authenticationService;
    private final AuthenticationExceptionHandler authenticationExceptionHandler;
    Logger log = LoggerFactory.getLogger(this.getClass());

    protected LoginFilter(String urlMapping, AuthenticationManager authenticationManager, AuthService authenticationService, AuthenticationExceptionHandler authenticationExceptionHandler) {
        super((RequestMatcher)new AntPathRequestMatcher(urlMapping));
        this.setAuthenticationManager(authenticationManager);
        this.authenticationService = authenticationService;
        this.authenticationExceptionHandler = authenticationExceptionHandler;
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        String username = request.getParameter(USERNAME);
        String password = request.getParameter(PASSWORD);
        Authentication authentication = this.getAuthenticationManager().authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
        return authentication;
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException {
        this.log.info("UNSUCCESSFUL Authentication");
        if (this.authenticationExceptionHandler.isBadCredentials(failed)) {
            this.log.warn("Bad credentials for user: {}", (Object)request.getParameter(USERNAME));
            response.sendError(HttpStatus.UNAUTHORIZED.value(), HttpStatus.UNAUTHORIZED.getReasonPhrase());
        } else {
            this.log.warn("ERROR AUTHENTICATION for user: {}", (Object)request.getParameter(USERNAME), (Object)failed);
            response.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
        }
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authentication) throws IOException {
        this.log.info("SUCCESSFUL Authentication for user {}", (Object)request.getParameter(USERNAME));
        this.authenticationService.addAuthentication(request, response, authentication);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        if (authentication.getAuthorities().isEmpty()) {
            this.log.warn("NO roles for user: {}", (Object)request.getParameter(USERNAME));
            response.sendError(HttpStatus.FORBIDDEN.value(), HttpStatus.FORBIDDEN.getReasonPhrase());
        }
    }
}

