/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.governanceservers.openlineage.client.OpenLineageClient;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageEdge;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVertex;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVerticesAndEdges;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Edge;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Graph;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Node;
import org.odpi.openmetadata.userinterface.uichassis.springboot.service.LineageGraphDisplayRulesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OpenLineageService {
    public static final String EDGES_LABEL = "edges";
    public static final String NODES_LABEL = "nodes";
    private static final String TABULAR_COLUMN = "TabularColumn";
    private static final String TABULAR_SCHEMA_TYPE = "TabularSchemaType";
    private static final String SUB_PROCESS = "subProcess";
    private static final String VERTEX_INSTANCE_PROPQUALIFIED_NAME = "vertex--InstancePropqualifiedName";
    private static final String TRANSFORMATION_PROJECT = "transformationProject";
    private static final String TRANSFORMATION_PROJECT_NAME_PATTERN = "transformation_project\\)=(.*?)::";
    private final OpenLineageClient openLineageClient;
    private final LineageGraphDisplayRulesService lineageGraphDisplayRulesService;
    private static final Logger LOG = LoggerFactory.getLogger(OpenLineageService.class);

    @Autowired
    public OpenLineageService(OpenLineageClient openLineageClient, LineageGraphDisplayRulesService lineageGraphDisplayRulesService) {
        this.openLineageClient = openLineageClient;
        this.lineageGraphDisplayRulesService = lineageGraphDisplayRulesService;
    }

    public Graph getUltimateSource(String userId, String guid, boolean includeProcesses) {
        try {
            LineageVerticesAndEdges response = this.openLineageClient.lineage(userId, Scope.ULTIMATE_SOURCE, guid, "", includeProcesses);
            return this.processResponse(response, guid);
        }
        catch (InvalidParameterException | PropertyServerException | OpenLineageException e) {
            LOG.error("Cannot get ultimate source lineage for guid {}", (Object)guid);
            throw new RuntimeException("ultimate source lineage error", e);
        }
    }

    public Graph getEndToEndLineage(String userId, String guid, boolean includeProcesses) {
        try {
            LineageVerticesAndEdges response = this.openLineageClient.lineage(userId, Scope.END_TO_END, guid, "", includeProcesses);
            return this.processResponse(response, guid);
        }
        catch (InvalidParameterException | PropertyServerException | OpenLineageException e) {
            LOG.error("Cannot get end to end lineage for guid {}", (Object)guid);
            throw new RuntimeException("end2end lineage error", e);
        }
    }

    public Graph getUltimateDestination(String userId, String guid, boolean includeProcesses) {
        try {
            LineageVerticesAndEdges response = this.openLineageClient.lineage(userId, Scope.ULTIMATE_DESTINATION, guid, "", includeProcesses);
            return this.processResponse(response, guid);
        }
        catch (InvalidParameterException | PropertyServerException | OpenLineageException e) {
            LOG.error("Cannot get ultimate destination lineage for guid {}", (Object)guid);
            throw new RuntimeException("ultimate destination lineage error", e);
        }
    }

    public Graph getVerticalLineage(String userId, String guid, boolean includeProcesses) {
        try {
            LineageVerticesAndEdges response = this.openLineageClient.lineage(userId, Scope.VERTICAL, guid, "", includeProcesses);
            return this.processResponse(response, guid);
        }
        catch (InvalidParameterException | PropertyServerException | OpenLineageException e) {
            LOG.error("Cannot get glossary lineage for guid {}", (Object)guid);
            throw new RuntimeException("glossary lineage error", e);
        }
    }

    public Graph getSourceAndDestination(String userId, String guid, boolean includeProcesses) {
        try {
            LineageVerticesAndEdges response = this.openLineageClient.lineage(userId, Scope.SOURCE_AND_DESTINATION, guid, "", includeProcesses);
            return this.processResponse(response, guid);
        }
        catch (InvalidParameterException | PropertyServerException | OpenLineageException e) {
            LOG.error("Cannot get source and destination lineage for guid {}", (Object)guid);
            throw new RuntimeException("source and destination lineage error ", e);
        }
    }

    private Graph processResponse(LineageVerticesAndEdges response, String guid) {
        List<Object> edges = new ArrayList();
        List<Object> nodes = new ArrayList();
        LOG.debug("Received response from open lineage service: {}", (Object)response);
        if (response == null || CollectionUtils.isEmpty((Collection)response.getLineageVertices())) {
            return new Graph(nodes, edges);
        }
        edges = Optional.ofNullable(response).map(LineageVerticesAndEdges::getLineageEdges).map(Collection::stream).orElseGet(Stream::empty).map(arg_0 -> this.createEdge(arg_0)).collect(Collectors.toList());
        nodes = Optional.ofNullable(response).map(LineageVerticesAndEdges::getLineageVertices).map(Collection::stream).orElseGet(Stream::empty).map(arg_0 -> this.createNode(arg_0)).collect(Collectors.toList());
        List startList = nodes.stream().filter(n -> n.getId().equals(guid)).collect(Collectors.toList());
        if (startList.size() > 0) {
            this.setNodesLevel(startList, new ArrayList<Object>(nodes), new ArrayList(edges));
        }
        if (this.isQueriedNodeTabularColumn(guid, nodes)) {
            this.adjustGraphForTabularColumn(edges, nodes);
        }
        Graph graph = new Graph(nodes, edges);
        this.lineageGraphDisplayRulesService.applyRules(graph);
        nodes.stream().filter(node -> SUB_PROCESS.equals(node.getGroup())).forEach(arg_0 -> this.extractTransformationProjectFromQualifiedName(arg_0));
        return graph;
    }

    private void extractTransformationProjectFromQualifiedName(Node node) {
        if (node.getProperties() == null) {
            return;
        }
        String qualifiedName = (String)node.getProperties().get(VERTEX_INSTANCE_PROPQUALIFIED_NAME);
        if (qualifiedName == null) {
            return;
        }
        Pattern pattern = Pattern.compile(TRANSFORMATION_PROJECT_NAME_PATTERN, 32);
        Matcher matcher = pattern.matcher(qualifiedName);
        if (matcher.find()) {
            node.getProperties().put(TRANSFORMATION_PROJECT, matcher.group(1));
        }
        node.getProperties().remove(VERTEX_INSTANCE_PROPQUALIFIED_NAME);
    }

    private void setNodesLevel(List<Node> startNodes, List<Node> listNodes, List<Edge> listEdges) {
        ArrayList newStartNodes = new ArrayList();
        ListIterator<Edge> edgeListIterator = listEdges.listIterator();
        while (edgeListIterator.hasNext()) {
            Edge e = edgeListIterator.next();
            for (Node node : startNodes) {
                if (node.getId().equals(e.getFrom())) {
                    listNodes.stream().filter(n -> n.getLevel() == 0 && n.getId().equals(e.getTo())).forEach(item -> {
                        item.setLevel(Integer.valueOf(node.getLevel() + 1));
                        newStartNodes.add(item);
                        edgeListIterator.remove();
                    });
                } else if (node.getId().equals(e.getTo())) {
                    listNodes.stream().filter(n -> n.getLevel() == 0 && n.getId().equals(e.getFrom())).forEach(item -> {
                        item.setLevel(Integer.valueOf(node.getLevel() - 1));
                        newStartNodes.add(item);
                        edgeListIterator.remove();
                    });
                }
                listNodes.removeAll(newStartNodes);
            }
        }
        if (newStartNodes.size() > 0 && listEdges.size() > 0) {
            this.setNodesLevel(newStartNodes, listNodes, listEdges);
        }
    }

    private Edge createEdge(LineageEdge currentEdge) {
        return new Edge(currentEdge.getSourceNodeID(), currentEdge.getDestinationNodeID(), currentEdge.getEdgeType());
    }

    private Node createNode(LineageVertex currentNode) {
        String displayName = currentNode.getDisplayName();
        Node node = new Node(currentNode.getNodeID(), displayName);
        node.setGroup(currentNode.getNodeType());
        node.setProperties(currentNode.getProperties());
        return node;
    }

    private boolean isQueriedNodeTabularColumn(String guid, List<Node> nodes) {
        return nodes.stream().anyMatch(node -> node.getId().equals(guid) && node.getGroup().equals(TABULAR_COLUMN));
    }

    private void adjustGraphForTabularColumn(List<Edge> edges, List<Node> nodes) {
        ArrayList<Edge> edgesToRemove = new ArrayList<Edge>();
        ArrayList<Node> nodesToRemove = new ArrayList<Node>();
        for (Node node : nodes) {
            if (!node.getGroup().equals(TABULAR_SCHEMA_TYPE)) continue;
            nodesToRemove.add(node);
            String newFrom = "";
            ArrayList<String> newTo = new ArrayList<String>();
            for (Edge edge : edges) {
                if (!edge.getTo().equals(node.getId())) continue;
                edgesToRemove.add(edge);
                newFrom = edge.getFrom();
            }
            for (Edge edge : edges) {
                if (!edge.getFrom().equals(node.getId())) continue;
                edgesToRemove.add(edge);
                newTo.add(edge.getTo());
            }
            for (String newTos : newTo) {
                edges.add(new Edge(newFrom, newTos));
            }
        }
        nodes.removeAll(nodesToRemove);
        edges.removeAll(edgesToRemove);
    }
}

