/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.odpi.openmetadata.repositoryservices.clients.EnterpriseRepositoryServicesClient;
import org.odpi.openmetadata.repositoryservices.clients.LocalRepositoryServicesClient;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.SecureController;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.ClassificationExplorer;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.EntityExplorer;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RelationshipExplorer;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RepositoryExplorerController;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RexEntityDetailResponse;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RexEntityDigest;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RexEntityRequestBody;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RexErrorCode;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RexExpandedEntityDetail;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RexExpandedRelationship;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RexPreTraversal;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RexPreTraversalResponse;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RexRelationshipDigest;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RexRelationshipRequestBody;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RexRelationshipResponse;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RexSearchBody;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RexSearchResponse;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RexTraversal;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RexTraversalRequestBody;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RexTraversalResponse;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RexTypeStats;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RexTypesRequestBody;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.TypeExplorer;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.TypeExplorerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RepositoryExplorerController
extends SecureController {
    private static String className = RepositoryExplorerController.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)className);
    String metadataCollectionId = null;
    OMRSMetadataCollection metadataCollection = null;
    private static final int TRUNCATED_STRING_LENGTH = 24;

    @PostMapping(path={"/api/types/rexTypeExplorer"})
    public TypeExplorerResponse rexTypeExplorer(@RequestBody RexTypesRequestBody body, HttpServletRequest request) {
        String exceptionMessage;
        boolean enterpriseOption;
        String serverURLRoot;
        String serverName;
        try {
            serverName = body.getServerName();
            serverURLRoot = body.getServerURLRoot();
            enterpriseOption = body.getEnterpriseOption();
        }
        catch (Exception e) {
            String exceptionMessage2 = "The request body used in the request to /api/types/rexTypeExplorer contained an invalid parameter or was missing a parameter. Please check the client code.";
            TypeExplorerResponse texResp = new TypeExplorerResponse(Integer.valueOf(400), exceptionMessage2, null);
            return texResp;
        }
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        try {
            TypeExplorer tex = this.getTypeExplorer(userId, serverName, serverURLRoot, enterpriseOption);
            TypeExplorerResponse texResp = tex != null ? new TypeExplorerResponse(Integer.valueOf(200), "", tex) : new TypeExplorerResponse(Integer.valueOf(400), "Could not retrieve type information", null);
            return texResp;
        }
        catch (UserNotAuthorizedException e) {
            exceptionMessage = "Sorry - this username was not authorized to perform the request";
        }
        catch (RepositoryErrorException e) {
            exceptionMessage = "The repository could not be reached, please check the server name and URL root and verify that the server is running ";
        }
        catch (InvalidParameterException e) {
            exceptionMessage = "The request to load type information reported an invalid parameter, please check the server name and URL root parameters";
        }
        TypeExplorerResponse texResp = new TypeExplorerResponse(Integer.valueOf(400), exceptionMessage, null);
        return texResp;
    }

    private TypeExplorer getTypeExplorer(String userId, String serverName, String serverURLRoot, boolean enterpriseOption) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException {
        Object repositoryServicesClient = !enterpriseOption ? this.getLocalRepositoryServicesClient(serverName, serverURLRoot) : this.getEnterpriseRepositoryServicesClient(serverName, serverURLRoot);
        TypeExplorer tex = new TypeExplorer();
        TypeDefGallery typeDefGallery = repositoryServicesClient.getAllTypes(userId);
        ArrayList typeDefs = typeDefGallery.getTypeDefs();
        for (TypeDef typeDef : typeDefs) {
            TypeDefCategory tdCat = typeDef.getCategory();
            switch (1.$SwitchMap$org$odpi$openmetadata$repositoryservices$connectors$stores$metadatacollectionstore$properties$typedefs$TypeDefCategory[tdCat.ordinal()]) {
                case 1: {
                    EntityExplorer eex = new EntityExplorer((EntityDef)typeDef);
                    tex.addEntityExplorer(typeDef.getName(), eex);
                    break;
                }
                case 2: {
                    RelationshipExplorer rex = new RelationshipExplorer((RelationshipDef)typeDef);
                    tex.addRelationshipExplorer(typeDef.getName(), rex);
                    break;
                }
                case 3: {
                    ClassificationExplorer cex = new ClassificationExplorer((ClassificationDef)typeDef);
                    tex.addClassificationExplorer(typeDef.getName(), cex);
                    break;
                }
            }
        }
        List attributeTypeDefs = typeDefGallery.getAttributeTypeDefs();
        for (AttributeTypeDef attributeTypeDef : attributeTypeDefs) {
            AttributeTypeDefCategory tdCat = attributeTypeDef.getCategory();
            switch (1.$SwitchMap$org$odpi$openmetadata$repositoryservices$connectors$stores$metadatacollectionstore$properties$typedefs$AttributeTypeDefCategory[tdCat.ordinal()]) {
                case 1: {
                    tex.addEnumExplorer(attributeTypeDef.getName(), (EnumDef)attributeTypeDef);
                    break;
                }
            }
        }
        tex.resolve();
        return tex;
    }

    private LocalRepositoryServicesClient getLocalRepositoryServicesClient(String serverName, String serverURLRoot) throws InvalidParameterException {
        String restURLRoot = serverURLRoot + "/servers/" + serverName;
        LocalRepositoryServicesClient client = new LocalRepositoryServicesClient(serverName, restURLRoot);
        return client;
    }

    private EnterpriseRepositoryServicesClient getEnterpriseRepositoryServicesClient(String serverName, String serverURLRoot) throws InvalidParameterException {
        String restURLRoot = serverURLRoot + "/servers/" + serverName;
        EnterpriseRepositoryServicesClient client = new EnterpriseRepositoryServicesClient(serverName, restURLRoot);
        return client;
    }

    @PostMapping(path={"/api/instances/rex-pre-traversal"})
    public RexPreTraversalResponse rexPreTraversal(@RequestBody RexTraversalRequestBody body, HttpServletRequest request) {
        String exceptionMessage;
        Integer depth;
        String entityGUID;
        boolean enterpriseOption;
        String serverURLRoot;
        String serverName;
        try {
            serverName = body.getServerName();
            serverURLRoot = body.getServerURLRoot();
            enterpriseOption = body.getEnterpriseOption();
            entityGUID = body.getEntityGUID();
            depth = body.getDepth();
        }
        catch (Exception e) {
            String exceptionMessage2 = "The request body used in the request to /api/instances/rex-pre-traversal contained an invalid parameter or was missing a parameter. Please check the client code.";
            RexPreTraversalResponse rexPreTraversalResponse = new RexPreTraversalResponse(Integer.valueOf(400), exceptionMessage2, null);
            return rexPreTraversalResponse;
        }
        List entityTypeGUIDs = null;
        List relationshipTypeGUIDs = null;
        List classificationNames = null;
        String userId = this.getUser(request);
        Integer gen = -1;
        try {
            RexPreTraversalResponse rexPreTraversalResponse;
            InstanceGraph instGraph = this.getTraversal(userId, serverName, serverURLRoot, Boolean.valueOf(enterpriseOption), entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, classificationNames, depth);
            if (instGraph != null) {
                RexPreTraversal rexPreTraversal = new RexPreTraversal();
                rexPreTraversal.setEntityGUID(entityGUID);
                rexPreTraversal.setDepth(depth);
                List entities = instGraph.getEntities();
                HashMap<String, RexTypeStats> entityCountsByType = new HashMap<String, RexTypeStats>();
                HashMap<String, RexTypeStats> classificationCountsByType = new HashMap<String, RexTypeStats>();
                if (entities != null) {
                    for (EntityDetail ent : entities) {
                        List classifications;
                        if (ent.getGUID().equals(entityGUID)) continue;
                        InstanceType instanceType = ent.getType();
                        String typeGUID = instanceType.getTypeDefGUID();
                        String typeName = instanceType.getTypeDefName();
                        if (entityCountsByType.get(typeName) == null) {
                            RexTypeStats stats = new RexTypeStats(typeGUID, Integer.valueOf(1));
                            entityCountsByType.put(typeName, stats);
                        } else {
                            Integer existingCount = ((RexTypeStats)entityCountsByType.get(typeName)).getCount();
                            ((RexTypeStats)entityCountsByType.get(typeName)).setCount(Integer.valueOf(existingCount + 1));
                        }
                        if ((classifications = ent.getClassifications()) == null) continue;
                        for (Classification classification : classifications) {
                            String classificationName = classification.getName();
                            if (classificationCountsByType.get(classificationName) == null) {
                                RexTypeStats stats = new RexTypeStats(null, Integer.valueOf(1));
                                classificationCountsByType.put(classificationName, stats);
                                continue;
                            }
                            Integer existingCount = ((RexTypeStats)classificationCountsByType.get(classificationName)).getCount();
                            ((RexTypeStats)classificationCountsByType.get(classificationName)).setCount(Integer.valueOf(existingCount + 1));
                        }
                    }
                }
                List relationships = instGraph.getRelationships();
                HashMap<String, RexTypeStats> relationshipCountsByType = new HashMap<String, RexTypeStats>();
                if (relationships != null) {
                    for (Relationship rel : relationships) {
                        InstanceType instanceType = rel.getType();
                        String typeGUID = instanceType.getTypeDefGUID();
                        String typeName = instanceType.getTypeDefName();
                        if (relationshipCountsByType.get(typeName) == null) {
                            RexTypeStats stats = new RexTypeStats(typeGUID, Integer.valueOf(1));
                            relationshipCountsByType.put(typeName, stats);
                            continue;
                        }
                        Integer existingCount = ((RexTypeStats)relationshipCountsByType.get(typeName)).getCount();
                        ((RexTypeStats)relationshipCountsByType.get(typeName)).setCount(Integer.valueOf(existingCount + 1));
                    }
                }
                rexPreTraversal.setEntityInstanceCounts(entityCountsByType);
                rexPreTraversal.setRelationshipInstanceCounts(relationshipCountsByType);
                rexPreTraversal.setClassificationInstanceCounts(classificationCountsByType);
                rexPreTraversalResponse = new RexPreTraversalResponse(Integer.valueOf(200), "", rexPreTraversal);
            } else {
                String excMsg = "Could not retrieve subgraph for entity with guid" + entityGUID;
                rexPreTraversalResponse = new RexPreTraversalResponse(Integer.valueOf(400), excMsg, null);
            }
            return rexPreTraversalResponse;
        }
        catch (UserNotAuthorizedException e) {
            exceptionMessage = "Sorry - this username was not authorized to perform the request";
        }
        catch (RepositoryErrorException e) {
            exceptionMessage = "The repository could not be reached, please check the server name and URL root and verify that the server is running ";
        }
        catch (InvalidParameterException e) {
            exceptionMessage = "The request to load type information reported an invalid parameter, please check the server name and URL root parameters";
        }
        catch (EntityNotKnownException e) {
            exceptionMessage = "The system could not find an entity with the GUID specified - please check the GUID and try again";
        }
        catch (EntityProxyOnlyException e) {
            exceptionMessage = "The system could only find an entity proxy using the GUID specified - please check the GUID and try again";
        }
        catch (TypeErrorException e) {
            exceptionMessage = "There was a problem with Type information - please check and retry";
        }
        catch (PropertyErrorException e) {
            exceptionMessage = "There was a problem with Property information - please check and retry";
        }
        catch (FunctionNotSupportedException e) {
            exceptionMessage = "The UI tried to use an unsupported function";
        }
        RexPreTraversalResponse rexPreTraversalResponse = new RexPreTraversalResponse(Integer.valueOf(400), exceptionMessage, null);
        return rexPreTraversalResponse;
    }

    @PostMapping(path={"/api/instances/rex-traversal"})
    public RexTraversalResponse rexTraversal(@RequestBody RexTraversalRequestBody body, HttpServletRequest request) {
        String exceptionMessage;
        List classificationNames;
        List relationshipTypeGUIDs;
        List entityTypeGUIDs;
        Integer gen;
        Integer depth;
        String entityGUID;
        boolean enterpriseOption;
        String serverURLRoot;
        String serverName;
        try {
            serverName = body.getServerName();
            serverURLRoot = body.getServerURLRoot();
            enterpriseOption = body.getEnterpriseOption();
            entityGUID = body.getEntityGUID();
            depth = body.getDepth();
            gen = body.getGen();
            entityTypeGUIDs = body.getEntityTypeGUIDs();
            relationshipTypeGUIDs = body.getRelationshipTypeGUIDs();
            classificationNames = body.getClassificationNames();
        }
        catch (Exception e) {
            String exceptionMessage2 = "The request body used in the request to /api/instances/rex-traversal contained an invalid parameter or was missing a parameter. Please check the client code.";
            RexTraversalResponse rexTraversalResponse = new RexTraversalResponse(Integer.valueOf(400), exceptionMessage2, null);
            return rexTraversalResponse;
        }
        String userId = this.getUser(request);
        Object typeDefGallery = null;
        try {
            RexTraversalResponse rexTraversalResponse;
            TypeExplorer typeExplorer = this.getTypeExplorer(userId, serverName, serverURLRoot, enterpriseOption);
            InstanceGraph instGraph = this.getTraversal(userId, serverName, serverURLRoot, Boolean.valueOf(enterpriseOption), entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, classificationNames, depth);
            if (instGraph != null) {
                RexTraversal rt = new RexTraversal();
                List entities = instGraph.getEntities();
                HashMap<Object, RexEntityDigest> entityDigestMap = null;
                if (entities != null && !entities.isEmpty()) {
                    entityDigestMap = new HashMap<Object, RexEntityDigest>();
                    for (EntityDetail entityDetail : entities) {
                        String entGUID = entityDetail.getGUID();
                        String entLabel = this.chooseLabelForEntity(entityDetail, typeExplorer);
                        RexEntityDigest red = new RexEntityDigest(entGUID, entLabel, gen, entityDetail.getMetadataCollectionName());
                        entityDigestMap.put(entGUID, red);
                    }
                }
                List relationships = instGraph.getRelationships();
                HashMap<String, RexRelationshipDigest> relationshipDigestMap = null;
                if (relationships != null && !relationships.isEmpty()) {
                    relationshipDigestMap = new HashMap<String, RexRelationshipDigest>();
                    for (Relationship relationship : relationships) {
                        RexEntityDigest red;
                        String relGUID = relationship.getGUID();
                        String relLabel = this.chooseLabelForRelationship(relationship);
                        String end1GUID = relationship.getEntityOneProxy().getGUID();
                        String end2GUID = relationship.getEntityTwoProxy().getGUID();
                        if (entityDigestMap.get(end1GUID) == null) {
                            EntityProxy end1Proxy = relationship.getEntityOneProxy();
                            String end1Label = this.chooseLabelForEntityProxy(end1Proxy, typeExplorer);
                            red = new RexEntityDigest(end1GUID, end1Label, gen, end1Proxy.getMetadataCollectionName());
                            entityDigestMap.put(end1GUID, red);
                        }
                        if (entityDigestMap.get(end2GUID) == null) {
                            EntityProxy end2Proxy = relationship.getEntityTwoProxy();
                            String end2Label = this.chooseLabelForEntityProxy(end2Proxy, typeExplorer);
                            red = new RexEntityDigest(end2GUID, end2Label, gen, end2Proxy.getMetadataCollectionName());
                            entityDigestMap.put(end2GUID, red);
                        }
                        int idx = 0;
                        RexRelationshipDigest rrd = new RexRelationshipDigest(relGUID, relLabel, end1GUID, end2GUID, Integer.valueOf(idx), gen, relationship.getMetadataCollectionName());
                        relationshipDigestMap.put(relGUID, rrd);
                    }
                }
                rt.setEntityGUID(entityGUID);
                rt.setDepth(depth);
                rt.setGen(gen);
                ArrayList<String> entityTypeNames = new ArrayList<String>();
                if (entityTypeGUIDs != null && !entityTypeGUIDs.isEmpty()) {
                    for (String entityTypeGUID : entityTypeGUIDs) {
                        String entityTypeName = typeExplorer.getEntityTypeName(entityTypeGUID);
                        entityTypeNames.add(entityTypeName);
                    }
                }
                rt.setEntityTypeNames(entityTypeNames);
                rt.setRelationshipTypeGUIDs(relationshipTypeGUIDs);
                rt.setClassificationNames(classificationNames);
                rt.setEntities(entityDigestMap);
                rt.setRelationships(relationshipDigestMap);
                rt.setServerName(serverName);
                rexTraversalResponse = new RexTraversalResponse(Integer.valueOf(200), "", rt);
            } else {
                String excMsg = "Could not retrieve subgraph for entity with guid" + entityGUID;
                rexTraversalResponse = new RexTraversalResponse(Integer.valueOf(400), excMsg, null);
            }
            return rexTraversalResponse;
        }
        catch (UserNotAuthorizedException e) {
            exceptionMessage = "Sorry - this username was not authorized to perform the request";
        }
        catch (RepositoryErrorException e) {
            exceptionMessage = "The repository could not be reached, please check the server name and URL root and verify that the server is running ";
        }
        catch (InvalidParameterException e) {
            exceptionMessage = "The request to load type information reported an invalid parameter, please check the server name and URL root parameters";
        }
        catch (EntityNotKnownException e) {
            exceptionMessage = "The system could not find an entity with the GUID specified - please check the GUID and try again";
        }
        catch (EntityProxyOnlyException e) {
            exceptionMessage = "The system could only find an entity proxy using the GUID specified - please check the GUID and try again";
        }
        catch (TypeErrorException e) {
            exceptionMessage = "There was a problem with Type information - please check and retry";
        }
        catch (PropertyErrorException e) {
            exceptionMessage = "There was a problem with Property information - please check and retry";
        }
        catch (FunctionNotSupportedException e) {
            exceptionMessage = "The UI tried to use an unsupported function";
        }
        RexTraversalResponse rexTraversalResponse = new RexTraversalResponse(Integer.valueOf(400), exceptionMessage, null);
        return rexTraversalResponse;
    }

    private String chooseLabelForEntity(EntityDetail entityDetail, TypeExplorer typeExplorer) {
        String effTypeName;
        String label = entityDetail.getGUID();
        String instanceTypeName = null;
        InstanceType instanceType = entityDetail.getType();
        if (instanceType != null) {
            instanceTypeName = instanceType.getTypeDefName();
        }
        if (instanceTypeName == null || instanceTypeName.equals("")) {
            return label;
        }
        Map entityTypes = typeExplorer.getEntities();
        EntityExplorer eex = (EntityExplorer)entityTypes.get(instanceTypeName);
        TypeDefLink superType = eex.getEntityDef().getSuperType();
        while (superType != null) {
            String superTypeName = superType.getName();
            eex = (EntityExplorer)entityTypes.get(superTypeName);
            superType = eex.getEntityDef().getSuperType();
        }
        EntityDef effectiveTypeDef = eex.getEntityDef();
        switch (effTypeName = effectiveTypeDef.getName()) {
            case "InformalTag": {
                if (entityDetail.getProperties() == null || entityDetail.getProperties().getInstanceProperties() == null || entityDetail.getProperties().getInstanceProperties().get("tagName") == null || ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("tagName")).valueAsString() == null) break;
                label = ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("tagName")).valueAsString();
                break;
            }
            case "Like": 
            case "Rating": {
                if (entityDetail.getCreatedBy() == null) break;
                label = entityDetail.getCreatedBy();
                break;
            }
            case "DataField": {
                if (entityDetail.getProperties() == null || entityDetail.getProperties().getInstanceProperties() == null || entityDetail.getProperties().getInstanceProperties().get("dataFieldName") == null || ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("dataFieldName")).valueAsString() == null) break;
                label = ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("dataFieldName")).valueAsString();
                break;
            }
            case "Annotation": 
            case "AnnotationReview": {
                if (instanceTypeName == null) break;
                label = instanceTypeName;
                break;
            }
            case "LastAttachment": {
                if (entityDetail.getProperties() == null || entityDetail.getProperties().getInstanceProperties() == null || entityDetail.getProperties().getInstanceProperties().get("attachmentType") == null || ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("attachmentType")).valueAsString() == null) break;
                label = ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("attachmentType")).valueAsString();
                break;
            }
            default: {
                String tailQN;
                if (entityDetail.getProperties() != null && entityDetail.getProperties().getInstanceProperties() != null && entityDetail.getProperties().getInstanceProperties().get("displayName") != null && ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("displayName")).valueAsString() != null) {
                    label = ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("displayName")).valueAsString();
                    break;
                }
                if (entityDetail.getProperties() != null && entityDetail.getProperties().getInstanceProperties() != null && entityDetail.getProperties().getInstanceProperties().get("name") != null && ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("name")).valueAsString() != null) {
                    label = ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("name")).valueAsString();
                    break;
                }
                if (entityDetail.getProperties() == null || entityDetail.getProperties().getInstanceProperties() == null || entityDetail.getProperties().getInstanceProperties().get("qualifiedName") == null) break;
                String fullQN = ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("qualifiedName")).valueAsString();
                int lengthQN = fullQN.length();
                label = lengthQN > 24 ? (tailQN = "..." + fullQN.substring(lengthQN - 24, lengthQN)) : fullQN;
            }
        }
        return label;
    }

    private String chooseLabelForEntityProxy(EntityProxy entityProxy, TypeExplorer typeExplorer) {
        String effTypeName;
        String label = entityProxy.getGUID();
        String instanceTypeName = null;
        InstanceType instanceType = entityProxy.getType();
        if (instanceType != null) {
            instanceTypeName = instanceType.getTypeDefName();
        }
        if (instanceTypeName == null || instanceTypeName.equals("")) {
            return label;
        }
        Map entityTypes = typeExplorer.getEntities();
        EntityExplorer eex = (EntityExplorer)entityTypes.get(instanceTypeName);
        TypeDefLink superType = eex.getEntityDef().getSuperType();
        while (superType != null) {
            String superTypeName = superType.getName();
            eex = (EntityExplorer)entityTypes.get(superTypeName);
            superType = eex.getEntityDef().getSuperType();
        }
        EntityDef effectiveTypeDef = eex.getEntityDef();
        switch (effTypeName = effectiveTypeDef.getName()) {
            case "InformalTag": {
                if (entityProxy.getUniqueProperties() == null || entityProxy.getUniqueProperties().getInstanceProperties() == null || entityProxy.getUniqueProperties().getInstanceProperties().get("tagName") == null || ((InstancePropertyValue)entityProxy.getUniqueProperties().getInstanceProperties().get("tagName")).valueAsString() == null) break;
                label = ((InstancePropertyValue)entityProxy.getUniqueProperties().getInstanceProperties().get("tagName")).valueAsString();
                break;
            }
            case "Like": 
            case "Rating": {
                if (entityProxy.getCreatedBy() == null) break;
                label = entityProxy.getCreatedBy();
                break;
            }
            case "DataField": {
                if (entityProxy.getUniqueProperties() == null || entityProxy.getUniqueProperties().getInstanceProperties() == null || entityProxy.getUniqueProperties().getInstanceProperties().get("dataFieldName") == null || ((InstancePropertyValue)entityProxy.getUniqueProperties().getInstanceProperties().get("dataFieldName")).valueAsString() == null) break;
                label = ((InstancePropertyValue)entityProxy.getUniqueProperties().getInstanceProperties().get("dataFieldName")).valueAsString();
                break;
            }
            case "Annotation": 
            case "AnnotationReview": {
                if (instanceTypeName == null) break;
                label = instanceTypeName;
                break;
            }
            default: {
                String tailQN;
                if (entityProxy.getUniqueProperties() != null && entityProxy.getUniqueProperties().getInstanceProperties() != null && entityProxy.getUniqueProperties().getInstanceProperties().get("displayName") != null && ((InstancePropertyValue)entityProxy.getUniqueProperties().getInstanceProperties().get("displayName")).valueAsString() != null) {
                    label = ((InstancePropertyValue)entityProxy.getUniqueProperties().getInstanceProperties().get("displayName")).valueAsString();
                    break;
                }
                if (entityProxy.getUniqueProperties() != null && entityProxy.getUniqueProperties().getInstanceProperties() != null && entityProxy.getUniqueProperties().getInstanceProperties().get("name") != null && ((InstancePropertyValue)entityProxy.getUniqueProperties().getInstanceProperties().get("name")).valueAsString() != null) {
                    label = ((InstancePropertyValue)entityProxy.getUniqueProperties().getInstanceProperties().get("name")).valueAsString();
                    break;
                }
                if (entityProxy.getUniqueProperties() == null || entityProxy.getUniqueProperties().getInstanceProperties() == null || entityProxy.getUniqueProperties().getInstanceProperties().get("qualifiedName") == null) break;
                String fullQN = ((InstancePropertyValue)entityProxy.getUniqueProperties().getInstanceProperties().get("qualifiedName")).valueAsString();
                int lengthQN = fullQN.length();
                label = lengthQN > 24 ? (tailQN = "..." + fullQN.substring(lengthQN - 24, lengthQN)) : fullQN;
            }
        }
        return label;
    }

    private String chooseLabelForRelationship(Relationship relationship) {
        String label = relationship.getGUID();
        String instanceTypeName = null;
        InstanceType instanceType = relationship.getType();
        if (instanceType != null) {
            instanceTypeName = instanceType.getTypeDefName();
        }
        if (instanceTypeName == null || instanceTypeName.equals("")) {
            return label;
        }
        label = instanceTypeName;
        return label;
    }

    private InstanceGraph getTraversal(String userId, String serverName, String serverURLRoot, Boolean enterpriseOption, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<String> classificationNames, Integer depth) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException, EntityNotKnownException, EntityProxyOnlyException, TypeErrorException, PropertyErrorException, FunctionNotSupportedException {
        String methodName = "getTraversal";
        if (entityGUID == null) {
            String parameterName = "entityGUID";
            throw new InvalidParameterException(RexErrorCode.NO_GUID.getMessageDefinition(new String[]{entityGUID, methodName, serverName}), this.getClass().getName(), methodName, "entityGUID");
        }
        if (depth < 0) {
            String parameterName = "depth";
            throw new InvalidParameterException(RexErrorCode.INVALID_VALUE.getMessageDefinition(new String[]{depth.toString(), methodName, serverName}), this.getClass().getName(), methodName, "depth");
        }
        Object repositoryServicesClient = enterpriseOption == false ? this.getLocalRepositoryServicesClient(serverName, serverURLRoot) : this.getEnterpriseRepositoryServicesClient(serverName, serverURLRoot);
        if (depth > 0) {
            InstanceGraph instGraph = repositoryServicesClient.getEntityNeighborhood(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, null, classificationNames, null, depth.intValue());
            if (instGraph != null) {
                return instGraph;
            }
            return null;
        }
        EntityDetail entityDetail = this.metadataCollection.getEntityDetail(userId, entityGUID);
        if (entityDetail != null) {
            InstanceGraph instGraph = new InstanceGraph();
            ArrayList<EntityDetail> entityDetailList = new ArrayList<EntityDetail>();
            entityDetailList.add(entityDetail);
            instGraph.setEntities(entityDetailList);
            return instGraph;
        }
        String parameterName = "entityGUID";
        throw new InvalidParameterException(RexErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(new String[]{entityGUID, methodName, serverName}), this.getClass().getName(), methodName, "entityGUID");
    }

    @PostMapping(path={"/api/instances/entity"})
    public RexEntityDetailResponse getEntityDetail(@RequestBody RexEntityRequestBody body, HttpServletRequest request) {
        String exceptionMessage;
        String entityGUID;
        boolean enterpriseOption;
        String serverURLRoot;
        String serverName;
        try {
            serverName = body.getServerName();
            serverURLRoot = body.getServerURLRoot();
            enterpriseOption = body.getEnterpriseOption();
            entityGUID = body.getEntityGUID();
        }
        catch (Exception e) {
            String exceptionMessage2 = "The request body used in the request to /api/instances/rex-traversal contained an invalid parameter or was missing a parameter. Please check the client code.";
            RexEntityDetailResponse response = new RexEntityDetailResponse(Integer.valueOf(400), exceptionMessage2, null);
            return response;
        }
        String userId = this.getUser(request);
        try {
            RexEntityDetailResponse response;
            EntityDetail entityDetail = this.getEntityDetail(userId, serverName, serverURLRoot, enterpriseOption, entityGUID);
            if (entityDetail != null) {
                TypeExplorer typeExplorer = this.getTypeExplorer(userId, serverName, serverURLRoot, enterpriseOption);
                String label = this.chooseLabelForEntity(entityDetail, typeExplorer);
                RexExpandedEntityDetail rexExpEntityDetail = new RexExpandedEntityDetail(entityDetail, label, serverName);
                response = new RexEntityDetailResponse(Integer.valueOf(200), "", rexExpEntityDetail);
            } else {
                String excMsg = "Could not retrieve entity with guid" + entityGUID;
                response = new RexEntityDetailResponse(Integer.valueOf(400), excMsg, null);
            }
            return response;
        }
        catch (UserNotAuthorizedException e) {
            exceptionMessage = "Sorry - this username was not authorized to perform the request";
        }
        catch (RepositoryErrorException e) {
            exceptionMessage = "The repository could not be reached, please check the server name and URL root and verify that the server is running ";
        }
        catch (InvalidParameterException e) {
            exceptionMessage = "The request to load type information reported an invalid parameter, please check the server name and URL root parameters";
        }
        catch (EntityNotKnownException e) {
            exceptionMessage = "The system could not find an entity with the GUID specified - please check the GUID and try again";
        }
        catch (EntityProxyOnlyException e) {
            exceptionMessage = "The system could only find an entity proxy using the GUID specified - please check the GUID and try again";
        }
        RexEntityDetailResponse response = new RexEntityDetailResponse(Integer.valueOf(400), exceptionMessage, null);
        return response;
    }

    private EntityDetail getEntityDetail(String userId, String serverName, String serverURLRoot, boolean enterpriseOption, String entityGUID) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException, EntityNotKnownException, EntityProxyOnlyException {
        String methodName = "getEntityDetail";
        if (entityGUID == null) {
            String parameterName = "entityGUID";
            throw new InvalidParameterException(RexErrorCode.NO_GUID.getMessageDefinition(new String[]{entityGUID, methodName, serverName}), this.getClass().getName(), methodName, "entityGUID");
        }
        if (entityGUID == "trouble-at-mill") {
            String parameterName = "entityGUID";
            throw new InvalidParameterException(RexErrorCode.TROUBLE_AT_MILL.getMessageDefinition(new String[]{entityGUID, methodName, serverName}), this.getClass().getName(), methodName, "entityGUID");
        }
        Object repositoryServicesClient = !enterpriseOption ? this.getLocalRepositoryServicesClient(serverName, serverURLRoot) : this.getEnterpriseRepositoryServicesClient(serverName, serverURLRoot);
        EntityDetail entityDetail = repositoryServicesClient.getEntityDetail(userId, entityGUID);
        if (entityDetail != null) {
            return entityDetail;
        }
        String parameterName = "entityGUID";
        throw new InvalidParameterException(RexErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(new String[]{entityGUID, methodName, serverName}), this.getClass().getName(), methodName, "entityGUID");
    }

    @PostMapping(path={"/api/instances/relationship"})
    public RexRelationshipResponse getRelationship(@RequestBody RexRelationshipRequestBody body, HttpServletRequest request) {
        String exceptionMessage;
        String relationshipGUID;
        boolean enterpriseOption;
        String serverURLRoot;
        String serverName;
        try {
            serverName = body.getServerName();
            serverURLRoot = body.getServerURLRoot();
            enterpriseOption = body.getEnterpriseOption();
            relationshipGUID = body.getRelationshipGUID();
        }
        catch (Exception e) {
            String exceptionMessage2 = "The request body used in the request to /api/instances/rex-traversal contained an invalid parameter or was missing a parameter. Please check the client code.";
            RexRelationshipResponse response = new RexRelationshipResponse(Integer.valueOf(400), exceptionMessage2, null);
            return response;
        }
        String userId = this.getUser(request);
        try {
            RexRelationshipResponse response;
            Relationship relationship = this.getRelationship(userId, serverName, serverURLRoot, enterpriseOption, relationshipGUID);
            if (relationship != null) {
                TypeExplorer typeExplorer = this.getTypeExplorer(userId, serverName, serverURLRoot, enterpriseOption);
                EntityProxy entity1 = relationship.getEntityOneProxy();
                EntityProxy entity2 = relationship.getEntityTwoProxy();
                String label1 = this.chooseLabelForEntityProxy(entity1, typeExplorer);
                String label2 = this.chooseLabelForEntityProxy(entity2, typeExplorer);
                RexEntityDigest digest1 = new RexEntityDigest(entity1.getGUID(), label1, Integer.valueOf(0), entity1.getMetadataCollectionName());
                RexEntityDigest digest2 = new RexEntityDigest(entity2.getGUID(), label2, Integer.valueOf(0), entity2.getMetadataCollectionName());
                String label = this.chooseLabelForRelationship(relationship);
                RexExpandedRelationship rexExpRelationship = new RexExpandedRelationship(relationship, label, digest1, digest2, serverName);
                response = new RexRelationshipResponse(Integer.valueOf(200), "", rexExpRelationship);
            } else {
                String excMsg = "Could not retrieve relationship with guid" + relationshipGUID;
                response = new RexRelationshipResponse(Integer.valueOf(400), excMsg, null);
            }
            return response;
        }
        catch (UserNotAuthorizedException e) {
            exceptionMessage = "Sorry - this username was not authorized to perform the request";
        }
        catch (RepositoryErrorException e) {
            exceptionMessage = "The repository could not be reached, please check the server name and URL root and verify that the server is running ";
        }
        catch (InvalidParameterException e) {
            exceptionMessage = "The request to load type information reported an invalid parameter, please check the server name and URL root parameters";
        }
        catch (RelationshipNotKnownException e) {
            exceptionMessage = "The system could not find an relationship with the GUID specified - please check the GUID and try again";
        }
        RexRelationshipResponse response = new RexRelationshipResponse(Integer.valueOf(400), exceptionMessage, null);
        return response;
    }

    private Relationship getRelationship(String userId, String serverName, String serverURLRoot, boolean enterpriseOption, String relationshipGUID) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException, RelationshipNotKnownException {
        String methodName = "getRelationship";
        if (relationshipGUID == null) {
            String parameterName = "relationshipGUID";
            throw new InvalidParameterException(RexErrorCode.NO_GUID.getMessageDefinition(new String[]{relationshipGUID, methodName, serverName}), this.getClass().getName(), methodName, "relationshipGUID");
        }
        Object repositoryServicesClient = !enterpriseOption ? this.getLocalRepositoryServicesClient(serverName, serverURLRoot) : this.getEnterpriseRepositoryServicesClient(serverName, serverURLRoot);
        Relationship relationship = repositoryServicesClient.getRelationship(userId, relationshipGUID);
        if (relationship != null) {
            return relationship;
        }
        String parameterName = "relationshipGUID";
        throw new InvalidParameterException(RexErrorCode.RELATIONSHIP_NOT_KNOWN.getMessageDefinition(new String[]{relationshipGUID, methodName, serverName}), this.getClass().getName(), methodName, "relationshipGUID");
    }

    @PostMapping(path={"/api/instances/entities/by-property-value"})
    public RexSearchResponse entitySearch(@RequestBody RexSearchBody body, HttpServletRequest request) {
        String exceptionMessage;
        String searchText;
        String entityTypeName;
        boolean enterpriseOption;
        String serverURLRoot;
        String serverName;
        String searchCategory = "Entity";
        try {
            serverName = body.getServerName();
            serverURLRoot = body.getServerURLRoot();
            enterpriseOption = body.getEnterpriseOption();
            entityTypeName = body.getTypeName();
            searchText = body.getSearchText();
        }
        catch (Exception e) {
            String exceptionMessage2 = "The request body used in the request to /api/instances/rex-traversal contained an invalid parameter or was missing a parameter. Please check the client code.";
            RexSearchResponse response = new RexSearchResponse(Integer.valueOf(400), exceptionMessage2, null, null, searchCategory, null, null);
            return response;
        }
        String userId = this.getUser(request);
        String entityTypeGUID = null;
        try {
            RexSearchResponse response;
            TypeExplorer typeExplorer = this.getTypeExplorer(userId, serverName, serverURLRoot, enterpriseOption);
            entityTypeGUID = typeExplorer.getEntityTypeGUID(entityTypeName);
            List entities = this.findEntities(userId, serverName, serverURLRoot, enterpriseOption, searchText, entityTypeGUID);
            if (entities != null) {
                HashMap<String, RexEntityDigest> digestMap = new HashMap<String, RexEntityDigest>();
                for (int e = 0; e < entities.size(); ++e) {
                    EntityDetail entityDetail = (EntityDetail)entities.get(e);
                    String label = this.chooseLabelForEntity(entityDetail, typeExplorer);
                    RexEntityDigest entityDigest = new RexEntityDigest(entityDetail.getGUID(), label, Integer.valueOf(0), entityDetail.getMetadataCollectionName());
                    digestMap.put(entityDetail.getGUID(), entityDigest);
                }
                response = new RexSearchResponse(Integer.valueOf(200), "", serverName, searchText, searchCategory, digestMap, null);
            } else {
                String excMsg = "Could not find any entities that matched " + searchText;
                response = new RexSearchResponse(Integer.valueOf(400), excMsg, serverName, searchText, searchCategory, null, null);
            }
            return response;
        }
        catch (UserNotAuthorizedException e) {
            exceptionMessage = "Sorry - this username was not authorized to perform the request";
        }
        catch (RepositoryErrorException e) {
            exceptionMessage = "The repository could not be reached, please check the server name and URL root and verify that the server is running ";
        }
        catch (InvalidParameterException e) {
            exceptionMessage = "The request to load type information reported an invalid parameter, please check the server name and URL root parameters";
        }
        catch (TypeErrorException e) {
            exceptionMessage = "There was a problem with Type information - please check and retry";
        }
        catch (PropertyErrorException e) {
            exceptionMessage = "There was a problem with Property information - please check and retry";
        }
        catch (PagingErrorException e) {
            exceptionMessage = "There was a problem with Paging - please check and retry";
        }
        catch (FunctionNotSupportedException e) {
            exceptionMessage = "The UI tried to use an unsupported function";
        }
        RexSearchResponse response = new RexSearchResponse(Integer.valueOf(400), exceptionMessage, serverName, searchText, searchCategory, null, null);
        return response;
    }

    private List<EntityDetail> findEntities(String userId, String serverName, String serverURLRoot, boolean enterpriseOption, String searchText, String entityTypeGUID) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException {
        String methodName = "findEntities";
        if (searchText == null) {
            String parameterName = "searchText";
            throw new InvalidParameterException(RexErrorCode.INVALID_VALUE.getMessageDefinition(new String[]{searchText, methodName, serverName}), this.getClass().getName(), methodName, "searchText");
        }
        Object repositoryServicesClient = !enterpriseOption ? this.getLocalRepositoryServicesClient(serverName, serverURLRoot) : this.getEnterpriseRepositoryServicesClient(serverName, serverURLRoot);
        List entityList = repositoryServicesClient.findEntitiesByPropertyValue(userId, entityTypeGUID, searchText, 0, null, null, null, null, null, 0);
        if (entityList != null) {
            return entityList;
        }
        return null;
    }

    @PostMapping(path={"/api/instances/relationships/by-property-value"})
    public RexSearchResponse relationshipSearch(@RequestBody RexSearchBody body, HttpServletRequest request) {
        String exceptionMessage;
        String searchText;
        String relationshipTypeName;
        boolean enterpriseOption;
        String serverURLRoot;
        String serverName;
        String searchCategory = "Relationship";
        try {
            serverName = body.getServerName();
            serverURLRoot = body.getServerURLRoot();
            enterpriseOption = body.getEnterpriseOption();
            relationshipTypeName = body.getTypeName();
            searchText = body.getSearchText();
        }
        catch (Exception e) {
            String exceptionMessage2 = "The request body used in the request to /api/instances/rex-traversal contained an invalid parameter or was missing a parameter. Please check the client code.";
            RexSearchResponse response = new RexSearchResponse(Integer.valueOf(400), exceptionMessage2, null, null, searchCategory, null, null);
            return response;
        }
        String userId = this.getUser(request);
        String relationshipTypeGUID = null;
        try {
            RexSearchResponse response;
            TypeExplorer typeExplorer = this.getTypeExplorer(userId, serverName, serverURLRoot, enterpriseOption);
            relationshipTypeGUID = typeExplorer.getRelationshipTypeGUID(relationshipTypeName);
            List relationships = this.findRelationships(userId, serverName, serverURLRoot, enterpriseOption, searchText, relationshipTypeGUID);
            if (relationships != null) {
                HashMap<String, RexRelationshipDigest> digestMap = new HashMap<String, RexRelationshipDigest>();
                for (int e = 0; e < relationships.size(); ++e) {
                    Relationship relationship = (Relationship)relationships.get(e);
                    String label = this.chooseLabelForRelationship(relationship);
                    RexRelationshipDigest relationshipDigest = new RexRelationshipDigest(relationship.getGUID(), label, relationship.getEntityOneProxy().getGUID(), relationship.getEntityTwoProxy().getGUID(), Integer.valueOf(0), Integer.valueOf(0), relationship.getMetadataCollectionName());
                    digestMap.put(relationship.getGUID(), relationshipDigest);
                }
                response = new RexSearchResponse(Integer.valueOf(200), "", serverName, searchText, searchCategory, null, digestMap);
            } else {
                String excMsg = "Could not find any entities that matched " + searchText;
                response = new RexSearchResponse(Integer.valueOf(400), excMsg, serverName, searchText, searchCategory, null, null);
            }
            return response;
        }
        catch (UserNotAuthorizedException e) {
            exceptionMessage = "Sorry - this username was not authorized to perform the request";
        }
        catch (RepositoryErrorException e) {
            exceptionMessage = "The repository could not be reached, please check the server name and URL root and verify that the server is running ";
        }
        catch (InvalidParameterException e) {
            exceptionMessage = "The request to load type information reported an invalid parameter, please check the server name and URL root parameters";
        }
        catch (TypeErrorException e) {
            exceptionMessage = "There was a problem with Type information - please check and retry";
        }
        catch (PropertyErrorException e) {
            exceptionMessage = "There was a problem with Property information - please check and retry";
        }
        catch (PagingErrorException e) {
            exceptionMessage = "There was a problem with Paging - please check and retry";
        }
        catch (FunctionNotSupportedException e) {
            exceptionMessage = "The UI tried to use an unsupported function";
        }
        RexSearchResponse response = new RexSearchResponse(Integer.valueOf(400), exceptionMessage, serverName, searchText, searchCategory, null, null);
        return response;
    }

    private List<Relationship> findRelationships(String userId, String serverName, String serverURLRoot, boolean enterpriseOption, String searchText, String relationshipTypeGUID) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException {
        String methodName = "findRelationships";
        if (searchText == null) {
            String parameterName = "searchText";
            throw new InvalidParameterException(RexErrorCode.INVALID_VALUE.getMessageDefinition(new String[]{searchText, methodName, serverName}), this.getClass().getName(), methodName, "searchText");
        }
        Object repositoryServicesClient = !enterpriseOption ? this.getLocalRepositoryServicesClient(serverName, serverURLRoot) : this.getEnterpriseRepositoryServicesClient(serverName, serverURLRoot);
        List relationshipList = repositoryServicesClient.findRelationshipsByPropertyValue(userId, relationshipTypeGUID, searchText, 0, null, null, null, null, 0);
        if (relationshipList != null) {
            return relationshipList;
        }
        return null;
    }
}

