/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.AuthService;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.TokenSettings;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.TokenUser;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.UserAuthentication;
import org.odpi.openmetadata.userinterface.uichassis.springboot.domain.User;
import org.springframework.security.core.Authentication;
import org.springframework.util.ObjectUtils;

public class SessionAuthService
extends TokenSettings
implements AuthService {
    public static final String USER_ATTRIBUTE_NAME = "user";

    public User addAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        TokenUser tokenUser = this.getTokenUser(authentication);
        request.getSession().setAttribute(USER_ATTRIBUTE_NAME, (Object)this.toJSON(tokenUser.getUser()));
        String token = this.createTokenForUser(tokenUser.getUser(), this.tokenSecret);
        response.addHeader("x-auth-token", token);
        return tokenUser.getUser();
    }

    public Authentication getAuthentication(HttpServletRequest request) {
        User user;
        Object userJSON = request.getSession().getAttribute(USER_ATTRIBUTE_NAME);
        if (!ObjectUtils.isEmpty((Object)userJSON) && (user = this.fromJSON(String.valueOf(userJSON))) != null) {
            return new UserAuthentication(new TokenUser(user));
        }
        return null;
    }
}

