/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot;

import javax.annotation.PostConstruct;
import org.odpi.openmetadata.accessservices.assetcatalog.AssetCatalog;
import org.odpi.openmetadata.accessservices.glossaryview.client.GlossaryViewClient;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.governanceservers.openlineage.client.OpenLineageClient;
import org.odpi.openmetadata.http.HttpHelper;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.AuthService;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.RedisAuthService;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.SessionAuthService;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.TokenAuthService;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.TokenClient;
import org.odpi.openmetadata.userinterface.uichassis.springboot.service.ComponentService;
import org.odpi.openmetadata.userinterface.uichassis.springboot.service.LineageGraphDisplayRulesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@SpringBootApplication
@ComponentScan(basePackages={"${scan.packages}"})
@Configuration
@EnableConfigurationProperties(value={ComponentService.class, LineageGraphDisplayRulesService.class})
public class EgeriaUIPlatform {
    private static final Logger LOG = LoggerFactory.getLogger(EgeriaUIPlatform.class);
    @Autowired
    private Environment env;
    @Value(value="${strict.ssl}")
    Boolean strictSSL;
    @Value(value="${cors.allowed-origins}")
    String[] allowedOrigins;

    public static void main(String[] args) {
        SpringApplication.run(EgeriaUIPlatform.class, (String[])args);
    }

    @Bean
    public InitializingBean getInitialize() {
        return () -> {
            if (!this.strictSSL.booleanValue()) {
                HttpHelper.noStrictSSL();
            }
        };
    }

    @Bean
    public AssetCatalog getAssetCatalog(@Value(value="${omas.server.url}") String serverUrl, @Value(value="${omas.server.name}") String serverName) throws InvalidParameterException {
        return new AssetCatalog(serverName, serverUrl);
    }

    @Bean
    public GlossaryViewClient getGlossaryViewClient(@Value(value="${omas.server.url}") String serverUrl, @Value(value="${omas.server.name}") String serverName) throws InvalidParameterException {
        return new GlossaryViewClient(serverName, serverUrl);
    }

    @Bean
    public OpenLineageClient getOpenLineage(@Value(value="${open.lineage.server.url}") String serverUrl, @Value(value="${open.lineage.server.name}") String serverName) throws InvalidParameterException {
        return new OpenLineageClient(serverName, serverUrl);
    }

    @Bean
    public AuthService getAuthService(@Value(value="${authentication.mode:token}") String authenticationMode) {
        if ("token".equals(authenticationMode)) {
            return new TokenAuthService();
        }
        if ("redis".equals(authenticationMode)) {
            return new RedisAuthService();
        }
        return new SessionAuthService();
    }

    @Bean(value={"tokenClient"})
    @ConditionalOnProperty(value={"authentication.mode"}, havingValue="token", matchIfMissing=true)
    public TokenClient stateLessTokenClient() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @PostConstruct
    private void configureTrustStore() {
        if (this.strictSSL.booleanValue() && System.getProperty("javax.net.ssl.trustStore") == null) {
            System.setProperty("javax.net.ssl.trustStore", this.env.getProperty("server.ssl.trust-store"));
            System.setProperty("javax.net.ssl.trustStorePassword", this.env.getProperty("server.ssl.trust-store-password"));
        }
    }
}

