/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth.db;

import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.db.UserRepository;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.db.domain.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.authentication.AccountStatusUserDetailsChecker;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service(value="dbUserDetailsService")
@ConditionalOnProperty(value={"authentication.source"}, havingValue="db")
public class UserDetailsServiceImpl
implements UserDetailsService {
    @Autowired
    private UserRepository userRepo;
    private final AccountStatusUserDetailsChecker detailsChecker = new AccountStatusUserDetailsChecker();

    public final User loadUserByUsername(String username) throws UsernameNotFoundException {
        User user = (User)this.userRepo.findOneByUsername(username).orElseThrow(() -> new UsernameNotFoundException(""));
        this.detailsChecker.check((UserDetails)user);
        return user;
    }
}

