/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth;

import java.io.IOException;
import java.util.Collections;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.MDC;

public class LoggingRequestFilter
implements Filter {
    private String path;

    public LoggingRequestFilter(String path) {
        this.path = path;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        String requestURI = httpRequest.getRequestURI();
        if (!this.path.equals(requestURI)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        MDC.put((String)"remoteAddress", (String)httpRequest.getRemoteAddr());
        MDC.put((String)"remoteHost", (String)httpRequest.getRemoteHost());
        MDC.put((String)"username", (String)httpRequest.getParameter("username"));
        MDC.put((String)"sessionId", (String)httpRequest.getSession().getId());
        Collections.list(httpRequest.getHeaderNames()).forEach(name -> MDC.put((String)name, (String)httpRequest.getHeader(name)));
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
        MDC.clear();
    }
}

