/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.service.graphrules;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Edge;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Graph;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Node;
import org.odpi.openmetadata.userinterface.uichassis.springboot.service.graphrules.Rule;

public class RemoveNodesRule
implements Rule {
    private String queriedNodeType;
    private List<String> nodeTypesToRemove;

    public String getQueriedNodeType() {
        return this.queriedNodeType;
    }

    public void setQueriedNodeType(String queriedNodeType) {
        this.queriedNodeType = queriedNodeType;
    }

    public List<String> getNodeTypesToRemove() {
        return this.nodeTypesToRemove;
    }

    public void setNodeTypesToRemove(List<String> nodeTypesToRemove) {
        this.nodeTypesToRemove = nodeTypesToRemove;
    }

    public void apply(Graph graph, String queriedNodeGUID) {
        if (this.queriedNodeType == null || this.nodeTypesToRemove == null) {
            return;
        }
        if (this.areSameQueriedNodeTypes(queriedNodeGUID, graph.getNodes())) {
            this.removeNodesFromGraph(graph.getEdges(), graph.getNodes());
        }
    }

    private boolean areSameQueriedNodeTypes(String guid, List<Node> nodes) {
        return nodes.stream().anyMatch(node -> node.getId().equals(guid) && node.getGroup().equals(this.queriedNodeType));
    }

    private void removeNodesFromGraph(List<Edge> edges, List<Node> nodes) {
        ArrayList edgesToRemove = new ArrayList();
        ArrayList<Node> nodesToRemove = new ArrayList<Node>();
        for (Node node : nodes) {
            if (!this.nodeTypesToRemove.contains(node.getGroup())) continue;
            nodesToRemove.add(node);
            String newStartNode = this.findNewStartNode(edges, edgesToRemove, node);
            List newEndNodes = this.findNewEndNodes(edges, edgesToRemove, node.getId());
            this.createNewEdges(edges, newStartNode, newEndNodes);
        }
        nodes.removeAll(nodesToRemove);
        edges.removeAll(edgesToRemove);
    }

    private String findNewStartNode(List<Edge> edges, List<Edge> edgesToRemove, Node node) {
        String newFrom = "";
        for (Edge edge : edges) {
            if (!edge.getTo().equals(node.getId())) continue;
            edgesToRemove.add(edge);
            newFrom = edge.getFrom();
        }
        return newFrom;
    }

    private List<String> findNewEndNodes(List<Edge> edges, List<Edge> edgesToRemove, String nodeId) {
        ArrayList<String> newTo = new ArrayList<String>();
        for (Edge edge : edges) {
            if (!edge.getFrom().equals(nodeId)) continue;
            edgesToRemove.add(edge);
            newTo.add(edge.getTo());
        }
        return newTo;
    }

    private void createNewEdges(List<Edge> edges, String newStartNode, List<String> newEndNodes) {
        for (String newEndNode : newEndNodes) {
            if (newStartNode.equals("")) continue;
            edges.add(new Edge(newStartNode, newEndNode));
        }
    }
}

