/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.service;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Service;

@Service
@ConfigurationProperties(prefix="role")
@EnableConfigurationProperties
public class ComponentService {
    private final Map<String, List<String>> visibleComponents = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    public Map<String, List<String>> getVisibleComponents() {
        return this.visibleComponents;
    }

    public Set<String> getVisibleComponentsForRoles(Collection<String> roles) {
        HashSet<String> components = new HashSet<String>();
        roles.stream().map(this.visibleComponents::get).filter(Objects::nonNull).forEach(components::addAll);
        return components;
    }

    public final Set<String> getAppRoles() {
        return this.visibleComponents.keySet();
    }
}

