/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.service.graphrules;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Edge;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Graph;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Node;
import org.odpi.openmetadata.userinterface.uichassis.springboot.service.graphrules.Rule;

public class PrimaryCategoryRule
implements Rule {
    private static final String TERM_CATEGORIZATION = "TermCategorization";
    private static final String REFERENCING_CATEGORY = "ReferencingCategory";
    private static final String PRIMARY_CATEGORY = "PrimaryCategory";
    private String edgeType;
    private String sourceNodeType;
    private String destinationNodeType;
    private String classificationProperty;

    public String getEdgeType() {
        return this.edgeType;
    }

    public void setEdgeType(String edgeType) {
        this.edgeType = edgeType;
    }

    public String getSourceNodeType() {
        return this.sourceNodeType;
    }

    public void setSourceNodeType(String sourceNodeType) {
        this.sourceNodeType = sourceNodeType;
    }

    public String getDestinationNodeType() {
        return this.destinationNodeType;
    }

    public void setDestinationNodeType(String destinationNodeType) {
        this.destinationNodeType = destinationNodeType;
    }

    public String getClassificationProperty() {
        return this.classificationProperty;
    }

    public void setClassificationProperty(String classificationProperty) {
        this.classificationProperty = classificationProperty;
    }

    public void apply(Graph graph, String queriedNodeGUID) {
        List nodes = graph.getNodes();
        List edges = graph.getEdges();
        ArrayList<Edge> edgesToRemove = new ArrayList<Edge>();
        ArrayList<Node> nodesToDrop = new ArrayList<Node>();
        if (this.classificationProperty == null || this.edgeType == null) {
            return;
        }
        List edgesWithProperLabel = graph.getEdges().stream().filter(e -> e.getLabel().equals(this.edgeType)).collect(Collectors.toList());
        for (Edge edge : edgesWithProperLabel) {
            String primaryCategoryQualifiedName = null;
            String glossaryTermGUID = null;
            for (Node node : nodes) {
                Node classificationNode;
                if (!node.getGroup().equals(this.sourceNodeType) || !node.getId().equals(edge.getFrom()) || !this.hasCorrectClassificationProperty(classificationNode = this.getSecondNode(nodes, edge))) continue;
                primaryCategoryQualifiedName = (String)classificationNode.getProperties().get(this.classificationProperty);
                glossaryTermGUID = node.getId();
                nodesToDrop.add(classificationNode);
            }
            if (primaryCategoryQualifiedName == null) continue;
            String primaryCategoryGUID = this.getPrimaryCategoryGUID(nodes, primaryCategoryQualifiedName);
            this.markRelationships(edges, glossaryTermGUID, primaryCategoryGUID);
            edgesToRemove.add(edge);
        }
        graph.getNodes().removeAll(nodesToDrop);
        graph.getEdges().removeAll(edgesToRemove);
    }

    private Node getSecondNode(List<Node> nodes, Edge edge) {
        for (Node secondNode : nodes) {
            if (!secondNode.getId().equals(edge.getTo()) || !this.destinationNodeType.equals(secondNode.getGroup())) continue;
            return secondNode;
        }
        return null;
    }

    private boolean hasCorrectClassificationProperty(Node node) {
        return node != null && node.getProperties() != null && node.getProperties().containsKey(this.classificationProperty);
    }

    private String getPrimaryCategoryGUID(List<Node> nodes, String primaryCategoryQualifiedName) {
        for (Node node : nodes) {
            if (!primaryCategoryQualifiedName.equals(node.getQualifiedName())) continue;
            return node.getId();
        }
        return null;
    }

    private void markRelationships(List<Edge> edges, String glossaryTermGUID, String primaryCategoryGUID) {
        edges.stream().filter(edge -> this.isTermCategorizationAndCorrectNodes(glossaryTermGUID, edge)).forEach(edge -> this.markRelationship(primaryCategoryGUID, edge));
    }

    private void markRelationship(String primaryCategoryGUID, Edge e) {
        if (e.getTo().equals(primaryCategoryGUID) || e.getFrom().equals(primaryCategoryGUID)) {
            e.setType(PRIMARY_CATEGORY);
        } else {
            e.setType(REFERENCING_CATEGORY);
        }
    }

    private boolean isTermCategorizationAndCorrectNodes(String glossaryTermGUID, Edge e) {
        return e.getLabel().equals(TERM_CATEGORIZATION) && (e.getTo().equals(glossaryTermGUID) || e.getFrom().equals(glossaryTermGUID));
    }

    public String toString() {
        return "PrimaryCategoryRule{edgeType='" + this.edgeType + "', sourceNodeType='" + this.sourceNodeType + "', destinationNodeType='" + this.destinationNodeType + "', classificationProperty='" + this.classificationProperty + "'}";
    }
}

