/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.api.lineage;

import java.beans.PropertyEditor;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.governanceservers.openlineage.converters.ScopeEnumConverter;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVertex;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.governanceservers.openlineage.requests.ElementHierarchyRequest;
import org.odpi.openmetadata.governanceservers.openlineage.requests.LineageSearchRequest;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Graph;
import org.odpi.openmetadata.userinterface.uichassis.springboot.service.OpenLineageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lineage"})
public class OpenLineageController {
    @Autowired
    private OpenLineageService openLineageService;

    @GetMapping(value={"/entities/{guid}/ultimate-source"})
    public Graph ultimateSourceGraph(@PathVariable(value="guid") String guid, @RequestParam boolean includeProcesses) throws InvalidParameterException, PropertyServerException, OpenLineageException {
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        Graph exportedGraph = this.openLineageService.getUltimateSource(userId, guid, includeProcesses);
        return exportedGraph;
    }

    @GetMapping(value={"/entities/{guid}/end2end"})
    @ResponseBody
    public Graph endToEndLineage(@PathVariable(value="guid") String guid, @RequestParam boolean includeProcesses) throws InvalidParameterException, PropertyServerException, OpenLineageException {
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        Graph exportedGraph = this.openLineageService.getEndToEndLineage(userId, guid, includeProcesses);
        return exportedGraph;
    }

    @GetMapping(value={"/entities/{guid}/ultimate-destination"})
    public Graph ultimateDestination(@PathVariable(value="guid") String guid, @RequestParam boolean includeProcesses) throws InvalidParameterException, PropertyServerException, OpenLineageException {
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        Graph exportedGraph = this.openLineageService.getUltimateDestination(userId, guid, includeProcesses);
        return exportedGraph;
    }

    @GetMapping(value={"/entities/{guid}/vertical-lineage"})
    public Graph verticalLineage(@PathVariable(value="guid") String guid, @RequestParam boolean includeProcesses) throws InvalidParameterException, PropertyServerException, OpenLineageException {
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        Graph exportedGraph = this.openLineageService.getVerticalLineage(userId, guid, includeProcesses);
        return exportedGraph;
    }

    @GetMapping(value={"entities/{guid}/details"})
    public LineageVertex getEntityDetails(@PathVariable(value="guid") String guid) throws InvalidParameterException, PropertyServerException, OpenLineageException {
        String user = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.openLineageService.getEntityDetails(user, guid);
    }

    @GetMapping(value={"types"})
    public List<String> getTypes() {
        String user = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.openLineageService.getTypes(user);
    }

    @GetMapping(value={"nodes"})
    public List<String> getNodes(@RequestParam(value="type") String type, @RequestParam(value="name") String searchValue, @RequestParam(value="limit") int limit) {
        String user = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.openLineageService.getNodes(user, type, searchValue, limit);
    }

    @PostMapping(value={"entities/search"})
    public List<LineageVertex> search(@RequestBody LineageSearchRequest searchRequest) throws InvalidParameterException, PropertyServerException, OpenLineageException {
        String user = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.openLineageService.search(user, searchRequest);
    }

    @PostMapping(value={"elements/hierarchy"})
    public Graph elementHierarchy(@RequestBody ElementHierarchyRequest elementHierarchyRequest) {
        String user = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.openLineageService.getElementHierarchy(user, elementHierarchyRequest);
    }

    @InitBinder
    public void initBinder(WebDataBinder webdataBinder) {
        webdataBinder.registerCustomEditor(Scope.class, (PropertyEditor)new ScopeEnumConverter());
    }
}

