/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth;

import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtException;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.AuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class AuthFilter
extends GenericFilterBean {
    private static final Logger LOG = LoggerFactory.getLogger(AuthFilter.class);
    private final AuthService authService;

    public AuthFilter(AuthService authService) {
        this.authService = authService;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            Authentication authentication = this.authService.getAuthentication((HttpServletRequest)request);
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        catch (ExpiredJwtException e) {
            LOG.error("TOKEN EXPIRED {}", (Object)e.getMessage());
            SecurityContextHolder.getContext().setAuthentication(null);
        }
        catch (JwtException e) {
            LOG.debug("Token error {}", (Object)e.getMessage());
            SecurityContextHolder.getContext().setAuthentication(null);
        }
        catch (Exception e) {
            LOG.error("Authentication exception", (Throwable)e);
            SecurityContextHolder.getContext().setAuthentication(null);
        }
        filterChain.doFilter(request, response);
        SecurityContextHolder.getContext().setAuthentication(null);
    }
}

