/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.util.Date;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.RoleService;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.TokenUser;
import org.springframework.beans.factory.annotation.Value;

public class TokenService
extends RoleService {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectReader OBJECT_READER = OBJECT_MAPPER.reader();
    private static final ObjectWriter OBJECT_WRITER = OBJECT_MAPPER.writer();
    @Value(value="${token.secret}")
    protected String tokenSecret;
    @Value(value="${token.timeout:30}")
    protected Long tokenTimeout;

    public long getTokenTimeout() {
        return this.tokenTimeout * 60L * 1000L;
    }

    public String toJSON(Object obj) {
        try {
            return OBJECT_WRITER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public String createTokenForUser(TokenUser user, String secret) {
        return Jwts.builder().setExpiration(new Date(System.currentTimeMillis() + this.getTokenTimeout())).setSubject(this.toJSON((Object)user)).signWith(SignatureAlgorithm.HS512, secret).compact();
    }

    public TokenUser parseUserFromToken(String token, String secret) {
        String userJSON = ((Claims)Jwts.parser().setSigningKey(secret).parseClaimsJws(token).getBody()).getSubject();
        return this.fromJSON(userJSON);
    }

    public TokenUser fromJSON(String userJSON) {
        try {
            return (TokenUser)OBJECT_READER.readValue(userJSON, TokenUser.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

