/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.TokenUser;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.userdetails.InetOrgPerson;

public interface AuthService {
    public static final String AUTH_HEADER_NAME = "x-auth-token";

    public Authentication getAuthentication(HttpServletRequest var1);

    public void addAuthentication(HttpServletRequest var1, HttpServletResponse var2, Authentication var3);

    public Collection<String> extractUserAppRoles(Collection<String> var1);

    default public TokenUser getTokenUser(Authentication authentication) {
        TokenUser tokenUser;
        Object principal = authentication.getPrincipal();
        if (principal instanceof InetOrgPerson) {
            InetOrgPerson person = (InetOrgPerson)principal;
            Collection userRoles = person.getAuthorities().stream().map(a -> a.getAuthority()).collect(Collectors.toSet());
            tokenUser = new TokenUser(person, this.extractUserAppRoles(userRoles));
        } else {
            UserDetails userDetails = (UserDetails)principal;
            tokenUser = new TokenUser(userDetails.getUsername(), (Collection)userDetails.getAuthorities().stream().map(a -> a.getAuthority()).collect(Collectors.toSet()));
        }
        return tokenUser;
    }

    default public TokenUser fromJSON(String userJSON) {
        try {
            return (TokenUser)new ObjectMapper().readValue(userJSON, TokenUser.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    default public String toJSON(TokenUser user) {
        try {
            return new ObjectMapper().writeValueAsString((Object)user);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    default public TokenUser parseUserFromToken(String token, String secret) {
        String userJSON = ((Claims)Jwts.parser().setSigningKey(secret).parseClaimsJws(token).getBody()).getSubject();
        return this.fromJSON(userJSON);
    }

    default public String createTokenForUser(TokenUser user, String secret) {
        return Jwts.builder().setExpiration(new Date(System.currentTimeMillis() + this.getTokenTimeout())).setSubject(this.toJSON(user)).signWith(SignatureAlgorithm.HS512, secret).compact();
    }

    public long getTokenTimeout();
}

