/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth;

import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.AuthFilter;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.AuthService;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.AuthenticationExceptionHandler;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.LoggingRequestFilter;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.LoginFilter;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.TokenClient;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.TokenLogoutSuccessHandler;
import org.odpi.openmetadata.userinterface.uichassis.springboot.service.ComponentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.ldap.userdetails.InetOrgPersonContextMapper;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

public abstract class SecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private AuthService authService;
    @Autowired(required=false)
    TokenClient tokenClient;
    @Autowired
    private ComponentService componentService;
    @Value(value="${cors.allowed-origins}")
    List<String> allowedOrigins;

    public SecurityConfig() {
        super(true);
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.cors().and()).exceptionHandling().and()).anonymous().and()).authorizeRequests().antMatchers(new String[]{"/logout"})).permitAll().antMatchers(new String[]{"/api/public/**"})).permitAll().antMatchers(new String[]{"/api/**"})).authenticated().antMatchers(new String[]{"/**"})).permitAll().anyRequest()).authenticated().and()).logout().logoutRequestMatcher((RequestMatcher)new AntPathRequestMatcher("/logout")).logoutSuccessHandler(this.logoutSuccessHandler()).and()).addFilterBefore((Filter)new AuthFilter(this.authService), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)new LoggingRequestFilter("/api/auth/login"), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)new LoginFilter.LoginFilterBuilder().url("/api/auth/login").authManager(this.authenticationManager()).exceptionHandler(this.getAuthenticationExceptionHandler()).authService(this.authService).appRoles(this.componentService.getAppRoles()).build(), UsernamePasswordAuthenticationFilter.class);
    }

    @Bean
    @ConditionalOnProperty(value={"cors.allowed-origins"})
    CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        if (this.allowedOrigins != null && this.allowedOrigins.size() > 0) {
            configuration.setAllowedOrigins(this.allowedOrigins);
            configuration.setAllowedMethods(Arrays.asList("GET", "POST"));
            configuration.addExposedHeader("x-auth-token");
            configuration.setAllowedHeaders(Arrays.asList("content-type", "x-auth-token"));
            source.registerCorsConfiguration("/**", configuration);
        }
        return source;
    }

    public LogoutSuccessHandler logoutSuccessHandler() {
        return new TokenLogoutSuccessHandler(this.tokenClient);
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    @Bean
    public InetOrgPersonContextMapper userContextMapper() {
        return new InetOrgPersonContextMapper();
    }

    protected abstract AuthenticationExceptionHandler getAuthenticationExceptionHandler();
}

