/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth.db;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.db.UserRepository;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.db.domain.Role;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.db.domain.User;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"authentication.source"}, havingValue="db")
public class DemoInMemoryInitializingBean
implements InitializingBean {
    private static final String PASSWORD = "secret";
    @Autowired
    private UserRepository userRepository;

    public void afterPropertiesSet() {
        this.addUser("user", "John", "user", "/resources/img/user.png");
        this.addUser("admin", "Administrator", "admin", "/resources/img/admin.png", new Role[]{Role.COCO_PHARMA_ADMIN});
        this.addUser("garygeeke", "Gary Geeke", PASSWORD, "/resources/img/user.png", new Role[]{Role.COCO_PHARMA_ADMIN});
        this.addUser("faith", "Faith Broker ", PASSWORD, "/resources/img/faith.png");
        this.addUser("callie", "Callie Quartile ", PASSWORD, "/resources/img/callie.png");
        this.addUser("zach", "Zach Now", PASSWORD, "/resources/img/user.png");
        this.addUser("steves", "Steve Starter", PASSWORD, "/resources/img/user.png");
        this.addUser("terri", "Terri Daring", PASSWORD, "/resources/img/user.png");
        this.addUser("tanyatidie", "Tanya Tide", PASSWORD, "/resources/img/user.png");
        this.addUser("pollytasker", "Polly Tasker", PASSWORD, "/resources/img/user.png");
        this.addUser("tessatube", "Tessa Tube", PASSWORD, "/resources/img/user.png");
        this.addUser("calliequartile", "Callie quartile", PASSWORD, "/resources/img/user.png");
        this.addUser("ivorpadlock", "Ivor Padlock", PASSWORD, "/resources/img/user.png");
        this.addUser("bobnitter", "Bob Nitter", PASSWORD, "/resources/img/user.png");
        this.addUser("faithbroker", "Faith Broker", PASSWORD, "/resources/img/user.png");
        this.addUser("sallycounter", "Sally Counter", PASSWORD, "/resources/img/user.png");
        this.addUser("lemmiestage", "Lemmie Stage", PASSWORD, "/resources/img/user.png");
        this.addUser("erinoverview", "Erin Overview", PASSWORD, "/resources/img/user.png");
        this.addUser("harryhopeful", "Harry Hopeful", PASSWORD, "/resources/img/user.png");
        this.addUser("grantable", "Grant Able", PASSWORD, "/resources/img/user.png");
        this.addUser("robbierecords", "Robbie Records", PASSWORD, "/resources/img/user.png");
        this.addUser("reggiemint", "Reggie Mint", PASSWORD, "/resources/img/user.png");
        this.addUser("peterprofile", "Peter Profile", PASSWORD, "/resources/img/user.png");
        this.addUser("nancynoah", "Nancy Noah", PASSWORD, "/resources/img/user.png");
        this.addUser("sidneyseeker", "Sidney Seeker", PASSWORD, "/resources/img/user.png");
        this.addUser("tomtally", "tomtally", PASSWORD, "/resources/img/user.png");
        this.addUser("juliestitched", "juliestitched", PASSWORD, "/resources/img/user.png");
        this.addUser("designa", "designa", PASSWORD, "/resources/img/user.png");
        this.addUser("angelacummings", "angelacummings", PASSWORD, "/resources/img/user.png");
        this.addUser("jukeskeeper", "jukeskeeper", PASSWORD, "/resources/img/user.png");
        this.addUser("stewFaster", "stewFaster", PASSWORD, "/resources/img/user.png");
    }

    private void addUser(String username, String name, String password, String avatarUrl, Role ... roles) {
        List rolesList = Stream.of(roles).map(Enum::name).collect(Collectors.toList());
        User user = new User();
        user.setUsername(username);
        user.setPassword(new BCryptPasswordEncoder().encode((CharSequence)password));
        user.setRoles(rolesList);
        user.setName(name);
        user.setAvatarUrl(avatarUrl);
        this.userRepository.save((Object)user);
    }

    private void addUser(String username, String name, String password, String avatarUrl) {
        this.addUser(username, name, password, avatarUrl, new Role[]{Role.COCO_PHARMA_USER});
    }
}

