/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.set.UnmodifiableSet;
import org.springframework.security.ldap.userdetails.InetOrgPerson;

public class TokenUser
implements Serializable {
    private String username;
    private String displayName;
    private String firstName;
    private String lastName;
    private String email;
    private String avatarUrl;
    private Set<String> roles;

    public TokenUser() {
    }

    public TokenUser(String username, Collection<String> roles) {
        this.username = username;
        this.setRoles(roles.stream().collect(Collectors.toSet()));
    }

    public TokenUser(InetOrgPerson inetOrgPerson, Collection<String> roles) {
        this.username = inetOrgPerson.getUsername();
        this.setDisplayName(inetOrgPerson.getDisplayName());
        this.setFirstName(inetOrgPerson.getGivenName());
        this.setLastName(inetOrgPerson.getSn());
        this.setEmail(inetOrgPerson.getMail());
        this.setRoles(roles.stream().collect(Collectors.toSet()));
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = UnmodifiableSet.unmodifiableSet(roles);
    }
}

