/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.service;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Edge;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Graph;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Node;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Rules;
import org.odpi.openmetadata.userinterface.uichassis.springboot.service.graphrules.Rule;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Service;

@Service
@ConfigurationProperties(prefix="lineage-display-config")
public class LineageGraphDisplayService {
    private Rules rules;

    public Rules getRules() {
        return this.rules;
    }

    public void setRules(Rules rules) {
        this.rules = rules;
    }

    public void applyRules(Graph graph, String queriedNodeGUID) {
        if (this.rules == null) {
            return;
        }
        for (Rule rule : this.rules.getAllRules()) {
            rule.apply(graph, queriedNodeGUID);
        }
    }

    public void setNodesLevel(List<Node> startNodes, List<Node> listNodes, List<Edge> listEdges) {
        ArrayList newStartNodes = new ArrayList();
        ListIterator<Edge> edgeListIterator = listEdges.listIterator();
        while (edgeListIterator.hasNext()) {
            Edge e = edgeListIterator.next();
            for (Node node : startNodes) {
                if (node.getId().equals(e.getFrom())) {
                    listNodes.stream().filter(n -> n.getLevel() == 0 && n.getId().equals(e.getTo())).forEach(item -> {
                        item.setLevel(Integer.valueOf(node.getLevel() + 1));
                        newStartNodes.add(item);
                        edgeListIterator.remove();
                    });
                } else if (node.getId().equals(e.getTo())) {
                    listNodes.stream().filter(n -> n.getLevel() == 0 && n.getId().equals(e.getFrom())).forEach(item -> {
                        item.setLevel(Integer.valueOf(node.getLevel() - 1));
                        newStartNodes.add(item);
                        edgeListIterator.remove();
                    });
                }
                listNodes.removeAll(newStartNodes);
            }
        }
        if (newStartNodes.size() > 0 && listEdges.size() > 0) {
            this.setNodesLevel(newStartNodes, listNodes, listEdges);
        }
    }

    public String toString() {
        return "LineageGraphDisplayRulesService{rules=" + this.rules + "}";
    }
}

