/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.api.lineage;

import java.beans.PropertyEditor;
import org.odpi.openmetadata.governanceservers.openlineage.converters.ScopeEnumConverter;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVertex;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Graph;
import org.odpi.openmetadata.userinterface.uichassis.springboot.service.OpenLineageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lineage"})
public class OpenLineageController {
    @Autowired
    private OpenLineageService openLineageService;

    @GetMapping(value={"/entities/{guid}/ultimate-source"})
    public Graph ultimateSourceGraph(@PathVariable(value="guid") String guid, @RequestParam boolean includeProcesses) {
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        Graph exportedGraph = this.openLineageService.getUltimateSource(userId, guid, includeProcesses);
        return exportedGraph;
    }

    @GetMapping(value={"/entities/{guid}/end2end"})
    @ResponseBody
    public Graph endToEndLineage(@PathVariable(value="guid") String guid, @RequestParam boolean includeProcesses) {
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        Graph exportedGraph = this.openLineageService.getEndToEndLineage(userId, guid, includeProcesses);
        return exportedGraph;
    }

    @GetMapping(value={"/entities/{guid}/ultimate-destination"})
    public Graph ultimateDestination(@PathVariable(value="guid") String guid, @RequestParam boolean includeProcesses) {
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        Graph exportedGraph = this.openLineageService.getUltimateDestination(userId, guid, includeProcesses);
        return exportedGraph;
    }

    @GetMapping(value={"/entities/{guid}/vertical-lineage"})
    public Graph verticalLineage(@PathVariable(value="guid") String guid, @RequestParam boolean includeProcesses) {
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        Graph exportedGraph = this.openLineageService.getVerticalLineage(userId, guid, includeProcesses);
        return exportedGraph;
    }

    @GetMapping(value={"entities/{guid}/details"})
    public LineageVertex getEntityDetails(@PathVariable(value="guid") String guid) {
        String user = SecurityContextHolder.getContext().getAuthentication().getName();
        return this.openLineageService.getEntityDetails(user, guid);
    }

    @InitBinder
    public void initBinder(WebDataBinder webdataBinder) {
        webdataBinder.registerCustomEditor(Scope.class, (PropertyEditor)new ScopeEnumConverter());
    }
}

