/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auditlog;

import java.text.MessageFormat;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum ViewServiceAuditCode {
    SERVICE_INITIALIZING("OMVS-VIEW-0001", OMRSAuditLogRecordSeverity.INFO, "The {1} Open Metadata View Service (OMVS) is initializing for server {0}", "The {1} OMVS has started initialization.", "No action is required. This is part of the normal operation of the service."),
    SERVICE_INITIALIZED("OMVS-VIEW-0003", OMRSAuditLogRecordSeverity.INFO, "The {1} Open Metadata View Service (OMVS) has initialized for server {0}", "The {1} OMVS has completed initialization.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_SHUTDOWN("OMVS-VIEW-0004", OMRSAuditLogRecordSeverity.INFO, "Open Metadata View Service (OMVS) is shutting down for server {0}", "The local server has requested shut down of a OMVS instance.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INSTANCE_FAILURE("OMAS-VIEW-0005", OMRSAuditLogRecordSeverity.ERROR, "The {0} Open Metadata View Service (OMVS) is unable to initialize a new instance; error message is {1}", "The view service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    UNKNOWN_SERVICE_INITIALIZING("OMVS-VIEW-0001", OMRSAuditLogRecordSeverity.INFO, "A Open Metadata View Service (OMVS) is initializing for server {0}", "The local server is initializing a new instance a OMVS.", "No action is required.  This is part of the normal operation of the service.");

    private String logMessageId;
    private OMRSAuditLogRecordSeverity severity;
    private String logMessage;
    private String systemAction;
    private String userAction;

    private ViewServiceAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public String getLogMessageId() {
        return this.logMessageId;
    }

    public OMRSAuditLogRecordSeverity getSeverity() {
        return this.severity;
    }

    public String getFormattedLogMessage(String ... params) {
        MessageFormat mf = new MessageFormat(this.logMessage);
        return mf.format(params);
    }

    public String getSystemAction() {
        return this.systemAction;
    }

    public String getUserAction() {
        return this.userAction;
    }
}

