/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.api;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.AuthService;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.TokenUser;
import org.odpi.openmetadata.userinterface.uichassis.springboot.service.ComponentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;

@RestController
@RequestMapping(value={"/api/users"})
public class UserInfoController {
    @Autowired
    private AuthService authService;
    @Autowired
    private ComponentService componentService;

    @GetMapping(value={"/current"})
    public TokenUser getUser(HttpServletRequest request) throws HttpClientErrorException {
        return this.getTokenUser(request);
    }

    @GetMapping(value={"/components"})
    public Collection<String> getVisibleComponents(HttpServletRequest request) throws HttpClientErrorException {
        return this.componentService.getVisibleComponentsForRoles((Collection)this.getTokenUser(request).getRoles());
    }

    private TokenUser getTokenUser(HttpServletRequest request) {
        Authentication auth = this.authService.getAuthentication(request);
        if (auth == null || auth.getDetails() == null || !(auth.getDetails() instanceof TokenUser)) {
            throw new UserNotAuthorizedException("User is not authorized");
        }
        return (TokenUser)auth.getDetails();
    }

    @GetMapping(value={"/roles"})
    public Collection<String> getRoles(HttpServletRequest request) throws HttpClientErrorException {
        TokenUser tokenUser = this.getTokenUser(request);
        Set appRoles = this.componentService.getAppRoles();
        return tokenUser.getRoles().stream().filter(appRoles::contains).collect(Collectors.toSet());
    }
}

