/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.TokenClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;

public class TokenLogoutSuccessHandler
extends SimpleUrlLogoutSuccessHandler
implements LogoutSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(TokenLogoutSuccessHandler.class);
    private TokenClient tokenClient;

    TokenLogoutSuccessHandler(TokenClient tokenClient) {
        this.tokenClient = tokenClient;
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String refererUrl = request.getHeader("Referer");
        log.debug("Logout from: {}", (Object)refererUrl);
        String token = request.getHeader("x-auth-token");
        if (this.tokenClient != null && token != null) {
            this.tokenClient.del(new String[]{token});
        }
        response.addHeader("x-auth-token", "");
        response.sendRedirect("login?logoutSuccessful");
        super.onLogoutSuccess(request, response, authentication);
    }
}

