/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.governanceservers.openlineage.client.OpenLineageClient;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageEdge;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVertex;
import org.odpi.openmetadata.governanceservers.openlineage.model.LineageVerticesAndEdges;
import org.odpi.openmetadata.governanceservers.openlineage.model.Scope;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.exceptions.LineageNotFoundException;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.exceptions.OpenLineageServiceException;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Edge;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Graph;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Node;
import org.odpi.openmetadata.userinterface.uichassis.springboot.service.LineageGraphDisplayService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OpenLineageService {
    private final OpenLineageClient openLineageClient;
    private final LineageGraphDisplayService lineageGraphDisplayService;
    private static final Logger LOG = LoggerFactory.getLogger(OpenLineageService.class);

    @Autowired
    public OpenLineageService(OpenLineageClient openLineageClient, LineageGraphDisplayService lineageGraphDisplayService) {
        this.openLineageClient = openLineageClient;
        this.lineageGraphDisplayService = lineageGraphDisplayService;
    }

    public Graph getUltimateSource(String userId, String guid, boolean includeProcesses) throws InvalidParameterException, PropertyServerException, OpenLineageException {
        try {
            LineageVerticesAndEdges response = this.openLineageClient.lineage(userId, Scope.ULTIMATE_SOURCE, guid, "", includeProcesses);
            return this.processResponse(response, guid);
        }
        catch (PropertyServerException e) {
            LOG.error("Cannot get ultimate source lineage for guid {}", (Object)guid);
            throw e;
        }
        catch (InvalidParameterException e) {
            LOG.error("Cannot get ultimate source for guid {}", (Object)guid);
            throw new LineageNotFoundException("ultimate source lineage error", (Throwable)e);
        }
        catch (OpenLineageException e) {
            LOG.error("Error while calling open lineage services {}", (Object)guid);
            throw new OpenLineageServiceException("entity details error", (Throwable)e);
        }
    }

    public Graph getEndToEndLineage(String userId, String guid, boolean includeProcesses) throws InvalidParameterException, PropertyServerException, OpenLineageException {
        try {
            LineageVerticesAndEdges response = this.openLineageClient.lineage(userId, Scope.END_TO_END, guid, "", includeProcesses);
            return this.processResponse(response, guid);
        }
        catch (PropertyServerException e) {
            LOG.error("Cannot get end2end lineage for guid {}", (Object)guid);
            throw e;
        }
        catch (InvalidParameterException e) {
            LOG.error("Cannot get end2end lineage for guid {}", (Object)guid);
            throw new LineageNotFoundException("end2end lineage error", (Throwable)e);
        }
        catch (OpenLineageException e) {
            LOG.error("Error while calling open lineage services {}", (Object)guid);
            throw new OpenLineageServiceException("entity details error", (Throwable)e);
        }
    }

    public Graph getUltimateDestination(String userId, String guid, boolean includeProcesses) throws InvalidParameterException, PropertyServerException, OpenLineageException {
        try {
            LineageVerticesAndEdges response = this.openLineageClient.lineage(userId, Scope.ULTIMATE_DESTINATION, guid, "", includeProcesses);
            return this.processResponse(response, guid);
        }
        catch (PropertyServerException e) {
            LOG.error("Cannot get ultimate destination lineage for guid {}", (Object)guid);
            throw e;
        }
        catch (InvalidParameterException e) {
            LOG.error("Cannot get ultimate destination for guid {}", (Object)guid);
            throw new LineageNotFoundException("ultimate destination lineage error", (Throwable)e);
        }
        catch (OpenLineageException e) {
            LOG.error("Error while calling open lineage services {}", (Object)guid);
            throw new OpenLineageServiceException("entity details error", (Throwable)e);
        }
    }

    public Graph getVerticalLineage(String userId, String guid, boolean includeProcesses) throws InvalidParameterException, PropertyServerException, OpenLineageException {
        try {
            LineageVerticesAndEdges response = this.openLineageClient.lineage(userId, Scope.VERTICAL, guid, "", includeProcesses);
            return this.processResponse(response, guid);
        }
        catch (PropertyServerException e) {
            LOG.error("Error while trying to retrieve verical lineage {}", (Object)e.getMessage());
            throw e;
        }
        catch (InvalidParameterException e) {
            LOG.error("Cannot get vertical lineage for guid {}", (Object)guid);
            throw new LineageNotFoundException("vertical lineage error", (Throwable)e);
        }
        catch (OpenLineageException e) {
            LOG.error("Error while calling open lineage services {}", (Object)guid);
            throw new OpenLineageServiceException("entity details error", (Throwable)e);
        }
    }

    public LineageVertex getEntityDetails(String userId, String guid) throws InvalidParameterException, PropertyServerException, OpenLineageException {
        try {
            return this.openLineageClient.getEntityDetails(userId, guid);
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error("Cannot get node details for guid {}", (Object)guid);
            throw e;
        }
        catch (OpenLineageException e) {
            LOG.error("Error while calling open lineage services {}", (Object)guid);
            throw new OpenLineageServiceException("entity details error", (Throwable)e);
        }
    }

    private Graph processResponse(LineageVerticesAndEdges response, String guid) {
        List<Object> edges = new ArrayList();
        List<Object> nodes = new ArrayList();
        LOG.debug("Received response from open lineage service: {}", (Object)response);
        if (response == null || CollectionUtils.isEmpty((Collection)response.getLineageVertices())) {
            return new Graph(nodes, edges);
        }
        edges = Optional.ofNullable(response).map(LineageVerticesAndEdges::getLineageEdges).map(Collection::stream).orElseGet(Stream::empty).map(arg_0 -> this.createEdge(arg_0)).collect(Collectors.toList());
        nodes = Optional.ofNullable(response).map(LineageVerticesAndEdges::getLineageVertices).map(Collection::stream).orElseGet(Stream::empty).map(arg_0 -> this.createNode(arg_0)).collect(Collectors.toList());
        List startList = nodes.stream().filter(n -> n.getId().equals(guid)).collect(Collectors.toList());
        if (!startList.isEmpty()) {
            this.lineageGraphDisplayService.setNodesLevel(startList, new ArrayList<Object>(nodes), new ArrayList(edges));
        }
        Graph graph = new Graph(nodes, edges);
        this.lineageGraphDisplayService.applyRules(graph, guid);
        return graph;
    }

    private Edge createEdge(LineageEdge currentEdge) {
        return new Edge(currentEdge.getSourceNodeID(), currentEdge.getDestinationNodeID(), currentEdge.getEdgeType());
    }

    private Node createNode(LineageVertex currentNode) {
        String displayName = currentNode.getDisplayName();
        Node node = new Node(currentNode.getNodeID(), displayName);
        node.setGroup(currentNode.getNodeType());
        node.setQualifiedName(currentNode.getQualifiedName());
        node.setProperties(currentNode.getProperties());
        return node;
    }
}

