/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.service;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetcatalog.AssetCatalog;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetCatalogBean;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Classification;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Elements;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Relationship;
import org.odpi.openmetadata.accessservices.assetcatalog.model.Type;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.body.SearchParameters;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.UserInterfaceErrorCodes;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.exceptions.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssetCatalogOMASService {
    private final AssetCatalog assetCatalog;
    private static final Logger LOG = LoggerFactory.getLogger(AssetCatalogOMASService.class);

    @Autowired
    public AssetCatalogOMASService(AssetCatalog assetCatalog) {
        this.assetCatalog = assetCatalog;
    }

    public AssetCatalogBean getAssetDetails(String user, String assetId, String assetType) throws PropertyServerException, InvalidParameterException {
        try {
            return this.assetCatalog.getAssetDetails(user, assetId, assetType).getAssetCatalogBean();
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error(String.format("Error retrieving asset details for %s", assetId));
            throw e;
        }
    }

    public AssetCatalogBean getAssetUniverse(String user, String assetId, String assetType) throws PropertyServerException, InvalidParameterException {
        try {
            return this.assetCatalog.getAssetUniverse(user, assetId, assetType).getAssetCatalogBean();
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error(String.format("Error retrieving asset universe for %s", assetId));
            throw e;
        }
    }

    public List<Relationship> getAssetRelationships(String user, String assetId, String assetType, String relationshipTypeGUID, Integer from, Integer pageSize) throws PropertyServerException, InvalidParameterException {
        try {
            return this.assetCatalog.getAssetRelationships(user, assetId, assetType, relationshipTypeGUID, from, pageSize).getRelationships();
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error(String.format("Error retrieving asset relationships for %s", assetId));
            throw e;
        }
    }

    public List<Classification> getClassificationsForAsset(String user, String assetId, String assetType, String classificationName) throws PropertyServerException, InvalidParameterException {
        try {
            return this.assetCatalog.getClassificationsForAsset(user, assetId, assetType, classificationName).getClassifications();
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error(String.format("Error retrieving asset classifications for %s", assetId));
            throw e;
        }
    }

    public List<Elements> searchAssets(String user, String searchCriteria, SearchParameters searchParameters) throws InvalidParameterException, PropertyServerException {
        try {
            return this.assetCatalog.searchByType(user, searchCriteria, searchParameters).getElementsList();
        }
        catch (PropertyServerException e) {
            LOG.error(String.format("Error searching the assets by criteria %s", searchCriteria));
            throw e;
        }
        catch (InvalidParameterException e) {
            throw new BadRequestException(UserInterfaceErrorCodes.INVALID_SEARCH_REQUEST, e.getMessage());
        }
    }

    public Elements getAssetContext(String userId, String assetId, String assetType) throws PropertyServerException, InvalidParameterException {
        try {
            return this.assetCatalog.getAssetContext(userId, assetId, assetType).getAsset();
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error(String.format("Error retrieving asset context for '%s'", assetId));
            throw e;
        }
    }

    public List<Type> getSupportedTypes(String userId) throws PropertyServerException, InvalidParameterException {
        try {
            return this.assetCatalog.getSupportedTypes(userId, null).getTypes();
        }
        catch (InvalidParameterException | PropertyServerException e) {
            LOG.error("Error retrieving supported types");
            throw e;
        }
    }
}

