/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.service.graphrules;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Edge;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Graph;
import org.odpi.openmetadata.userinterface.uichassis.springboot.beans.Node;
import org.odpi.openmetadata.userinterface.uichassis.springboot.service.graphrules.Rule;

public class IncompleteRule
implements Rule {
    private static final String INCOMPLETE = "Incomplete";
    public static final String TYPE = "type";
    private String edgeType;
    private String destinationNodeType;

    public String getEdgeType() {
        return this.edgeType;
    }

    public void setEdgeType(String edgeType) {
        this.edgeType = edgeType;
    }

    public String getDestinationNodeType() {
        return this.destinationNodeType;
    }

    public void setDestinationNodeType(String destinationNodeType) {
        this.destinationNodeType = destinationNodeType;
    }

    public void apply(Graph graph, String queriedNodeGUID) {
        if (this.edgeType == null) {
            return;
        }
        ArrayList<Edge> edgesToRemove = new ArrayList<Edge>();
        ArrayList<Node> nodesToRemove = new ArrayList<Node>();
        List graphNodes = graph.getNodes();
        List edgesWithProperLabel = this.getEdgesWithProperLabel(graph);
        for (Edge edge : edgesWithProperLabel) {
            for (Node node : graphNodes) {
                Optional classificationNode;
                if (!node.getId().equals(edge.getFrom()) || !(classificationNode = this.getSecondNode(graphNodes, edge)).isPresent()) continue;
                nodesToRemove.add((Node)classificationNode.get());
                node.getProperties().put(TYPE, INCOMPLETE);
                edgesToRemove.add(edge);
            }
        }
        graph.getNodes().removeAll(nodesToRemove);
        graph.getEdges().removeAll(edgesToRemove);
    }

    private List<Edge> getEdgesWithProperLabel(Graph graph) {
        return graph.getEdges().stream().filter(e -> e.getLabel().equals(this.edgeType)).collect(Collectors.toList());
    }

    private Optional<Node> getSecondNode(List<Node> nodes, Edge edge) {
        return nodes.stream().filter(node -> node.getId().equals(edge.getTo()) && this.destinationNodeType.equals(node.getGroup())).findAny();
    }

    public String toString() {
        return "IncompleteRule(edgeType=" + this.getEdgeType() + ", destinationNodeType=" + this.getDestinationNodeType() + ")";
    }
}

