/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.api;

import java.util.Map;
import org.odpi.openmetadata.accessservices.glossaryview.exception.GlossaryViewOmasException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.CustomErrorAttributes;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.MalformedInputException;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.UserInterfaceErrorCodes;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.exceptions.BadRequestException;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.exceptions.CategoryNotFoundException;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.exceptions.GlossaryNotFoundException;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.exceptions.LineageNotFoundException;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.exceptions.OpenLineageServiceException;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.exceptions.TermNotFoundException;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.exceptions.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.client.RestClientException;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class ExceptionHandlerController
extends ResponseEntityExceptionHandler {
    @Autowired
    private CustomErrorAttributes errorAttributes;
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionHandlerController.class);

    @ExceptionHandler(value={MalformedInputException.class})
    protected ResponseEntity<Object> handleMalformedInput(MalformedInputException ex, WebRequest request) {
        LOG.error(ex.getMessage(), (Throwable)ex);
        Map errorAttributes = this.errorAttributes.getErrorAttributes(request, UserInterfaceErrorCodes.MALFORMED_INPUT_EXCEPTION);
        return this.handleExceptionInternal((Exception)ex, (Object)errorAttributes, new HttpHeaders(), UserInterfaceErrorCodes.MALFORMED_INPUT_EXCEPTION.getHttpErrorCode(), request);
    }

    @ExceptionHandler(value={InvalidParameterException.class, PropertyServerException.class})
    protected ResponseEntity<Object> handleAssetCatalogException(OCFCheckedExceptionBase ex, WebRequest request) {
        LOG.error(ex.getMessage(), (Throwable)ex);
        UserInterfaceErrorCodes errorCode = UserInterfaceErrorCodes.INVALID_REQUEST_FOR_ASSET_CATALOG;
        if (ex.getReportedHTTPCode() == HttpStatus.NOT_FOUND.value()) {
            errorCode = UserInterfaceErrorCodes.ENTITY_NOT_FOUND;
        }
        Map errorAttributes = this.errorAttributes.getErrorAttributes(request, errorCode);
        return this.handleExceptionInternal((Exception)ex, (Object)errorAttributes, new HttpHeaders(), errorCode.getHttpErrorCode(), request);
    }

    @ExceptionHandler(value={OpenLineageServiceException.class})
    protected ResponseEntity<Object> handleOpenLineageClientException(OpenLineageServiceException ex, WebRequest request) {
        LOG.error(ex.getMessage(), (Throwable)ex);
        Map errorAttributes = this.errorAttributes.getErrorAttributes(request, UserInterfaceErrorCodes.INVALID_REQUEST_FOR_OPEN_LINEAGE);
        return this.handleExceptionInternal((Exception)ex, (Object)errorAttributes, new HttpHeaders(), UserInterfaceErrorCodes.INVALID_REQUEST_FOR_OPEN_LINEAGE.getHttpErrorCode(), request);
    }

    @ExceptionHandler(value={LineageNotFoundException.class})
    protected ResponseEntity<Object> handleLineageNotFoundException(LineageNotFoundException ex, WebRequest request) {
        LOG.error(ex.getMessage(), (Throwable)ex);
        Map errorAttributes = this.errorAttributes.getErrorAttributes(request, UserInterfaceErrorCodes.LINEAGE_NOT_FOUND);
        return this.handleExceptionInternal((Exception)ex, (Object)errorAttributes, new HttpHeaders(), UserInterfaceErrorCodes.LINEAGE_NOT_FOUND.getHttpErrorCode(), request);
    }

    @ExceptionHandler(value={BadRequestException.class})
    protected ResponseEntity<Object> handleBadRequestException(BadRequestException ex, WebRequest request) {
        LOG.error(ex.getMessage(), (Throwable)ex);
        Map errorAttributes = this.errorAttributes.getErrorAttributes(request, ex.getErrorCode());
        return this.handleExceptionInternal((Exception)ex, (Object)errorAttributes, new HttpHeaders(), ex.getErrorCode().getHttpErrorCode(), request);
    }

    @ExceptionHandler(value={RestClientException.class})
    protected ResponseEntity<Object> handleResourceException(RestClientException ex, WebRequest request) {
        LOG.error(ex.getMessage(), (Throwable)ex);
        Map errorAttributes = this.errorAttributes.getErrorAttributes(request, UserInterfaceErrorCodes.RESOURCE_NOT_FOUND);
        return this.handleExceptionInternal((Exception)ex, (Object)errorAttributes, new HttpHeaders(), UserInterfaceErrorCodes.RESOURCE_NOT_FOUND.getHttpErrorCode(), request);
    }

    @ExceptionHandler(value={UserNotAuthorizedException.class})
    protected ResponseEntity<Object> handleUnauthorizedException(UserNotAuthorizedException ex, WebRequest request) {
        LOG.error(ex.getMessage(), (Throwable)ex);
        Map errorAttributes = this.errorAttributes.getErrorAttributes(request, UserInterfaceErrorCodes.USER_NOT_AUTHORIZED);
        return this.handleExceptionInternal((Exception)ex, (Object)errorAttributes, new HttpHeaders(), UserInterfaceErrorCodes.USER_NOT_AUTHORIZED.getHttpErrorCode(), request);
    }

    @ExceptionHandler(value={GlossaryViewOmasException.class})
    protected ResponseEntity<Object> handleGlossaryViewOmasException(GlossaryViewOmasException ex, WebRequest request) {
        LOG.error(ex.getMessage(), (Throwable)ex);
        Map errorAttributes = this.errorAttributes.getErrorAttributes(request, UserInterfaceErrorCodes.INVALID_REQUEST_FOR_GLOSSARY_VIEW);
        return this.handleExceptionInternal((Exception)ex, (Object)errorAttributes, new HttpHeaders(), UserInterfaceErrorCodes.INVALID_REQUEST_FOR_GLOSSARY_VIEW.getHttpErrorCode(), request);
    }

    @ExceptionHandler(value={GlossaryNotFoundException.class})
    protected ResponseEntity<Object> handleGlossaryViewNotFoundRequestException(GlossaryNotFoundException ex, WebRequest request) {
        LOG.error(ex.getMessage(), (Throwable)ex);
        Map errorAttributes = this.errorAttributes.getErrorAttributes(request, UserInterfaceErrorCodes.GLOSSARY_NOT_FOUND);
        return this.handleExceptionInternal((Exception)ex, (Object)errorAttributes, new HttpHeaders(), UserInterfaceErrorCodes.GLOSSARY_NOT_FOUND.getHttpErrorCode(), request);
    }

    @ExceptionHandler(value={TermNotFoundException.class})
    protected ResponseEntity<Object> handleGlossaryViewNotFoundRequestException(TermNotFoundException ex, WebRequest request) {
        LOG.error(ex.getMessage(), (Throwable)ex);
        Map errorAttributes = this.errorAttributes.getErrorAttributes(request, UserInterfaceErrorCodes.TERM_NOT_FOUND);
        return this.handleExceptionInternal((Exception)ex, (Object)errorAttributes, new HttpHeaders(), UserInterfaceErrorCodes.TERM_NOT_FOUND.getHttpErrorCode(), request);
    }

    @ExceptionHandler(value={CategoryNotFoundException.class})
    protected ResponseEntity<Object> handleGlossaryViewNotFoundRequestException(CategoryNotFoundException ex, WebRequest request) {
        LOG.error(ex.getMessage(), (Throwable)ex);
        Map errorAttributes = this.errorAttributes.getErrorAttributes(request, UserInterfaceErrorCodes.CATEGORY_NOT_FOUND);
        return this.handleExceptionInternal((Exception)ex, (Object)errorAttributes, new HttpHeaders(), UserInterfaceErrorCodes.CATEGORY_NOT_FOUND.getHttpErrorCode(), request);
    }
}

