/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.TokenUser;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.userdetails.InetOrgPerson;

public interface AuthService {
    public static final String AUTH_HEADER_NAME = "x-auth-token";

    public Authentication getAuthentication(HttpServletRequest var1);

    public void addAuthentication(HttpServletRequest var1, HttpServletResponse var2, Authentication var3);

    public Collection<String> extractUserAppRoles(Collection<String> var1);

    default public TokenUser getTokenUser(Authentication authentication) {
        TokenUser tokenUser;
        Object principal = authentication.getPrincipal();
        if (principal instanceof InetOrgPerson) {
            InetOrgPerson person = (InetOrgPerson)principal;
            Collection userRoles = person.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
            tokenUser = new TokenUser(person, this.extractUserAppRoles(userRoles));
        } else {
            UserDetails userDetails = (UserDetails)principal;
            tokenUser = new TokenUser(userDetails.getUsername(), (Collection)userDetails.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet()));
        }
        tokenUser.setVisibleComponents(this.getVisibleComponents((Collection)tokenUser.getRoles()));
        return tokenUser;
    }

    public long getTokenTimeout();

    public Set<String> getVisibleComponents(Collection<String> var1);
}

