/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth.ldap;

import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.ldap.LdapSecurityConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.ldap.authentication.ad.ActiveDirectoryLdapAuthenticationProvider;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;

@EnableWebSecurity
@Configuration(value="securityConfig")
@Order(value=-2147483648)
@ConditionalOnProperty(value={"authentication.source"}, havingValue="ad")
public class ActiveDirectoryLdapSecurityConfig
extends LdapSecurityConfig {
    @Value(value="${ldap.domain}")
    private String ldapDomain;

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        ActiveDirectoryLdapAuthenticationProvider adProvider = new ActiveDirectoryLdapAuthenticationProvider(this.ldapDomain, this.ldapURL, this.userSearchBase);
        adProvider.setSearchFilter(this.userSearchFilter);
        adProvider.setUserDetailsContextMapper((UserDetailsContextMapper)this.userContextMapper());
        adProvider.setConvertSubErrorCodesToExceptions(true);
        adProvider.setUseAuthenticationRequestCredentials(true);
        auth.authenticationProvider((AuthenticationProvider)adProvider);
    }
}

