/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.api.glossary;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.odpi.openmetadata.accessservices.glossaryview.client.GlossaryViewClient;
import org.odpi.openmetadata.accessservices.glossaryview.exception.GlossaryViewOmasException;
import org.odpi.openmetadata.accessservices.glossaryview.rest.ExternalGlossaryLink;
import org.odpi.openmetadata.accessservices.glossaryview.rest.Glossary;
import org.odpi.openmetadata.accessservices.glossaryview.rest.GlossaryCategory;
import org.odpi.openmetadata.accessservices.glossaryview.rest.GlossaryTerm;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.SecureController;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.exceptions.CategoryNotFoundException;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.exceptions.GlossaryNotFoundException;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.exceptions.TermNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/glossaries"})
public class GlossaryViewController
extends SecureController {
    @Autowired
    private GlossaryViewClient glossaryViewClient;

    @GetMapping
    public List<Glossary> getAllGlossaries(@RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getAllGlossaries(userId, from, size);
    }

    @GetMapping(value={"/terms"})
    public List<GlossaryTerm> getAllGlossaryTerms(@RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getAllGlossaryTerms(userId, from, size);
    }

    @GetMapping(value={"/categories"})
    public List<GlossaryCategory> getAllGlossaryCategories(@RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getAllCategories(userId, from, size);
    }

    @GetMapping(value={"/{glossaryGUID}"})
    public Glossary getGlossary(@PathVariable(value="glossaryGUID") String glossaryGUID) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        Glossary glossary = this.glossaryViewClient.getGlossary(userId, glossaryGUID);
        if (glossary == null) {
            throw new GlossaryNotFoundException("Could not find glossary with guid " + glossaryGUID);
        }
        return glossary;
    }

    @GetMapping(value={"/{glossaryGUID}/categories"})
    public List<GlossaryCategory> getCategories(@PathVariable(value="glossaryGUID") String glossaryGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getCategories(userId, glossaryGUID, from, size);
    }

    @GetMapping(value={"/{glossaryGUID}/terms"})
    public List<GlossaryTerm> getTermsOfGlossary(@PathVariable(value="glossaryGUID") String glossaryGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getTermsOfGlossary(userId, glossaryGUID, from, size);
    }

    @GetMapping(value={"/{glossaryGUID}/externalGlossaryLinks"})
    public List<ExternalGlossaryLink> getExternalGlossaryLinksOfGlossary(@PathVariable(value="glossaryGUID") String glossaryGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getExternalGlossaryLinksOfGlossary(userId, glossaryGUID, from, size);
    }

    @GetMapping(value={"/terms/{termGUID}"})
    public GlossaryTerm getAntonyms(@PathVariable(value="termGUID") String termGUID) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        GlossaryTerm term = this.glossaryViewClient.getTerm(userId, termGUID);
        if (term == null) {
            throw new TermNotFoundException("Could not find antonym for term with guid " + termGUID);
        }
        return term;
    }

    @GetMapping(value={"/terms/{termGUID}/antonyms"})
    public List<GlossaryTerm> getAntonyms(@PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getAntonyms(userId, termGUID, from, size);
    }

    @GetMapping(value={"/terms/{termGUID}/assignedElements"})
    public List<GlossaryTerm> getAssignedElements(@PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getAssignedElements(userId, termGUID, from, size);
    }

    @GetMapping(value={"/terms/{termGUID}/attributes"})
    public List<GlossaryTerm> getAttributes(@PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getAttributes(userId, termGUID, from, size);
    }

    @GetMapping(value={"/terms/{termGUID}/isA"})
    public List<GlossaryTerm> getIsATerms(@PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getIsA(userId, termGUID, from, size);
    }

    @GetMapping(value={"/terms/{termGUID}/preferredTerms"})
    public List<GlossaryTerm> getPreferredTerms(@PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getPreferredTerms(userId, termGUID, from, size);
    }

    @GetMapping(value={"/terms/{termGUID}/relatedTerms"})
    public List<GlossaryTerm> getRelatedTerms(@PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getRelatedTerms(userId, termGUID, from, size);
    }

    @GetMapping(value={"/terms/{termGUID}/replacementTerms"})
    public List<GlossaryTerm> getReplacementTerms(@PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getReplacementTerms(userId, termGUID, from, size);
    }

    @GetMapping(value={"/terms/{termGUID}/subtypes"})
    public List<GlossaryTerm> getSubtypes(@PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getSubtypes(userId, termGUID, from, size);
    }

    @GetMapping(value={"/terms/{termGUID}/synonyms"})
    public List<GlossaryTerm> getSynonyms(@PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getSynonyms(userId, termGUID, from, size);
    }

    @GetMapping(value={"/terms/{termGUID}/translations"})
    public List<GlossaryTerm> getTranslations(@PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getTranslations(userId, termGUID, from, size);
    }

    @GetMapping(value={"/terms/{termGUID}/types"})
    public List<GlossaryTerm> getTypes(@PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getTypes(userId, termGUID, from, size);
    }

    @GetMapping(value={"/terms/{termGUID}/usedInContext"})
    public List<GlossaryTerm> getUsedInContexts(@PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getUsedInContexts(userId, termGUID, from, size);
    }

    @GetMapping(value={"/terms/{termGUID}/validValues"})
    public List<GlossaryTerm> getValidValues(@PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getValidValues(userId, termGUID, from, size);
    }

    @GetMapping(value={"/terms/{termGUID}/homeGlossary"})
    public Glossary getSynonyms(@PathVariable(value="termGUID") String termGUID) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        Glossary termHomeGlossary = this.glossaryViewClient.getTermHomeGlossary(userId, termGUID);
        if (termHomeGlossary == null) {
            throw new GlossaryNotFoundException("The home glossary was not found for term with guid " + termGUID);
        }
        return termHomeGlossary;
    }

    @GetMapping(value={"/terms/{termGUID}/externalGlossaryLinks"})
    public List<ExternalGlossaryLink> getExternalGlossaryLinksOfTerm(@PathVariable(value="termGUID") String termGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getExternalGlossaryLinksOfTerm(userId, termGUID, from, size);
    }

    @GetMapping(value={"/categories/{categoryGUID}"})
    public GlossaryCategory getCategory(@PathVariable(value="categoryGUID") String categoryGUID, HttpServletRequest request) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        GlossaryCategory category = this.glossaryViewClient.getCategory(userId, categoryGUID);
        if (category == null) {
            throw new CategoryNotFoundException("Could not find the category, please check that the guid is correct " + categoryGUID);
        }
        return category;
    }

    @GetMapping(value={"/categories/{categoryGUID}/homeGlossary"})
    public Glossary getCategoryHomeGlossary(@PathVariable(value="categoryGUID") String categoryGUID) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        Glossary categoryHomeGlossary = this.glossaryViewClient.getCategoryHomeGlossary(userId, categoryGUID);
        if (categoryHomeGlossary == null) {
            throw new GlossaryNotFoundException("Could not find the home glossary, please check that the guid is correct " + categoryGUID);
        }
        return categoryHomeGlossary;
    }

    @GetMapping(value={"/categories/{categoryGUID}/subcategories"})
    public List<GlossaryCategory> getSubcategories(@PathVariable(value="categoryGUID") String categoryGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getSubcategories(userId, categoryGUID, from, size);
    }

    @GetMapping(value={"/categories/{categoryGUID}/terms"})
    public List<GlossaryTerm> getTermsOfCategory(@PathVariable(value="categoryGUID") String categoryGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getTermsOfCategory(userId, categoryGUID, from, size);
    }

    @GetMapping(value={"/categories/{categoryGUID}/externalGlossaryLinks"})
    public List<ExternalGlossaryLink> getExternalGlossaryLinks(@PathVariable(value="categoryGUID") String categoryGUID, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="100") Integer size) throws GlossaryViewOmasException, InvalidParameterException, PropertyServerException {
        String userId = this.getUser();
        return this.glossaryViewClient.getExternalGlossaryLinksOfCategory(userId, categoryGUID, from, size);
    }
}

