/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.api.tex;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.clients.LocalRepositoryServicesClient;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.SecureController;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.tex.ClassificationExplorer;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.tex.EntityExplorer;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.tex.RelationshipExplorer;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.tex.TypeExplorer;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.tex.TypeExplorerController;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.tex.TypeExplorerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TypeExplorerController
extends SecureController {
    private static String className = TypeExplorerController.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)className);
    String metadataCollectionId = null;
    OMRSMetadataCollection metadataCollection = null;

    @PostMapping(path={"/api/types/typeExplorer"})
    public TypeExplorerResponse typeExplorer(@RequestBody Map<String, String> body, HttpServletRequest request) {
        String exceptionMessage;
        String serverName = body.get("serverName");
        String serverURLRoot = body.get("serverURLRoot");
        boolean enterpriseOption = body.get("enterpriseOption").equals("true");
        String userId = SecurityContextHolder.getContext().getAuthentication().getName();
        try {
            TypeExplorer tex = this.getTypeExplorer(userId, serverName, serverURLRoot, enterpriseOption);
            TypeExplorerResponse texResp = tex != null ? new TypeExplorerResponse(Integer.valueOf(200), "", tex) : new TypeExplorerResponse(Integer.valueOf(400), "Could not retrieve type information", null);
            return texResp;
        }
        catch (UserNotAuthorizedException e) {
            exceptionMessage = "Sorry - this username was not authorized to perform the request";
        }
        catch (RepositoryErrorException e) {
            exceptionMessage = "The repository could not be reached, please check the server name and URL root and verify that the server is running ";
        }
        catch (InvalidParameterException e) {
            exceptionMessage = "The request to load type information reported an invalid parameter, please check the server name and URL root parameters";
        }
        TypeExplorerResponse texResp = new TypeExplorerResponse(Integer.valueOf(400), exceptionMessage, null);
        return texResp;
    }

    private TypeExplorer getTypeExplorer(String userId, String serverName, String serverURLRoot, boolean enterpriseOption) throws UserNotAuthorizedException, RepositoryErrorException, InvalidParameterException {
        LocalRepositoryServicesClient repositoryServicesClient = this.getLocalRepositoryServicesClient(serverName, serverURLRoot);
        TypeExplorer tex = new TypeExplorer();
        TypeDefGallery typeDefGallery = repositoryServicesClient.getAllTypes(userId);
        ArrayList typeDefs = typeDefGallery.getTypeDefs();
        for (TypeDef typeDef : typeDefs) {
            TypeDefCategory tdCat = typeDef.getCategory();
            switch (1.$SwitchMap$org$odpi$openmetadata$repositoryservices$connectors$stores$metadatacollectionstore$properties$typedefs$TypeDefCategory[tdCat.ordinal()]) {
                case 1: {
                    EntityExplorer eex = new EntityExplorer((EntityDef)typeDef);
                    tex.addEntityExplorer(typeDef.getName(), eex);
                    break;
                }
                case 2: {
                    RelationshipExplorer rex = new RelationshipExplorer((RelationshipDef)typeDef);
                    tex.addRelationshipExplorer(typeDef.getName(), rex);
                    break;
                }
                case 3: {
                    ClassificationExplorer cex = new ClassificationExplorer((ClassificationDef)typeDef);
                    tex.addClassificationExplorer(typeDef.getName(), cex);
                    break;
                }
            }
        }
        List attributeTypeDefs = typeDefGallery.getAttributeTypeDefs();
        for (AttributeTypeDef attributeTypeDef : attributeTypeDefs) {
            AttributeTypeDefCategory tdCat = attributeTypeDef.getCategory();
            switch (1.$SwitchMap$org$odpi$openmetadata$repositoryservices$connectors$stores$metadatacollectionstore$properties$typedefs$AttributeTypeDefCategory[tdCat.ordinal()]) {
                case 1: {
                    tex.addEnumExplorer(attributeTypeDef.getName(), (EnumDef)attributeTypeDef);
                    break;
                }
            }
        }
        tex.resolve();
        return tex;
    }

    private LocalRepositoryServicesClient getLocalRepositoryServicesClient(String serverName, String serverURLRoot) throws InvalidParameterException {
        String restURLRoot = serverURLRoot + "/servers/" + serverName;
        LocalRepositoryServicesClient client = new LocalRepositoryServicesClient(serverName, restURLRoot);
        return client;
    }
}

