/* SPDX-License-Identifier: Apache-2.0 */
/* Copyright Contributors to the ODPi Egeria project. */
package org.odpi.openmetadata.userinterface.uichassis.springboot.api;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.info.BuildProperties;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;

import jakarta.servlet.http.HttpServletRequest;

@RestController
@RequestMapping("/api/about")
public class AboutController {

    @Autowired( required = false )
    BuildProperties buildProperties;

    @GetMapping
    public BuildProperties getBuildProperties(HttpServletRequest request) throws HttpClientErrorException {
        return buildProperties;
    }

}
