/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.info.License;
import org.odpi.openmetadata.accessservices.assetcatalog.AssetCatalog;
import org.odpi.openmetadata.accessservices.glossaryview.client.GlossaryViewClient;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.governanceservers.openlineage.client.OpenLineageClient;
import org.odpi.openmetadata.http.HttpHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@SpringBootApplication(scanBasePackages={"${scan.packages}"})
@OpenAPIDefinition(info=@Info(title="Egeria's Spring Boot based UI RESTful web services API", version="4.3", description="", license=@License(name="Apache-2.0 License", url="https://www.apache.org/licenses/LICENSE-2.0"), contact=@Contact(url="https://egeria-project.org", name="Egeria Project", email="egeria-technical-discuss@lists.lfaidata.foundation")), externalDocs=@ExternalDocumentation(description="Egeria documentation", url="https://egeria-project.org"))
public class EgeriaUIPlatform {
    private static final Logger LOG = LoggerFactory.getLogger(EgeriaUIPlatform.class);
    @Autowired
    private Environment env;
    @Value(value="${strict.ssl}")
    Boolean strictSSL;
    @Value(value="${cors.allowed-origins}")
    String[] allowedOrigins;

    public static void main(String[] args) {
        SpringApplication.run(EgeriaUIPlatform.class, (String[])args);
    }

    @Bean
    public InitializingBean getInitialize() {
        return () -> {
            if (!this.strictSSL.booleanValue()) {
                HttpHelper.noStrictSSL();
            } else if (System.getProperty("javax.net.ssl.trustStore") == null) {
                System.setProperty("javax.net.ssl.trustStore", this.env.getProperty("server.ssl.trust-store"));
                System.setProperty("javax.net.ssl.trustStorePassword", this.env.getProperty("server.ssl.trust-store-password"));
                System.out.println("test");
            }
        };
    }

    @Bean
    public AssetCatalog getAssetCatalog(@Value(value="${omas.server.url}") String serverUrl, @Value(value="${omas.server.name}") String serverName) throws InvalidParameterException {
        return new AssetCatalog(serverName, serverUrl);
    }

    @Bean
    public GlossaryViewClient getGlossaryViewClient(@Value(value="${omas.server.url}") String serverUrl, @Value(value="${omas.server.name}") String serverName) throws InvalidParameterException {
        return new GlossaryViewClient(serverName, serverUrl);
    }

    @Bean
    public OpenLineageClient getOpenLineage(@Value(value="${open.lineage.server.url}") String serverUrl, @Value(value="${open.lineage.server.name}") String serverName) throws InvalidParameterException {
        return new OpenLineageClient(serverName, serverUrl);
    }
}

