/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RexEntityDigest;
import org.odpi.openmetadata.userinterface.uichassis.springboot.api.rex.RexRelationshipDigest;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RexExpandedRelationship {
    private Relationship relationship;
    private RexRelationshipDigest relationshipDigest;
    private RexEntityDigest entityOneDigest;
    private RexEntityDigest entityTwoDigest;
    private String serverName;

    public RexExpandedRelationship(Relationship relationship, String label, RexEntityDigest digest1, RexEntityDigest digest2, String serverName) {
        this.relationship = relationship;
        this.relationshipDigest = new RexRelationshipDigest(relationship.getGUID(), label, digest1.getEntityGUID(), digest2.getEntityGUID(), Integer.valueOf(0), Integer.valueOf(0), relationship.getMetadataCollectionName());
        this.entityOneDigest = digest1;
        this.entityTwoDigest = digest2;
        this.serverName = serverName;
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    public RexRelationshipDigest getRelationshipDigest() {
        return this.relationshipDigest;
    }

    public RexEntityDigest getEntityOneDigest() {
        return this.entityOneDigest;
    }

    public RexEntityDigest getEntityTwoDigest() {
        return this.entityTwoDigest;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setRelationship(Relationship relationship) {
        this.relationship = relationship;
    }

    public void setRelationshipDigest(RexRelationshipDigest relationshipDigest) {
        this.relationshipDigest = relationshipDigest;
    }

    public void setEntityOneDigest(RexEntityDigest entityOneDigest) {
        this.entityOneDigest = entityOneDigest;
    }

    public void setEntityTwoDigest(RexEntityDigest entityTwoDigest) {
        this.entityTwoDigest = entityTwoDigest;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String toString() {
        return "RexExpandedRelationship{, relationship=" + this.relationship + ", relationshipDigest=" + this.relationshipDigest + ", entityOneDigest=" + this.entityOneDigest + ", entityTwoDigest=" + this.entityTwoDigest + ", serverName=" + this.serverName + "}";
    }
}

