/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.userinterface.uichassis.springboot.auth.demo;

import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.demo.DemoUsers;
import org.odpi.openmetadata.userinterface.uichassis.springboot.auth.demo.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.security.authentication.AccountStatusUserDetailsChecker;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service(value="demoUserDetailsService")
@ConditionalOnProperty(value={"authentication.source"}, havingValue="demo")
@EnableConfigurationProperties(value={DemoUsers.class})
public class UserDetailsServiceImpl
implements UserDetailsService {
    private final AccountStatusUserDetailsChecker detailsChecker = new AccountStatusUserDetailsChecker();
    @Autowired
    DemoUsers demoUsers;

    public final User loadUserByUsername(String username) throws UsernameNotFoundException {
        User user = this.demoUsers.getUser(username);
        this.detailsChecker.check((UserDetails)user);
        return user;
    }
}

