/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.controls;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogPlaceholderProperty;
import org.odpi.openmetadata.frameworks.connectors.controls.ConfigurationPropertyType;

public enum UnityCatalogConfigurationProperty {
    FRIENDSHIP_GUID("UnityCatalogFriendshipGUID", "Unique identifier of the integration connector that is able to catalog the contents of a Unity Catalog (UC) catalog.", "string", "48886e79-a822-45a5-ab37-b5cefade9d8a", false),
    INCLUDE_CATALOG_NAMES("includeCatalogNames", "Provide a comma-separated list of catalog names that should be catalogued.  Other catalogs will be ignored.", "array<string>", "catalog1,catalog2", false),
    EXCLUDE_CATALOG_NAMES("excludeCatalogNames", "Provide a comma-separated list of catalog names that should not be catalogued.  Only catalogs not in this list will be catalogued.", "array<string>", "catalog1,catalog2", false),
    INCLUDE_SCHEMA_NAMES("includeSchemaNames", "Provide a comma-separated list of schema names that should be catalogued.  Other schemas will be ignored.", "array<string>", "schema1,schema2", false),
    EXCLUDE_SCHEMA_NAMES("excludeSchemaNames", "Provide a comma-separated list of schema names that should not be catalogued.  Only schemas not in this list will be catalogued.", "array<string>", "schema1,schema2", false),
    INCLUDE_TABLE_NAMES("includeTableNames", "Provide a comma-separated list of table names that should be catalogued.  Other tables will be ignored.", "array<string>", "table1,table2", false),
    EXCLUDE_TABLE_NAMES("excludeTableNames", "Provide a comma-separated list of table names that should not be catalogued.  Only tables not in this list will be catalogued.", "array<string>", "table1,table2", false),
    INCLUDE_FUNCTION_NAMES("includeFunctionNames", "Provide a comma-separated list of function names that should be catalogued.  Other functions will be ignored.", "array<string>", "function1,function22", false),
    EXCLUDE_FUNCTION_NAMES("excludeFunctionNames", "Provide a comma-separated list of function names that should not be catalogued.  Only functions not in this list will be catalogued.", "array<string>", "function1,function2", false),
    INCLUDE_VOLUME_NAMES("includeVolumeNames", "Provide a comma-separated list of volume names that should be catalogued.  Other volumes will be ignored.", "array<string>", "volume1,volume2", false),
    EXCLUDE_VOLUME_NAMES("excludeVolumeNames", "Provide a comma-separated list of volume names that should not be catalogued.  Only volume not in this list will be catalogued.", "array<string>", "volume1,volume2", false),
    CATALOG_NAME(UnityCatalogPlaceholderProperty.CATALOG_NAME.getName(), UnityCatalogPlaceholderProperty.CATALOG_NAME.getDescription(), UnityCatalogPlaceholderProperty.CATALOG_NAME.getDataType(), UnityCatalogPlaceholderProperty.CATALOG_NAME.getExample(), false),
    SCHEMA_NAME(UnityCatalogPlaceholderProperty.SCHEMA_NAME.getName(), UnityCatalogPlaceholderProperty.SCHEMA_NAME.getDescription(), UnityCatalogPlaceholderProperty.SCHEMA_NAME.getDataType(), UnityCatalogPlaceholderProperty.SCHEMA_NAME.getExample(), false);

    public final String name;
    public final String description;
    public final String dataType;
    public final String example;
    public final boolean isPlaceholder;

    private UnityCatalogConfigurationProperty(String name, String description, String dataType, String example, boolean isPlaceholder) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.example = example;
        this.isPlaceholder = isPlaceholder;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getExample() {
        return this.example;
    }

    public boolean isPlaceholder() {
        return this.isPlaceholder;
    }

    public static List<String> getUnityCatalogServerRecognizedConfigurationProperties() {
        ArrayList<String> recognizedConfigurationProperties = new ArrayList<String>();
        recognizedConfigurationProperties.add(FRIENDSHIP_GUID.getName());
        recognizedConfigurationProperties.add(INCLUDE_CATALOG_NAMES.getName());
        recognizedConfigurationProperties.add(EXCLUDE_CATALOG_NAMES.getName());
        return recognizedConfigurationProperties;
    }

    public static List<ConfigurationPropertyType> getUnityCatalogServerConfigurationPropertyTypes() {
        ArrayList<ConfigurationPropertyType> configurationPropertyTypes = new ArrayList<ConfigurationPropertyType>();
        configurationPropertyTypes.add(FRIENDSHIP_GUID.getConfigurationPropertyType());
        configurationPropertyTypes.add(INCLUDE_CATALOG_NAMES.getConfigurationPropertyType());
        configurationPropertyTypes.add(EXCLUDE_CATALOG_NAMES.getConfigurationPropertyType());
        return configurationPropertyTypes;
    }

    public static List<String> getUnityCatalogInsideCatalogRecognizedConfigurationProperties() {
        ArrayList<String> recognizedConfigurationProperties = new ArrayList<String>();
        recognizedConfigurationProperties.add(INCLUDE_SCHEMA_NAMES.getName());
        recognizedConfigurationProperties.add(EXCLUDE_SCHEMA_NAMES.getName());
        recognizedConfigurationProperties.add(INCLUDE_TABLE_NAMES.getName());
        recognizedConfigurationProperties.add(EXCLUDE_TABLE_NAMES.getName());
        recognizedConfigurationProperties.add(INCLUDE_FUNCTION_NAMES.getName());
        recognizedConfigurationProperties.add(EXCLUDE_FUNCTION_NAMES.getName());
        recognizedConfigurationProperties.add(INCLUDE_VOLUME_NAMES.getName());
        recognizedConfigurationProperties.add(EXCLUDE_VOLUME_NAMES.getName());
        return recognizedConfigurationProperties;
    }

    public static List<ConfigurationPropertyType> getUnityCatalogInsideCatalogConfigurationPropertyTypes() {
        ArrayList<ConfigurationPropertyType> configurationPropertyTypes = new ArrayList<ConfigurationPropertyType>();
        configurationPropertyTypes.add(INCLUDE_SCHEMA_NAMES.getConfigurationPropertyType());
        configurationPropertyTypes.add(EXCLUDE_SCHEMA_NAMES.getConfigurationPropertyType());
        configurationPropertyTypes.add(INCLUDE_TABLE_NAMES.getConfigurationPropertyType());
        configurationPropertyTypes.add(EXCLUDE_TABLE_NAMES.getConfigurationPropertyType());
        configurationPropertyTypes.add(INCLUDE_FUNCTION_NAMES.getConfigurationPropertyType());
        configurationPropertyTypes.add(EXCLUDE_FUNCTION_NAMES.getConfigurationPropertyType());
        configurationPropertyTypes.add(INCLUDE_VOLUME_NAMES.getConfigurationPropertyType());
        configurationPropertyTypes.add(EXCLUDE_VOLUME_NAMES.getConfigurationPropertyType());
        return configurationPropertyTypes;
    }

    public static List<String> getUnityCatalogInsideCatalogSurveyRecognizedConfigurationProperties() {
        ArrayList<String> recognizedConfigurationProperties = new ArrayList<String>();
        recognizedConfigurationProperties.add(CATALOG_NAME.getName());
        return recognizedConfigurationProperties;
    }

    public static List<ConfigurationPropertyType> getUnityCatalogInsideCatalogSurveyConfigurationPropertyTypes() {
        ArrayList<ConfigurationPropertyType> configurationPropertyTypes = new ArrayList<ConfigurationPropertyType>();
        configurationPropertyTypes.add(CATALOG_NAME.getConfigurationPropertyType());
        return configurationPropertyTypes;
    }

    public static List<String> getUnityCatalogInsideSchemaSurveyRecognizedConfigurationProperties() {
        ArrayList<String> recognizedConfigurationProperties = new ArrayList<String>();
        recognizedConfigurationProperties.add(CATALOG_NAME.getName());
        recognizedConfigurationProperties.add(SCHEMA_NAME.getName());
        return recognizedConfigurationProperties;
    }

    public static List<ConfigurationPropertyType> getUnityCatalogInsideSchemaSurveyConfigurationPropertyTypes() {
        ArrayList<ConfigurationPropertyType> configurationPropertyTypes = new ArrayList<ConfigurationPropertyType>();
        configurationPropertyTypes.add(CATALOG_NAME.getConfigurationPropertyType());
        configurationPropertyTypes.add(SCHEMA_NAME.getConfigurationPropertyType());
        return configurationPropertyTypes;
    }

    public static List<ConfigurationPropertyType> getConfigurationPropertyTypes() {
        ArrayList<ConfigurationPropertyType> configurationPropertyTypes = new ArrayList<ConfigurationPropertyType>();
        for (UnityCatalogConfigurationProperty configurationProperty : UnityCatalogConfigurationProperty.values()) {
            configurationPropertyTypes.add(configurationProperty.getConfigurationPropertyType());
        }
        return configurationPropertyTypes;
    }

    public ConfigurationPropertyType getConfigurationPropertyType() {
        ConfigurationPropertyType configurationPropertyType = new ConfigurationPropertyType();
        configurationPropertyType.setName(this.name);
        configurationPropertyType.setDescription(this.description);
        configurationPropertyType.setDataType(this.dataType);
        configurationPropertyType.setExample(this.example);
        configurationPropertyType.setRequired(this.isPlaceholder);
        return configurationPropertyType;
    }

    public String toString() {
        return "ConfigurationProperty{ name=" + this.name + "}";
    }
}

