/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalColumnMetric;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalSchemaMetric;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalTableMetric;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.SurveyMetric;

public enum UnityCatalogMetric implements SurveyMetric
{
    NO_OF_CATALOGS("numberOfCatalogs", "long", "Number of Catalogs", "Number of catalogs defined in this server."),
    NO_OF_SCHEMAS("numberOfSchemas", "long", "Number of Schemas", "Number of schemas found in the survey target (server or catalog)."),
    NO_OF_TABLES("numberOfTables", "long", "Number of Tables", "Number of tables found in the survey target (server, catalog or schema)."),
    NO_OF_FUNCTIONS("numberOfFunctions", "long", "Number of Functions", "Number of functions found in the survey target (server, catalog or schema)."),
    NO_OF_VOLUMES("numberOfVolumes", "long", "Number of Volumes", "Number of volumes found in the survey target (server, catalog or schema).");

    public final String propertyName;
    public final String dataType;
    public final String displayName;
    public final String description;

    private UnityCatalogMetric(String propertyName, String dataType, String displayName, String description) {
        this.propertyName = propertyName;
        this.dataType = dataType;
        this.displayName = displayName;
        this.description = description;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<SurveyMetric> getServerMetrics() {
        return new ArrayList<SurveyMetric>(Arrays.asList(UnityCatalogMetric.values()));
    }

    public static List<SurveyMetric> getCatalogMetrics() {
        ArrayList<SurveyMetric> metrics = new ArrayList<SurveyMetric>();
        metrics.add(NO_OF_SCHEMAS);
        metrics.add(NO_OF_FUNCTIONS);
        metrics.add(NO_OF_TABLES);
        metrics.add(NO_OF_VOLUMES);
        return metrics;
    }

    public static List<SurveyMetric> getSchemaMetrics() {
        ArrayList<SurveyMetric> metrics = new ArrayList<SurveyMetric>();
        metrics.add((SurveyMetric)RelationalSchemaMetric.TOTAL_TABLE_SIZE);
        metrics.add((SurveyMetric)RelationalSchemaMetric.TABLE_COUNT);
        return metrics;
    }

    public static List<SurveyMetric> getTableMetrics() {
        return RelationalTableMetric.getMetrics();
    }

    public static List<SurveyMetric> getColumnMetrics() {
        return RelationalColumnMetric.getMetrics();
    }

    public String toString() {
        return "UnityCatalogMetric{" + this.displayName + "}";
    }
}

