/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.resource;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientConnector;
import org.odpi.openmetadata.adapters.connectors.restclients.factory.RESTClientFactory;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.ffdc.UCAuditCode;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.ffdc.UCErrorCode;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.CatalogInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.CatalogProperties;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.ColumnInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.DataSourceFormat;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.FunctionInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.FunctionProperties;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.SchemaInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.SchemaProperties;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.TableInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.TableProperties;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.TableType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.VolumeInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.VolumeProperties;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.VolumeType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.rest.ListCatalogsResponse;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.rest.ListFunctionsResponse;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.rest.ListSchemasResponse;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.rest.ListTablesResponse;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.rest.ListVolumesResponse;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.rest.UpdateElementRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;

public class OSSUnityCatalogResourceConnector
extends ConnectorBase
implements AuditLoggingComponent {
    private AuditLog auditLog = null;
    private String connectorName = "Unity Catalog Connector";
    private String targetRootURL = null;
    private String ucInstanceName = "Unity Catalog";
    private RESTClientConnector clientConnector = null;

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    public void setUCInstanceName(String ucInstanceName) {
        this.ucInstanceName = ucInstanceName;
    }

    public void start() throws ConnectorCheckedException {
        EndpointProperties endpoint;
        super.start();
        String methodName = "start";
        if (this.connectionProperties.getConnectionName() != null) {
            this.connectorName = this.connectionProperties.getConnectionName();
        }
        if ((endpoint = this.connectionProperties.getEndpoint()) != null) {
            this.targetRootURL = endpoint.getAddress();
        }
        if (this.targetRootURL == null) {
            throw new ConnectorCheckedException(UCErrorCode.NULL_URL.getMessageDefinition(this.connectorName), ((Object)((Object)this)).getClass().getName(), "start");
        }
        try {
            RESTClientFactory factory = new RESTClientFactory(this.ucInstanceName, this.targetRootURL, this.connectionProperties.getUserId(), this.connectionProperties.getClearPassword(), this.secretsStoreConnectorMap, this.auditLog);
            this.clientConnector = factory.getClientConnector();
            this.listCatalogs();
        }
        catch (Exception error) {
            if (this.auditLog != null) {
                this.auditLog.logException("start", UCAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "start", error.getMessage()), (Throwable)error);
            }
            throw new ConnectorCheckedException(UCErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "start", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "start", (Throwable)error);
        }
    }

    public String getNameFromFullName(String fullName) {
        String[] nameParts = fullName.split("\\.");
        return nameParts[nameParts.length - 1];
    }

    public String getSchemaNameFromThreePartName(String threePartName) {
        String[] nameParts = threePartName.split("\\.");
        if (nameParts.length > 1) {
            return nameParts[1];
        }
        return null;
    }

    public String getCatalogNameFromThreePartName(String threePartName) {
        String[] nameParts = threePartName.split("\\.");
        if (nameParts.length > 0) {
            return nameParts[0];
        }
        return null;
    }

    public CatalogInfo createCatalog(String name, String comment, Map<String, String> properties) throws PropertyServerException {
        String methodName = "createCatalog";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/catalogs";
        CatalogProperties catalogProperties = new CatalogProperties();
        catalogProperties.setName(name);
        catalogProperties.setComment(comment);
        return this.callPostRESTCallNoParams("createCatalog", CatalogInfo.class, urlTemplate, catalogProperties);
    }

    public void deleteCatalog(String name, boolean force) throws PropertyServerException {
        String methodName = "deleteCatalog";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/catalogs/{0}?force={1}";
        this.callDeleteRESTCall("deleteCatalog", Object.class, urlTemplate, name, Boolean.toString(force));
    }

    public CatalogInfo getCatalog(String name) throws PropertyServerException {
        String methodName = "getCatalog";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/catalogs/{0}";
        return this.callGetRESTCall("getCatalog", CatalogInfo.class, urlTemplate, name);
    }

    public List<CatalogInfo> listCatalogs() throws PropertyServerException {
        String methodName = "listCatalogs";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/catalogs";
        ListCatalogsResponse response = this.callGetRESTCallNoParams("listCatalogs", ListCatalogsResponse.class, urlTemplate);
        if (response != null) {
            return response.getCatalogs();
        }
        return null;
    }

    public CatalogInfo updateCatalog(String name, String newName, String comment, Map<String, String> properties) throws PropertyServerException {
        String methodName = "updateCatalog";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/catalogs/{0}";
        UpdateElementRequestBody requestBody = new UpdateElementRequestBody();
        requestBody.setNew_name(newName);
        requestBody.setComment(comment);
        requestBody.setProperties(properties);
        if (newName == null || newName.equals(name)) {
            requestBody.setNew_name(name + "TemporaryWorkaroundName");
            this.callPatchRESTCall("updateCatalog", CatalogInfo.class, urlTemplate, requestBody, name);
            requestBody.setNew_name(name);
            return this.callPatchRESTCall("updateCatalog", CatalogInfo.class, urlTemplate, requestBody, name);
        }
        return this.callPatchRESTCall("updateCatalog", CatalogInfo.class, urlTemplate, requestBody, name);
    }

    public SchemaInfo createSchema(String name, String catalogName, String comment, Map<String, String> properties) throws PropertyServerException {
        String methodName = "createSchema";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/schemas";
        SchemaProperties schemaProperties = new SchemaProperties();
        schemaProperties.setName(name);
        schemaProperties.setCatalog_name(catalogName);
        schemaProperties.setComment(comment);
        return this.callPostRESTCallNoParams("createSchema", SchemaInfo.class, urlTemplate, schemaProperties);
    }

    public void deleteSchema(String fullName, boolean force) throws PropertyServerException {
        String methodName = "deleteSchema";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/schemas/{0}?force={1}";
        this.callDeleteRESTCall("deleteSchema", Object.class, urlTemplate, fullName, Boolean.toString(force));
    }

    public SchemaInfo getSchema(String fullName) throws PropertyServerException {
        String methodName = "getSchema";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/schemas/{0}";
        return this.callGetRESTCall("getSchema", SchemaInfo.class, urlTemplate, fullName);
    }

    public List<SchemaInfo> listSchemas(String catalogName) throws PropertyServerException {
        String methodName = "listSchemas";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/schemas?catalog_name={1}";
        ListSchemasResponse response = this.callGetRESTCall("listSchemas", ListSchemasResponse.class, urlTemplate, catalogName);
        if (response != null) {
            return response.getSchemas();
        }
        return null;
    }

    public SchemaInfo updateSchema(String fullName, String newName, String comment, Map<String, String> properties) throws PropertyServerException {
        String methodName = "updateSchema";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/schemas/{0}";
        String oldName = this.getNameFromFullName(fullName);
        UpdateElementRequestBody requestBody = new UpdateElementRequestBody();
        requestBody.setNew_name(newName);
        requestBody.setComment(comment);
        requestBody.setProperties(properties);
        if (newName == null || newName.equals(oldName)) {
            requestBody.setNew_name(oldName + "TemporaryWorkaroundName");
            this.callPatchRESTCall("updateSchema", SchemaInfo.class, urlTemplate, requestBody, fullName);
            requestBody.setNew_name(oldName);
            return this.callPatchRESTCall("updateSchema", SchemaInfo.class, urlTemplate, requestBody, fullName);
        }
        requestBody.setNew_name(newName);
        return this.callPatchRESTCall("updateSchema", SchemaInfo.class, urlTemplate, requestBody, fullName);
    }

    public VolumeInfo createVolume(String name, String catalogName, String schemaName, String comment, VolumeType volumeType, String storageLocation) throws PropertyServerException {
        VolumeProperties volumeProperties = new VolumeProperties();
        volumeProperties.setName(name);
        volumeProperties.setCatalog_name(catalogName);
        volumeProperties.setSchema_name(schemaName);
        volumeProperties.setComment(comment);
        volumeProperties.setVolume_type(volumeType);
        volumeProperties.setStorage_location(storageLocation);
        return this.createVolume(volumeProperties);
    }

    public VolumeInfo createVolume(VolumeProperties volumeProperties) throws PropertyServerException {
        String methodName = "createVolume";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/volumes";
        return this.callPostRESTCallNoParams("createVolume", VolumeInfo.class, urlTemplate, volumeProperties);
    }

    public void deleteVolume(String fullName) throws PropertyServerException {
        String methodName = "deleteVolume";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/volumes/{0}";
        this.callDeleteRESTCall("deleteVolume", Object.class, urlTemplate, fullName);
    }

    public VolumeInfo getVolume(String fullName) throws PropertyServerException {
        String methodName = "getVolume";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/volumes/{0}";
        return this.callGetRESTCall("getVolume", VolumeInfo.class, urlTemplate, fullName);
    }

    public List<VolumeInfo> listVolumes(String catalogName, String schemaName) throws PropertyServerException {
        String methodName = "listVolumes";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/volumes?catalog_name={1}&schema_name={2}";
        ListVolumesResponse response = this.callGetRESTCall("listVolumes", ListVolumesResponse.class, urlTemplate, catalogName, schemaName);
        if (response != null) {
            return response.getVolumes();
        }
        return null;
    }

    public VolumeInfo updateVolume(String fullName, String newName, String comment) throws PropertyServerException {
        String methodName = "updateVolume";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/volumes/{0}";
        String oldName = this.getNameFromFullName(fullName);
        UpdateElementRequestBody requestBody = new UpdateElementRequestBody();
        requestBody.setComment(comment);
        if (newName == null || newName.equals(oldName)) {
            requestBody.setNew_name(oldName + "TemporaryWorkaroundName");
            this.callPatchRESTCall("updateVolume", VolumeInfo.class, urlTemplate, requestBody, fullName);
            requestBody.setNew_name(oldName);
            return this.callPatchRESTCall("updateVolume", VolumeInfo.class, urlTemplate, requestBody, fullName);
        }
        requestBody.setNew_name(newName);
        return this.callPatchRESTCall("updateVolume", VolumeInfo.class, urlTemplate, requestBody, fullName);
    }

    public TableInfo createTable(String name, String catalogName, String schemaName, String comment, TableType tableType, DataSourceFormat dataSourceFormat, List<ColumnInfo> columns, String storageLocation, Map<String, String> properties) throws PropertyServerException {
        TableProperties tableProperties = new TableProperties();
        tableProperties.setName(name);
        tableProperties.setCatalog_name(catalogName);
        tableProperties.setSchema_name(schemaName);
        tableProperties.setComment(comment);
        tableProperties.setTable_type(tableType);
        tableProperties.setData_source_format(dataSourceFormat);
        tableProperties.setColumns(columns);
        tableProperties.setStorage_location(storageLocation);
        return this.createTable(tableProperties);
    }

    public TableInfo createTable(TableProperties tableProperties) throws PropertyServerException {
        String methodName = "createTable";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/tables";
        return this.callPostRESTCallNoParams("createTable", TableInfo.class, urlTemplate, tableProperties);
    }

    public void deleteTable(String fullName) throws PropertyServerException {
        String methodName = "deleteTable";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/tables/{0}";
        this.callDeleteRESTCall("deleteTable", Object.class, urlTemplate, fullName);
    }

    public TableInfo getTable(String fullName) throws PropertyServerException {
        String methodName = "getTable";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/tables/{0}";
        return this.callGetRESTCall("getTable", TableInfo.class, urlTemplate, fullName);
    }

    public List<TableInfo> listTables(String catalogName, String schemaName) throws PropertyServerException {
        String methodName = "listTables";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/tables?catalog_name={1}&schema_name={2}";
        ListTablesResponse response = this.callGetRESTCall("listTables", ListTablesResponse.class, urlTemplate, catalogName, schemaName);
        if (response != null) {
            return response.getTables();
        }
        return null;
    }

    public FunctionInfo createFunction(FunctionProperties functionProperties) throws PropertyServerException {
        String methodName = "createFunction";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/functions";
        return this.callPostRESTCallNoParams("createFunction", FunctionInfo.class, urlTemplate, functionProperties);
    }

    public void deleteFunction(String fullName) throws PropertyServerException {
        String methodName = "deleteFunction";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/functions/{0}";
        this.callDeleteRESTCall("deleteFunction", Object.class, urlTemplate, fullName);
    }

    public FunctionInfo getFunction(String fullName) throws PropertyServerException {
        String methodName = "getFunction";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/functions/{0}";
        return this.callGetRESTCall("getFunction", FunctionInfo.class, urlTemplate, fullName);
    }

    public List<FunctionInfo> listFunctions(String catalogName, String schemaName) throws PropertyServerException {
        String methodName = "listFunction";
        String urlTemplate = this.targetRootURL + "/api/2.1/unity-catalog/functions?catalog_name={1}&schema_name={2}";
        ListFunctionsResponse response = this.callGetRESTCall("listFunction", ListFunctionsResponse.class, urlTemplate, catalogName, schemaName);
        if (response != null) {
            return response.getFunctions();
        }
        return null;
    }

    private <T> T callGetRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callGetRESTCall(methodName, returnClass, urlTemplate, new Object[0]);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callGetRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callGetRESTCall(methodName, returnClass, urlTemplate, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callPostRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPostRESTCallNoParams(methodName, returnClass, urlTemplate, requestBody);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callPatchRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callPatchRESTCall(methodName, returnClass, urlTemplate, requestBody, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private <T> T callDeleteRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            return (T)this.clientConnector.callDeleteRESTCall(methodName, returnClass, urlTemplate, null, params);
        }
        catch (Exception error) {
            this.logRESTCallException(methodName, true, error);
            return null;
        }
    }

    private void logRESTCallException(String methodName, boolean logMessage, Exception error) throws PropertyServerException {
        if (this.auditLog != null && logMessage) {
            this.auditLog.logException(methodName, UCAuditCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(methodName, this.ucInstanceName, this.targetRootURL, error.getMessage()), (Throwable)error);
        }
        throw new PropertyServerException(UCErrorCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(methodName, this.ucInstanceName, this.targetRootURL, error.getMessage()), ((Object)((Object)this)).getClass().getName(), methodName, (Throwable)error);
    }
}

