/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.survey;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogAnnotationType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogMetric;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.ffdc.UCErrorCode;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.FunctionInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.TableInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.VolumeInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.OSSUnityCatalogResourceConnector;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.survey.OSSUnityCatalogServerSurveyBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceMeasureAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceProfileAnnotation;

public class OSSUnityCatalogInsideSchemaSurveyService
extends OSSUnityCatalogServerSurveyBase {
    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        this.setFinalAnalysisStep();
        try {
            this.connector = this.performCheckAssetAnalysisStep(OSSUnityCatalogResourceConnector.class, OpenMetadataType.SOFTWARE_SERVER.typeName);
            OSSUnityCatalogResourceConnector ucConnector = (OSSUnityCatalogResourceConnector)this.connector;
            String catalogName = this.getCatalogName();
            String schemaName = this.getSchemaName();
            AnnotationStore annotationStore = this.surveyContext.getAnnotationStore();
            annotationStore.setAnalysisStep(AnalysisStep.MEASURE_RESOURCE.getName());
            HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties> functionList = new HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties>();
            HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties> tableList = new HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties>();
            HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties> volumeList = new HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties>();
            long functionCount = 0L;
            long tableCount = 0L;
            long volumeCount = 0L;
            if (catalogName != null && schemaName != null) {
                List<FunctionInfo> list;
                List<TableInfo> tableInfos;
                List<VolumeInfo> volumeInfos = ucConnector.listVolumes(catalogName, schemaName);
                if (volumeInfos != null) {
                    for (VolumeInfo volumeInfo : volumeInfos) {
                        if (volumeInfo == null) continue;
                        OSSUnityCatalogServerSurveyBase.ResourceProperties resourceProperties = new OSSUnityCatalogServerSurveyBase.ResourceProperties();
                        resourceProperties.description = volumeInfo.getComment();
                        resourceProperties.creationDate = new Date(volumeInfo.getCreated_at());
                        if (volumeInfo.getUpdated_at() != 0L) {
                            resourceProperties.lastUpdateDate = new Date(volumeInfo.getUpdated_at());
                        }
                        volumeList.put(volumeInfo.getFull_name(), resourceProperties);
                        ++volumeCount;
                    }
                }
                if ((tableInfos = ucConnector.listTables(catalogName, schemaName)) != null) {
                    for (TableInfo tableInfo : tableInfos) {
                        if (tableInfo == null) continue;
                        OSSUnityCatalogServerSurveyBase.ResourceProperties resourceProperties = new OSSUnityCatalogServerSurveyBase.ResourceProperties();
                        resourceProperties.description = tableInfo.getComment();
                        resourceProperties.creationDate = new Date(tableInfo.getCreated_at());
                        if (tableInfo.getUpdated_at() != 0L) {
                            resourceProperties.lastUpdateDate = new Date(tableInfo.getUpdated_at());
                        }
                        tableList.put(tableInfo.getCatalog_name() + "." + tableInfo.getSchema_name() + "." + tableInfo.getName(), resourceProperties);
                        ++tableCount;
                    }
                }
                if ((list = ucConnector.listFunctions(catalogName, schemaName)) != null) {
                    for (FunctionInfo functionInfo : list) {
                        if (functionInfo == null) continue;
                        OSSUnityCatalogServerSurveyBase.ResourceProperties resourceProperties = new OSSUnityCatalogServerSurveyBase.ResourceProperties();
                        resourceProperties.description = functionInfo.getComment();
                        resourceProperties.creationDate = new Date(functionInfo.getCreated_at());
                        if (functionInfo.getUpdated_at() != 0L) {
                            resourceProperties.lastUpdateDate = new Date(functionInfo.getUpdated_at());
                        }
                        functionList.put(functionInfo.getFull_name(), resourceProperties);
                        ++functionCount;
                    }
                }
            }
            ResourceMeasureAnnotation resourceMeasureAnnotation = new ResourceMeasureAnnotation();
            this.setUpAnnotation((Annotation)resourceMeasureAnnotation, UnityCatalogAnnotationType.SCHEMA_METRICS);
            HashMap<String, String> resourceProperties = new HashMap<String, String>();
            resourceProperties.put(UnityCatalogMetric.NO_OF_FUNCTIONS.getPropertyName(), Long.toString(functionCount));
            resourceProperties.put(UnityCatalogMetric.NO_OF_TABLES.getPropertyName(), Long.toString(tableCount));
            resourceProperties.put(UnityCatalogMetric.NO_OF_VOLUMES.getPropertyName(), Long.toString(volumeCount));
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            hashMap.put(UnityCatalogMetric.NO_OF_FUNCTIONS.getPropertyName(), functionCount);
            hashMap.put(UnityCatalogMetric.NO_OF_TABLES.getPropertyName(), tableCount);
            hashMap.put(UnityCatalogMetric.NO_OF_VOLUMES.getPropertyName(), volumeCount);
            resourceMeasureAnnotation.setJsonProperties(this.getJSONProperties(hashMap));
            resourceMeasureAnnotation.setResourceProperties(resourceProperties);
            annotationStore.addAnnotation((Annotation)resourceMeasureAnnotation, null);
            if (!this.finalAnalysisStep.equals(AnalysisStep.MEASURE_RESOURCE.getName())) {
                annotationStore.setAnalysisStep(AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName());
                ResourceProfileAnnotation resourceProfileAnnotation = this.getNameListAnnotation(UnityCatalogAnnotationType.FUNCTION_LIST, functionList);
                annotationStore.addAnnotation((Annotation)resourceProfileAnnotation, null);
                ResourceProfileAnnotation resourceProfileAnnotation2 = this.getNameListAnnotation(UnityCatalogAnnotationType.TABLE_LIST, tableList);
                annotationStore.addAnnotation((Annotation)resourceProfileAnnotation2, null);
                ResourceProfileAnnotation resourceProfileAnnotation3 = this.getNameListAnnotation(UnityCatalogAnnotationType.VOLUME_LIST, volumeList);
                annotationStore.addAnnotation((Annotation)resourceProfileAnnotation3, null);
                if (!this.finalAnalysisStep.equals(AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName())) {
                    annotationStore.setAnalysisStep(AnalysisStep.PRODUCE_INVENTORY.getName());
                    super.writeInventory("unityCatalog-Schema-" + catalogName + "." + schemaName + "-Resources", null, null, functionList, tableList, volumeList);
                }
            }
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(UCErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.surveyActionServiceName, error.getClass().getName(), "start", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "start");
        }
    }
}

