/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.survey;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogAnnotationType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogMetric;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.ffdc.UCErrorCode;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.CatalogInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.FunctionInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.SchemaInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.TableInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.VolumeInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.OSSUnityCatalogResourceConnector;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.survey.OSSUnityCatalogServerSurveyBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceMeasureAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceProfileAnnotation;

public class OSSUnityCatalogServerSurveyService
extends OSSUnityCatalogServerSurveyBase {
    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        this.setFinalAnalysisStep();
        try {
            this.connector = this.performCheckAssetAnalysisStep(OSSUnityCatalogResourceConnector.class, OpenMetadataType.SOFTWARE_SERVER.typeName);
            OSSUnityCatalogResourceConnector ucConnector = (OSSUnityCatalogResourceConnector)this.connector;
            AnnotationStore annotationStore = this.surveyContext.getAnnotationStore();
            annotationStore.setAnalysisStep(AnalysisStep.MEASURE_RESOURCE.getName());
            HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties> catalogList = new HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties>();
            HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties> schemaList = new HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties>();
            HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties> functionList = new HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties>();
            HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties> tableList = new HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties>();
            HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties> volumeList = new HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties>();
            long catalogCount = 0L;
            long schemaCount = 0L;
            long functionCount = 0L;
            long tableCount = 0L;
            long volumeCount = 0L;
            List<CatalogInfo> catalogInfos = ucConnector.listCatalogs();
            if (catalogInfos != null) {
                for (CatalogInfo catalogInfo : catalogInfos) {
                    if (catalogInfo == null) continue;
                    OSSUnityCatalogServerSurveyBase.ResourceProperties resourceProperties = new OSSUnityCatalogServerSurveyBase.ResourceProperties();
                    resourceProperties.description = catalogInfo.getComment();
                    resourceProperties.creationDate = new Date(catalogInfo.getCreated_at());
                    if (catalogInfo.getUpdated_at() != 0L) {
                        resourceProperties.lastUpdateDate = new Date(catalogInfo.getUpdated_at());
                    }
                    catalogList.put(catalogInfo.getName(), resourceProperties);
                    ++catalogCount;
                    List<SchemaInfo> schemaInfos = ucConnector.listSchemas(catalogInfo.getName());
                    if (schemaInfos == null) continue;
                    for (SchemaInfo schemaInfo : schemaInfos) {
                        List<FunctionInfo> list;
                        List<TableInfo> tableInfos;
                        if (schemaInfo == null) continue;
                        resourceProperties = new OSSUnityCatalogServerSurveyBase.ResourceProperties();
                        resourceProperties.description = schemaInfo.getComment();
                        resourceProperties.creationDate = new Date(schemaInfo.getCreated_at());
                        if (schemaInfo.getUpdated_at() != 0L) {
                            resourceProperties.lastUpdateDate = new Date(schemaInfo.getUpdated_at());
                        }
                        schemaList.put(schemaInfo.getFull_name(), resourceProperties);
                        ++schemaCount;
                        List<VolumeInfo> volumeInfos = ucConnector.listVolumes(catalogInfo.getName(), schemaInfo.getName());
                        if (volumeInfos != null) {
                            for (VolumeInfo volumeInfo : volumeInfos) {
                                if (volumeInfo == null) continue;
                                resourceProperties = new OSSUnityCatalogServerSurveyBase.ResourceProperties();
                                resourceProperties.description = volumeInfo.getComment();
                                resourceProperties.creationDate = new Date(volumeInfo.getCreated_at());
                                if (volumeInfo.getUpdated_at() != 0L) {
                                    resourceProperties.lastUpdateDate = new Date(volumeInfo.getUpdated_at());
                                }
                                volumeList.put(volumeInfo.getFull_name(), resourceProperties);
                                ++volumeCount;
                            }
                        }
                        if ((tableInfos = ucConnector.listTables(catalogInfo.getName(), schemaInfo.getName())) != null) {
                            for (TableInfo tableInfo : tableInfos) {
                                if (tableInfo == null) continue;
                                resourceProperties = new OSSUnityCatalogServerSurveyBase.ResourceProperties();
                                resourceProperties.description = tableInfo.getComment();
                                resourceProperties.creationDate = new Date(tableInfo.getCreated_at());
                                if (tableInfo.getUpdated_at() != 0L) {
                                    resourceProperties.lastUpdateDate = new Date(tableInfo.getUpdated_at());
                                }
                                tableList.put(tableInfo.getCatalog_name() + "." + tableInfo.getSchema_name() + "." + tableInfo.getName(), resourceProperties);
                                ++tableCount;
                            }
                        }
                        if ((list = ucConnector.listFunctions(catalogInfo.getName(), schemaInfo.getName())) == null) continue;
                        for (FunctionInfo functionInfo : list) {
                            if (functionInfo == null) continue;
                            resourceProperties = new OSSUnityCatalogServerSurveyBase.ResourceProperties();
                            resourceProperties.description = functionInfo.getComment();
                            resourceProperties.creationDate = new Date(functionInfo.getCreated_at());
                            if (functionInfo.getUpdated_at() != 0L) {
                                resourceProperties.lastUpdateDate = new Date(functionInfo.getUpdated_at());
                            }
                            functionList.put(functionInfo.getFull_name(), resourceProperties);
                            ++functionCount;
                        }
                    }
                }
            }
            ResourceMeasureAnnotation resourceMeasureAnnotation = new ResourceMeasureAnnotation();
            this.setUpAnnotation((Annotation)resourceMeasureAnnotation, UnityCatalogAnnotationType.SERVER_METRICS);
            HashMap<String, String> resourceProperties = new HashMap<String, String>();
            resourceProperties.put(UnityCatalogMetric.NO_OF_CATALOGS.getPropertyName(), Long.toString(catalogCount));
            resourceProperties.put(UnityCatalogMetric.NO_OF_SCHEMAS.getPropertyName(), Long.toString(schemaCount));
            resourceProperties.put(UnityCatalogMetric.NO_OF_FUNCTIONS.getPropertyName(), Long.toString(functionCount));
            resourceProperties.put(UnityCatalogMetric.NO_OF_TABLES.getPropertyName(), Long.toString(tableCount));
            resourceProperties.put(UnityCatalogMetric.NO_OF_VOLUMES.getPropertyName(), Long.toString(volumeCount));
            HashMap<String, Long> resourceCounts = new HashMap<String, Long>();
            resourceCounts.put(UnityCatalogMetric.NO_OF_CATALOGS.getPropertyName(), catalogCount);
            resourceCounts.put(UnityCatalogMetric.NO_OF_SCHEMAS.getPropertyName(), schemaCount);
            resourceCounts.put(UnityCatalogMetric.NO_OF_FUNCTIONS.getPropertyName(), functionCount);
            resourceCounts.put(UnityCatalogMetric.NO_OF_TABLES.getPropertyName(), tableCount);
            resourceCounts.put(UnityCatalogMetric.NO_OF_VOLUMES.getPropertyName(), volumeCount);
            resourceMeasureAnnotation.setJsonProperties(this.getJSONProperties(resourceCounts));
            resourceMeasureAnnotation.setResourceProperties(resourceProperties);
            annotationStore.addAnnotation((Annotation)resourceMeasureAnnotation, null);
            if (!this.finalAnalysisStep.equals(AnalysisStep.MEASURE_RESOURCE.getName())) {
                annotationStore.setAnalysisStep(AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName());
                ResourceProfileAnnotation resourceProfileAnnotation = this.getNameListAnnotation(UnityCatalogAnnotationType.CATALOG_LIST, catalogList);
                annotationStore.addAnnotation((Annotation)resourceProfileAnnotation, null);
                resourceProfileAnnotation = this.getNameListAnnotation(UnityCatalogAnnotationType.SCHEMA_LIST, schemaList);
                annotationStore.addAnnotation((Annotation)resourceProfileAnnotation, null);
                resourceProfileAnnotation = this.getNameListAnnotation(UnityCatalogAnnotationType.FUNCTION_LIST, functionList);
                annotationStore.addAnnotation((Annotation)resourceProfileAnnotation, null);
                resourceProfileAnnotation = this.getNameListAnnotation(UnityCatalogAnnotationType.TABLE_LIST, tableList);
                annotationStore.addAnnotation((Annotation)resourceProfileAnnotation, null);
                resourceProfileAnnotation = this.getNameListAnnotation(UnityCatalogAnnotationType.VOLUME_LIST, volumeList);
                annotationStore.addAnnotation((Annotation)resourceProfileAnnotation, null);
                if (!this.finalAnalysisStep.equals(AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName())) {
                    annotationStore.setAnalysisStep(AnalysisStep.PRODUCE_INVENTORY.getName());
                    super.writeInventory("unityCatalog-Server-Resources", catalogList, schemaList, functionList, tableList, volumeList);
                }
            }
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(UCErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.surveyActionServiceName, error.getClass().getName(), "start", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "start");
        }
    }
}

