/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.sync;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.ffdc.UCAuditCode;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.ElementBase;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.OSSUnityCatalogResourceConnector;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ExternalIdentifierProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.MetadataCorrelationHeader;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.integration.context.OpenMetadataAccess;
import org.odpi.openmetadata.frameworks.integration.iterator.IntegrationIterator;
import org.odpi.openmetadata.frameworks.integration.iterator.MemberElement;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;

public abstract class OSSUnityCatalogInsideCatalogSyncBase {
    protected final String connectorName;
    protected final CatalogIntegratorContext context;
    protected final String catalogName;
    protected final String catalogTargetName;
    protected final PermittedSynchronization targetPermittedSynchronization;
    protected final OSSUnityCatalogResourceConnector ucConnector;
    protected final String ucServerEndpoint;
    protected final UnityCatalogDeployedImplementationType deployedImplementationType;
    protected final Map<String, String> templates;
    protected final Map<String, Object> configurationProperties;
    protected final AuditLog auditLog;
    protected final OpenMetadataAccess openMetadataAccess;
    protected final List<String> excludeNames;
    protected final List<String> includeNames;
    protected final Map<String, String> ucFullNameToEgeriaGUID;
    protected final PropertyHelper propertyHelper = new PropertyHelper();

    public OSSUnityCatalogInsideCatalogSyncBase(String connectorName, CatalogIntegratorContext context, String catalogTargetName, String catalogName, Map<String, String> ucFullNameToEgeriaGUID, PermittedSynchronization targetPermittedSynchronization, OSSUnityCatalogResourceConnector ucConnector, String ucServerEndpoint, UnityCatalogDeployedImplementationType deployedImplementationType, Map<String, String> templates, Map<String, Object> configurationProperties, List<String> excludeNames, List<String> includeNames, AuditLog auditLog) {
        this.connectorName = connectorName;
        this.context = context;
        this.catalogTargetName = catalogTargetName;
        this.catalogName = catalogName;
        this.ucFullNameToEgeriaGUID = ucFullNameToEgeriaGUID;
        this.targetPermittedSynchronization = targetPermittedSynchronization;
        this.ucConnector = ucConnector;
        this.ucServerEndpoint = ucServerEndpoint;
        this.deployedImplementationType = deployedImplementationType;
        this.templates = templates;
        this.configurationProperties = configurationProperties;
        this.excludeNames = excludeNames;
        this.includeNames = includeNames;
        this.auditLog = auditLog;
        this.openMetadataAccess = context.getIntegrationGovernanceContext().getOpenMetadataAccess();
    }

    Map<String, String> refresh() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        IntegrationIterator iterator = this.refreshEgeria();
        this.refreshUnityCatalog(iterator);
        return this.ucFullNameToEgeriaGUID;
    }

    protected abstract IntegrationIterator refreshEgeria() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException;

    protected abstract void refreshUnityCatalog(IntegrationIterator var1) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException;

    protected Date getDateFromLong(long valueFromUC) {
        if (valueFromUC == 0L) {
            return null;
        }
        return new Date(valueFromUC);
    }

    protected String getQualifiedName(String fullName) {
        return this.deployedImplementationType.getDeployedImplementationType() + ":" + this.ucServerEndpoint + ":" + fullName;
    }

    protected void deleteElementInEgeria(MemberElement memberElement) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.openMetadataAccess.deleteMetadataElementInStore(memberElement.getElement().getElementGUID());
    }

    protected ExternalIdentifierProperties getExternalIdentifierProperties(ElementBase ucElement, String schemaName, String elementName, String id, PermittedSynchronization instanceSynchronizationDirection) {
        ExternalIdentifierProperties externalIdentifierProperties = new ExternalIdentifierProperties();
        externalIdentifierProperties.setExternalIdentifier(id);
        externalIdentifierProperties.setExternalIdentifierSource(UnityCatalogDeployedImplementationType.OSS_UC_CATALOG.getDeployedImplementationType());
        externalIdentifierProperties.setExternalInstanceCreationTime(new Date(ucElement.getCreated_at()));
        externalIdentifierProperties.setExternalInstanceLastUpdateTime(new Date(ucElement.getUpdated_at()));
        HashMap<String, String> mappingProperties = new HashMap<String, String>();
        mappingProperties.put(UnityCatalogPlaceholderProperty.CATALOG_NAME.getName(), this.catalogName);
        mappingProperties.put(UnityCatalogPlaceholderProperty.SCHEMA_NAME.getName(), schemaName);
        mappingProperties.put(elementName, ucElement.getName());
        mappingProperties.put(PlaceholderProperty.SERVER_NETWORK_ADDRESS.name, this.ucServerEndpoint);
        externalIdentifierProperties.setMappingProperties(mappingProperties);
        externalIdentifierProperties.setSynchronizationDirection(instanceSynchronizationDirection);
        return externalIdentifierProperties;
    }

    protected void addPropertyFacet(String parentGUID, String parentQualifiedName, Map<String, String> facetProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, parentQualifiedName + "_propertyFacet");
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.SCHEMA_VERSION.name, "1.0");
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, "vendorProperties");
        elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.PROPERTIES.name, facetProperties);
        this.openMetadataAccess.createMetadataElementInStore(OpenMetadataType.PROPERTY_FACET.typeName, ElementStatus.ACTIVE, null, parentGUID, false, null, null, elementProperties, parentGUID, OpenMetadataType.REFERENCEABLE_FACET.typeName, this.propertyHelper.addStringProperty(null, OpenMetadataProperty.SOURCE.name, "Unity Catalog (UC)"), true);
    }

    protected boolean noMismatchInExternalIdentifier(String thirdPartyExternalIdentifier, MemberElement memberElement) {
        String methodName = "noMismatchInExternalIdentifier";
        if (thirdPartyExternalIdentifier == null || memberElement == null || memberElement.getExternalIdentifiers() == null) {
            return true;
        }
        ArrayList<String> externalIdentifiers = new ArrayList<String>();
        for (MetadataCorrelationHeader correlationHeader : memberElement.getExternalIdentifiers()) {
            if (correlationHeader == null || correlationHeader.getExternalIdentifier() == null) continue;
            externalIdentifiers.add(correlationHeader.getExternalIdentifier());
            if (!thirdPartyExternalIdentifier.equals(correlationHeader.getExternalIdentifier())) continue;
            return true;
        }
        if (externalIdentifiers.isEmpty()) {
            return true;
        }
        this.auditLog.logMessage("noMismatchInExternalIdentifier", UCAuditCode.IDENTITY_MISMATCH.getMessageDefinition(this.connectorName, ((Object)externalIdentifiers).toString(), thirdPartyExternalIdentifier, this.ucServerEndpoint));
        return false;
    }

    protected String getUCCatalogFomMember(MemberElement memberElement) {
        String methodName = "getUCCatalogFomMember";
        ElementProperties elementProperties = memberElement.getElement().getElementProperties();
        String fullName = this.propertyHelper.getStringProperty(this.catalogTargetName, OpenMetadataProperty.RESOURCE_NAME.name, elementProperties, "getUCCatalogFomMember");
        return this.ucConnector.getCatalogNameFromThreePartName(fullName);
    }

    protected String getUCSchemaFomMember(MemberElement memberElement) {
        String methodName = "getUCSchemaFomMember";
        ElementProperties elementProperties = memberElement.getElement().getElementProperties();
        String fullName = this.propertyHelper.getStringProperty(this.catalogTargetName, OpenMetadataProperty.RESOURCE_NAME.name, elementProperties, "getUCSchemaFomMember");
        return this.ucConnector.getSchemaNameFromThreePartName(fullName);
    }

    protected String getUCNameFromMember(MemberElement memberElement) {
        String methodName = "getUCNameFromMember";
        ElementProperties elementProperties = memberElement.getElement().getElementProperties();
        String fullName = this.propertyHelper.getStringProperty(this.catalogTargetName, OpenMetadataProperty.RESOURCE_NAME.name, elementProperties, "getUCNameFromMember");
        return this.ucConnector.getNameFromFullName(fullName);
    }

    protected String getUCCommentFomMember(MemberElement memberElement) {
        String methodName = "getUCCommentFomMember";
        ElementProperties elementProperties = memberElement.getElement().getElementProperties();
        return this.propertyHelper.getStringProperty(this.catalogTargetName, OpenMetadataProperty.DESCRIPTION.name, elementProperties, "getUCCommentFomMember");
    }

    protected Map<String, String> getUCPropertiesFomMember(MemberElement memberElement) {
        String methodName = "getUCPropertiesFomMember";
        ElementProperties elementProperties = memberElement.getElement().getElementProperties();
        return this.propertyHelper.getStringMapFromProperty(this.catalogTargetName, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, elementProperties, "getUCPropertiesFomMember");
    }

    protected String getUCStorageLocationFromMember(MemberElement memberElement) {
        Map vendorProperties = memberElement.getVendorProperties("Unity Catalog (UC)");
        if (vendorProperties != null) {
            return (String)vendorProperties.get(UnityCatalogPlaceholderProperty.STORAGE_LOCATION.getName());
        }
        return null;
    }

    protected String getPathNameFromStorageLocation(String storageLocation) {
        if (storageLocation != null) {
            if (storageLocation.startsWith("file:///")) {
                return storageLocation.substring(7);
            }
            return storageLocation;
        }
        return null;
    }
}

