/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.sync;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.ffdc.UCAuditCode;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.FunctionInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.FunctionProperties;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.SchemaInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.OSSUnityCatalogResourceConnector;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.sync.OSSUnityCatalogInsideCatalogSyncBase;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.integration.iterator.IntegrationIterator;
import org.odpi.openmetadata.frameworks.integration.iterator.MemberAction;
import org.odpi.openmetadata.frameworks.integration.iterator.MemberElement;
import org.odpi.openmetadata.frameworks.integration.iterator.MetadataCollectionIterator;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;

public class OSSUnityCatalogInsideCatalogSyncFunctions
extends OSSUnityCatalogInsideCatalogSyncBase {
    private final String entityTypeName;
    private String templateGUID;

    public OSSUnityCatalogInsideCatalogSyncFunctions(String connectorName, CatalogIntegratorContext context, String catalogTargetName, String catalogName, Map<String, String> ucFullNameToEgeriaGUID, PermittedSynchronization targetPermittedSynchronization, OSSUnityCatalogResourceConnector ucConnector, String ucServerEndpoint, Map<String, String> templates, Map<String, Object> configurationProperties, List<String> excludeNames, List<String> includeNames, AuditLog auditLog) {
        super(connectorName, context, catalogTargetName, catalogName, ucFullNameToEgeriaGUID, targetPermittedSynchronization, ucConnector, ucServerEndpoint, UnityCatalogDeployedImplementationType.OSS_UC_FUNCTION, templates, configurationProperties, excludeNames, includeNames, auditLog);
        this.entityTypeName = OpenMetadataType.DEPLOYED_API.typeName;
        this.templateGUID = null;
        if (templates != null) {
            this.templateGUID = templates.get(this.deployedImplementationType.getDeployedImplementationType());
        }
    }

    @Override
    protected IntegrationIterator refreshEgeria() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "refreshEgeriaFunctions";
        MetadataCollectionIterator functionIterator = new MetadataCollectionIterator(this.context.getMetadataSourceGUID(), this.context.getMetadataSourceQualifiedName(), this.catalogTargetName, this.connectorName, this.entityTypeName, this.openMetadataAccess, this.targetPermittedSynchronization, this.context.getMaxPageSize(), this.auditLog);
        while (functionIterator.moreToReceive()) {
            MemberElement nextElement = functionIterator.getNextMember();
            if (nextElement == null) continue;
            String deployedImplementationType = this.propertyHelper.getStringProperty(this.catalogTargetName, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, nextElement.getElement().getElementProperties(), "refreshEgeriaFunctions");
            if (!UnityCatalogDeployedImplementationType.OSS_UC_FUNCTION.getDeployedImplementationType().equals(deployedImplementationType)) continue;
            FunctionInfo functionInfo = null;
            String functionName = this.propertyHelper.getStringProperty(this.catalogTargetName, OpenMetadataProperty.RESOURCE_NAME.name, nextElement.getElement().getElementProperties(), "refreshEgeriaFunctions");
            if (!this.context.elementShouldBeCatalogued(functionName, this.excludeNames, this.includeNames)) continue;
            try {
                functionInfo = this.ucConnector.getFunction(functionName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            MemberAction memberAction = MemberAction.NO_ACTION;
            if (functionInfo == null) {
                memberAction = nextElement.getMemberAction(null, null);
            } else if (this.noMismatchInExternalIdentifier(functionInfo.getFunction_id(), nextElement)) {
                memberAction = nextElement.getMemberAction(this.getDateFromLong(functionInfo.getCreated_at()), this.getDateFromLong(functionInfo.getUpdated_at()));
            }
            this.takeAction(this.context.getAnchorGUID(nextElement.getElement()), super.getUCSchemaFomMember(nextElement), memberAction, nextElement, functionInfo);
        }
        return functionIterator;
    }

    @Override
    protected void refreshUnityCatalog(IntegrationIterator iterator) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<SchemaInfo> ucSchemaList = this.ucConnector.listSchemas(this.catalogName);
        if (ucSchemaList != null) {
            for (SchemaInfo schemaInfo : ucSchemaList) {
                List<FunctionInfo> ucFunctionList;
                String schemaGUID;
                if (schemaInfo == null || (schemaGUID = (String)this.ucFullNameToEgeriaGUID.get(schemaInfo.getFull_name())) == null || (ucFunctionList = this.ucConnector.listFunctions(this.catalogName, schemaInfo.getName())) == null) continue;
                for (FunctionInfo functionInfo : ucFunctionList) {
                    if (functionInfo == null || this.ucFullNameToEgeriaGUID.get(functionInfo.getFull_name()) != null) continue;
                    String ucFunctionQualifiedName = this.getQualifiedName(functionInfo.getFull_name());
                    MemberElement memberElement = iterator.getMemberByQualifiedName(ucFunctionQualifiedName);
                    MemberAction memberAction = memberElement.getMemberAction(this.getDateFromLong(functionInfo.getCreated_at()), this.getDateFromLong(functionInfo.getUpdated_at()));
                    if (!this.noMismatchInExternalIdentifier(functionInfo.getFunction_id(), memberElement)) continue;
                    this.takeAction(schemaGUID, functionInfo.getSchema_name(), memberAction, memberElement, functionInfo);
                }
            }
        }
    }

    private void takeAction(String schemaGUID, String schemaName, MemberAction memberAction, MemberElement memberElement, FunctionInfo functionInfo) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        switch (memberAction) {
            case CREATE_INSTANCE_IN_OPEN_METADATA: {
                this.createElementInEgeria(schemaGUID, functionInfo);
                break;
            }
            case UPDATE_INSTANCE_IN_OPEN_METADATA: {
                this.updateElementInEgeria(functionInfo, memberElement);
                break;
            }
            case DELETE_INSTANCE_IN_OPEN_METADATA: {
                this.deleteElementInEgeria(memberElement);
                break;
            }
            case CREATE_INSTANCE_IN_THIRD_PARTY: {
                this.createElementInThirdParty(schemaName, memberElement);
                break;
            }
            case UPDATE_INSTANCE_IN_THIRD_PARTY: {
                this.updateElementInThirdParty(functionInfo, memberElement);
                break;
            }
            case DELETE_INSTANCE_IN_THIRD_PARTY: {
                this.deleteElementInThirdParty(functionInfo);
            }
        }
    }

    private void createElementInEgeria(String schemaGUID, FunctionInfo functionInfo) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String ucFunctionGUID;
        String parentLinkTypeName = OpenMetadataType.DATA_CONTENT_FOR_DATA_SET_RELATIONSHIP.typeName;
        boolean parentAtEnd1 = false;
        if (this.templateGUID != null) {
            ucFunctionGUID = this.openMetadataAccess.createMetadataElementFromTemplate(this.deployedImplementationType.getAssociatedTypeName(), schemaGUID, false, null, null, this.templateGUID, null, this.getPlaceholderProperties(functionInfo), schemaGUID, parentLinkTypeName, null, false);
        } else {
            String qualifiedName = super.getQualifiedName(functionInfo.getFull_name());
            ucFunctionGUID = this.openMetadataAccess.createMetadataElementInStore(this.deployedImplementationType.getAssociatedTypeName(), ElementStatus.ACTIVE, null, schemaGUID, false, null, null, this.getElementProperties(qualifiedName, functionInfo), schemaGUID, parentLinkTypeName, null, false);
            HashMap<String, String> facetProperties = new HashMap<String, String>();
            if (functionInfo.getParameter_style() != null) {
                facetProperties.put("parameterStyle", functionInfo.getParameter_style().getValue());
            } else {
                facetProperties.put("parameterStyle", null);
            }
            super.addPropertyFacet(ucFunctionGUID, qualifiedName, facetProperties);
        }
        this.context.addExternalIdentifier(ucFunctionGUID, this.deployedImplementationType.getAssociatedTypeName(), this.getExternalIdentifierProperties(functionInfo, functionInfo.getSchema_name(), UnityCatalogPlaceholderProperty.FUNCTION_NAME.getName(), functionInfo.getFunction_id(), PermittedSynchronization.FROM_THIRD_PARTY));
        this.createSchemaAttributesForUCFunction(ucFunctionGUID, functionInfo);
        this.ucFullNameToEgeriaGUID.put(functionInfo.getFull_name(), ucFunctionGUID);
    }

    private void updateElementInEgeria(FunctionInfo functionInfo, MemberElement memberElement) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String egeriaFunctionGUID = memberElement.getElement().getElementGUID();
        this.openMetadataAccess.updateMetadataElementInStore(egeriaFunctionGUID, false, this.getElementProperties(functionInfo));
        this.updateSchemaAttributesForUCFunction(memberElement, functionInfo);
        this.context.confirmSynchronization(egeriaFunctionGUID, this.entityTypeName, functionInfo.getFunction_id());
    }

    private void createElementInThirdParty(String schemaName, MemberElement memberElement) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        FunctionProperties functionProperties = new FunctionProperties();
        functionProperties.setCatalog_name(this.catalogName);
        functionProperties.setSchema_name(schemaName);
        functionProperties.setName(super.getUCNameFromMember(memberElement));
        FunctionInfo functionInfo = this.ucConnector.createFunction(functionProperties);
        this.context.addExternalIdentifier(memberElement.getElement().getElementGUID(), this.deployedImplementationType.getAssociatedTypeName(), this.getExternalIdentifierProperties(functionInfo, functionInfo.getSchema_name(), UnityCatalogPlaceholderProperty.FUNCTION_NAME.getName(), functionInfo.getFunction_id(), PermittedSynchronization.TO_THIRD_PARTY));
    }

    private void updateElementInThirdParty(FunctionInfo functionInfo, MemberElement memberElement) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "updateElementInThirdParty";
        this.auditLog.logMessage("updateElementInThirdParty", UCAuditCode.FUNCTION_UPDATE.getMessageDefinition(this.connectorName, memberElement.getElement().getElementGUID(), functionInfo.getCatalog_name() + "." + functionInfo.getSchema_name() + "." + functionInfo.getName(), this.ucServerEndpoint));
    }

    private void deleteElementInThirdParty(FunctionInfo functionInfo) throws PropertyServerException {
        String methodName = "deleteElementInThirdParty";
        this.auditLog.logMessage("deleteElementInThirdParty", UCAuditCode.UC_ELEMENT_DELETE.getMessageDefinition(this.connectorName, functionInfo.getCatalog_name() + "." + functionInfo.getSchema_name() + "." + functionInfo.getName(), this.ucServerEndpoint));
        this.ucConnector.deleteFunction(functionInfo.getFull_name());
    }

    private Map<String, String> getPlaceholderProperties(FunctionInfo functionInfo) {
        HashMap<String, String> placeholderProperties = new HashMap<String, String>();
        placeholderProperties.put(PlaceholderProperty.SERVER_NETWORK_ADDRESS.getName(), this.ucServerEndpoint);
        placeholderProperties.put(UnityCatalogPlaceholderProperty.CATALOG_NAME.getName(), functionInfo.getCatalog_name());
        placeholderProperties.put(UnityCatalogPlaceholderProperty.SCHEMA_NAME.getName(), functionInfo.getSchema_name());
        placeholderProperties.put(UnityCatalogPlaceholderProperty.FUNCTION_NAME.getName(), functionInfo.getName());
        placeholderProperties.put(PlaceholderProperty.DESCRIPTION.getName(), functionInfo.getComment());
        placeholderProperties.put(PlaceholderProperty.VERSION_IDENTIFIER.getName(), null);
        return placeholderProperties;
    }

    private ElementProperties getElementProperties(FunctionInfo functionInfo) {
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.NAME.name, functionInfo.getName());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.RESOURCE_NAME.name, functionInfo.getFull_name());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, functionInfo.getComment());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, UnityCatalogDeployedImplementationType.OSS_UC_FUNCTION.getDeployedImplementationType());
        return elementProperties;
    }

    private ElementProperties getElementProperties(String qualifiedName, FunctionInfo info) {
        ElementProperties elementProperties = this.getElementProperties(info);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName);
        return elementProperties;
    }

    private void createSchemaAttributesForUCFunction(String functionGUID, FunctionInfo functionInfo) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createSchemaAttributesForUCFunction";
        ElementProperties properties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, super.getQualifiedName(functionInfo.getFull_name()) + "_rootSchemaType");
        this.openMetadataAccess.createMetadataElementInStore("APISchemaType", ElementStatus.ACTIVE, null, functionGUID, false, null, null, properties, functionGUID, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName, null, true);
        this.auditLog.logMessage("createSchemaAttributesForUCFunction", UCAuditCode.MISSING_METHOD.getMessageDefinition(this.connectorName, "createSchemaAttributesForUCFunction", functionInfo.getCatalog_name() + "." + functionInfo.getSchema_name() + "." + functionInfo.getName(), this.ucServerEndpoint));
    }

    private void updateSchemaAttributesForUCFunction(MemberElement memberElement, FunctionInfo functionInfo) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateSchemaAttributesForUCFunction";
        this.auditLog.logMessage("updateSchemaAttributesForUCFunction", UCAuditCode.MISSING_METHOD.getMessageDefinition(this.connectorName, "updateSchemaAttributesForUCFunction", functionInfo.getCatalog_name() + "." + functionInfo.getSchema_name() + "." + functionInfo.getName(), this.ucServerEndpoint));
    }
}

