/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.sync;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.ffdc.UCAuditCode;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.SchemaInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.OSSUnityCatalogResourceConnector;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.sync.OSSUnityCatalogInsideCatalogSyncBase;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.integration.iterator.IntegrationIterator;
import org.odpi.openmetadata.frameworks.integration.iterator.MemberAction;
import org.odpi.openmetadata.frameworks.integration.iterator.MemberElement;
import org.odpi.openmetadata.frameworks.integration.iterator.MetadataCollectionIterator;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ServerAssetUseType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;

public class OSSUnityCatalogInsideCatalogSyncSchema
extends OSSUnityCatalogInsideCatalogSyncBase {
    private String templateGUID = null;

    public OSSUnityCatalogInsideCatalogSyncSchema(String connectorName, CatalogIntegratorContext context, String catalogTargetName, String catalogName, Map<String, String> ucFullNameToEgeriaGUID, PermittedSynchronization targetPermittedSynchronization, OSSUnityCatalogResourceConnector ucConnector, String ucServerEndpoint, Map<String, String> templates, Map<String, Object> configurationProperties, List<String> excludeNames, List<String> includeNames, AuditLog auditLog) {
        super(connectorName, context, catalogTargetName, catalogName, ucFullNameToEgeriaGUID, targetPermittedSynchronization, ucConnector, ucServerEndpoint, UnityCatalogDeployedImplementationType.OSS_UC_SCHEMA, templates, configurationProperties, excludeNames, includeNames, auditLog);
        if (templates != null) {
            this.templateGUID = templates.get(UnityCatalogDeployedImplementationType.OSS_UC_SCHEMA.getDeployedImplementationType());
        }
    }

    @Override
    protected IntegrationIterator refreshEgeria() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "refreshEgeria";
        MetadataCollectionIterator iterator = new MetadataCollectionIterator(this.context.getMetadataSourceGUID(), this.context.getMetadataSourceQualifiedName(), this.catalogTargetName, this.connectorName, this.deployedImplementationType.getAssociatedTypeName(), this.openMetadataAccess, this.targetPermittedSynchronization, this.context.getMaxPageSize(), this.auditLog);
        while (iterator.moreToReceive()) {
            MemberElement nextElement = iterator.getNextMember();
            if (nextElement == null) continue;
            String deployedImplementationType = this.propertyHelper.getStringProperty(this.catalogTargetName, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, nextElement.getElement().getElementProperties(), "refreshEgeria");
            if (!UnityCatalogDeployedImplementationType.OSS_UC_SCHEMA.getDeployedImplementationType().equals(deployedImplementationType)) continue;
            SchemaInfo schemaInfo = null;
            String schemaName = this.propertyHelper.getStringProperty(this.catalogTargetName, OpenMetadataProperty.RESOURCE_NAME.name, nextElement.getElement().getElementProperties(), "refreshEgeria");
            try {
                schemaInfo = this.ucConnector.getSchema(schemaName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            MemberAction memberAction = MemberAction.NO_ACTION;
            if (schemaInfo == null) {
                memberAction = nextElement.getMemberAction(null, null);
            } else if (this.noMismatchInExternalIdentifier(schemaInfo.getSchema_id(), nextElement)) {
                memberAction = nextElement.getMemberAction(this.getDateFromLong(schemaInfo.getCreated_at()), this.getDateFromLong(schemaInfo.getUpdated_at()));
            }
            this.takeAction(memberAction, nextElement, schemaInfo);
        }
        return iterator;
    }

    @Override
    protected void refreshUnityCatalog(IntegrationIterator iterator) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<SchemaInfo> ucSchemaList = this.ucConnector.listSchemas(this.catalogName);
        if (ucSchemaList != null) {
            for (SchemaInfo schemaInfo : ucSchemaList) {
                if (schemaInfo == null || this.ucFullNameToEgeriaGUID.get(schemaInfo.getFull_name()) != null) continue;
                String ucSchemaQualifiedName = this.getQualifiedName(schemaInfo.getFull_name());
                MemberElement memberElement = iterator.getMemberByQualifiedName(ucSchemaQualifiedName);
                MemberAction memberAction = memberElement.getMemberAction(this.getDateFromLong(schemaInfo.getCreated_at()), this.getDateFromLong(schemaInfo.getUpdated_at()));
                if (!this.noMismatchInExternalIdentifier(schemaInfo.getSchema_id(), memberElement)) continue;
                this.takeAction(memberAction, memberElement, schemaInfo);
            }
        }
    }

    private void takeAction(MemberAction memberAction, MemberElement memberElement, SchemaInfo schemaInfo) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        switch (memberAction) {
            case CREATE_INSTANCE_IN_OPEN_METADATA: {
                this.createElementInEgeria(schemaInfo);
                break;
            }
            case UPDATE_INSTANCE_IN_OPEN_METADATA: {
                this.updateElementInEgeria(schemaInfo, memberElement);
                break;
            }
            case DELETE_INSTANCE_IN_OPEN_METADATA: {
                this.deleteElementInEgeria(memberElement);
                break;
            }
            case CREATE_INSTANCE_IN_THIRD_PARTY: {
                this.createElementInThirdParty(memberElement);
                break;
            }
            case UPDATE_INSTANCE_IN_THIRD_PARTY: {
                this.updateElementInThirdParty(schemaInfo, memberElement);
                break;
            }
            case DELETE_INSTANCE_IN_THIRD_PARTY: {
                this.deleteElementInThirdParty(schemaInfo);
            }
        }
    }

    private void createElementInEgeria(SchemaInfo schemaInfo) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String parentLinkTypeName = OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName;
        boolean parentAtEnd1 = true;
        String ucSchemaGUID = this.templateGUID != null ? this.openMetadataAccess.createMetadataElementFromTemplate(this.deployedImplementationType.getAssociatedTypeName(), this.context.getAssetManagerGUID(), false, null, null, this.templateGUID, null, this.getPlaceholderProperties(schemaInfo), this.context.getAssetManagerGUID(), parentLinkTypeName, this.propertyHelper.addEnumProperty(null, OpenMetadataProperty.USE_TYPE.name, ServerAssetUseType.getOpenTypeName(), ServerAssetUseType.OWNS.getName()), true) : this.openMetadataAccess.createMetadataElementInStore(this.deployedImplementationType.getAssociatedTypeName(), ElementStatus.ACTIVE, null, this.context.getAssetManagerGUID(), false, null, null, this.getElementProperties(super.getQualifiedName(schemaInfo.getFull_name()), schemaInfo), this.context.getAssetManagerGUID(), parentLinkTypeName, this.propertyHelper.addEnumProperty(null, OpenMetadataProperty.USE_TYPE.name, ServerAssetUseType.getOpenTypeName(), ServerAssetUseType.OWNS.getName()), true);
        this.context.addExternalIdentifier(ucSchemaGUID, this.deployedImplementationType.getAssociatedTypeName(), this.getExternalIdentifierProperties(schemaInfo, schemaInfo.getName(), PlaceholderProperty.SCHEMA_NAME.getName(), schemaInfo.getSchema_id(), PermittedSynchronization.FROM_THIRD_PARTY));
        this.ucFullNameToEgeriaGUID.put(schemaInfo.getFull_name(), ucSchemaGUID);
    }

    protected void updateElementInEgeria(SchemaInfo schemaInfo, MemberElement memberElement) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String egeriaSchemaGUID = memberElement.getElement().getElementGUID();
        this.openMetadataAccess.updateMetadataElementInStore(egeriaSchemaGUID, false, this.getElementProperties(schemaInfo));
        this.context.confirmSynchronization(egeriaSchemaGUID, this.deployedImplementationType.getAssociatedTypeName(), schemaInfo.getSchema_id());
    }

    private void createElementInThirdParty(MemberElement memberElement) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        SchemaInfo schemaInfo = this.ucConnector.createSchema(super.getUCNameFromMember(memberElement), this.catalogName, super.getUCCommentFomMember(memberElement), super.getUCPropertiesFomMember(memberElement));
        this.context.addExternalIdentifier(memberElement.getElement().getElementGUID(), this.deployedImplementationType.getAssociatedTypeName(), this.getExternalIdentifierProperties(schemaInfo, schemaInfo.getName(), PlaceholderProperty.SCHEMA_NAME.getName(), schemaInfo.getSchema_id(), PermittedSynchronization.TO_THIRD_PARTY));
    }

    private void updateElementInThirdParty(SchemaInfo schemaInfo, MemberElement memberElement) throws PropertyServerException {
        String methodName = "updateElementInThirdParty";
        this.auditLog.logMessage("updateElementInThirdParty", UCAuditCode.SCHEMA_UPDATE.getMessageDefinition(this.connectorName, memberElement.getElement().getElementGUID(), schemaInfo.getCatalog_name() + "." + schemaInfo.getName(), this.ucServerEndpoint));
    }

    private void deleteElementInThirdParty(SchemaInfo info) throws PropertyServerException {
        this.ucConnector.deleteSchema(info.getFull_name(), false);
    }

    private Map<String, String> getPlaceholderProperties(SchemaInfo info) {
        HashMap<String, String> placeholderProperties = new HashMap<String, String>();
        placeholderProperties.put(PlaceholderProperty.SERVER_NETWORK_ADDRESS.getName(), this.ucServerEndpoint);
        placeholderProperties.put(UnityCatalogPlaceholderProperty.CATALOG_NAME.getName(), this.catalogName);
        placeholderProperties.put(UnityCatalogPlaceholderProperty.SCHEMA_NAME.getName(), info.getName());
        placeholderProperties.put(PlaceholderProperty.VERSION_IDENTIFIER.name, null);
        placeholderProperties.put(PlaceholderProperty.DESCRIPTION.name, info.getComment());
        return placeholderProperties;
    }

    private ElementProperties getElementProperties(SchemaInfo info) {
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.NAME.name, info.getName());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.RESOURCE_NAME.name, info.getFull_name());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.RESOURCE_NAME.name, info.getFull_name());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, info.getComment());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, UnityCatalogDeployedImplementationType.OSS_UC_SCHEMA.getDeployedImplementationType());
        return elementProperties;
    }

    private ElementProperties getElementProperties(String qualifiedName, SchemaInfo info) {
        ElementProperties elementProperties = this.getElementProperties(info);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName);
        return elementProperties;
    }
}

