/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.sync;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogConfigurationProperty;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogTemplateType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.ffdc.UCAuditCode;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.OSSUnityCatalogResourceConnector;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.sync.OSSUnityCatalogServerSyncCatalog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.integration.connectors.CatalogTargetIntegrator;
import org.odpi.openmetadata.frameworks.integration.properties.RequestedCatalogTarget;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorConnector;

public class OSSUnityCatalogServerSyncConnector
extends CatalogIntegratorConnector
implements CatalogTargetIntegrator {
    String defaultFriendshipGUID = null;
    List<String> defaultExcludeCatalogs = new ArrayList<String>();
    List<String> defaultIncludeCatalogs = new ArrayList<String>();

    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        if (this.connectionProperties.getConfigurationProperties() != null) {
            this.defaultFriendshipGUID = this.getFriendshipGUID(this.connectionProperties.getConfigurationProperties());
            this.defaultExcludeCatalogs = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.EXCLUDE_CATALOG_NAMES.getName(), this.connectionProperties.getConfigurationProperties(), null);
            this.defaultIncludeCatalogs = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.INCLUDE_CATALOG_NAMES.getName(), this.connectionProperties.getConfigurationProperties(), null);
        }
        if (this.defaultFriendshipGUID != null) {
            this.auditLog.logMessage("start", UCAuditCode.FRIENDSHIP_GUID.getMessageDefinition(this.connectorName, this.defaultFriendshipGUID));
        }
    }

    private Map<String, String> getTemplates(Map<String, String> catalogTargetTemplates) {
        HashMap<String, String> templateProperties = new HashMap<String, String>();
        for (UnityCatalogTemplateType templateType : UnityCatalogTemplateType.values()) {
            templateProperties.put(templateType.getTemplateName(), templateType.getDefaultTemplateGUID());
        }
        if (catalogTargetTemplates != null) {
            templateProperties.putAll(catalogTargetTemplates);
        }
        return templateProperties;
    }

    public void refresh() throws ConnectorCheckedException {
        String methodName = "refresh";
        if (this.embeddedConnectors != null && !this.embeddedConnectors.isEmpty()) {
            for (Connector embeddedConnector : this.embeddedConnectors) {
                if (!(embeddedConnector instanceof OSSUnityCatalogResourceConnector)) continue;
                OSSUnityCatalogResourceConnector unityCatalogResourceConnector = (OSSUnityCatalogResourceConnector)embeddedConnector;
                try {
                    if (!unityCatalogResourceConnector.isActive()) {
                        unityCatalogResourceConnector.start();
                    }
                    this.catalogCatalogs(null, "endpoint", this.getContext().getPermittedSynchronization(), this.getTemplates(null), this.connectionProperties.getConfigurationProperties(), unityCatalogResourceConnector);
                }
                catch (ConnectorCheckedException exception) {
                    throw exception;
                }
                catch (Exception exception) {
                    this.auditLog.logException("refresh", UCAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, exception.getClass().getName(), "refresh", exception.getMessage()), (Throwable)exception);
                }
            }
        }
        this.refreshCatalogTargets(this);
    }

    public void integrateCatalogTarget(RequestedCatalogTarget requestedCatalogTarget) throws ConnectorCheckedException {
        String methodName = "integrateCatalogTarget";
        if (UnityCatalogDeployedImplementationType.OSS_UNITY_CATALOG_SERVER.getAssociatedTypeName().equals(requestedCatalogTarget.getCatalogTargetElement().getType().getTypeName())) {
            String ucServerGUID = requestedCatalogTarget.getCatalogTargetElement().getGUID();
            try {
                Connector connector = this.getContext().getConnectedAssetContext().getConnectorToAsset(ucServerGUID, this.auditLog);
                OSSUnityCatalogResourceConnector assetConnector = (OSSUnityCatalogResourceConnector)connector;
                assetConnector.setUCInstanceName(this.connectorName + ":" + requestedCatalogTarget.getCatalogTargetName());
                assetConnector.start();
                PermittedSynchronization permittedSynchronization = this.getContext().getPermittedSynchronization();
                if (requestedCatalogTarget.getPermittedSynchronization() != null) {
                    permittedSynchronization = requestedCatalogTarget.getPermittedSynchronization();
                }
                this.catalogCatalogs(ucServerGUID, requestedCatalogTarget.getCatalogTargetName(), permittedSynchronization, this.getTemplates(requestedCatalogTarget.getTemplateProperties()), requestedCatalogTarget.getConfigurationProperties(), assetConnector);
                assetConnector.disconnect();
            }
            catch (Exception exception) {
                this.auditLog.logException("integrateCatalogTarget", UCAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, exception.getClass().getName(), "integrateCatalogTarget", exception.getMessage()), (Throwable)exception);
            }
        } else {
            super.throwWrongTypeOfAsset(requestedCatalogTarget.getCatalogTargetElement().getGUID(), requestedCatalogTarget.getCatalogTargetElement().getType().getTypeName(), UnityCatalogDeployedImplementationType.OSS_UNITY_CATALOG_SERVER.getAssociatedTypeName(), this.connectorName, "integrateCatalogTarget");
        }
    }

    private void catalogCatalogs(String ucServerGUID, String catalogTargetName, PermittedSynchronization permittedSynchronization, Map<String, String> templateProperties, Map<String, Object> configurationProperties, OSSUnityCatalogResourceConnector assetConnector) throws ConnectorCheckedException {
        String methodName = "catalogCatalogs";
        try {
            String ucServerEndpoint = this.getNetworkAddress((Connector)assetConnector);
            String friendshipConnectorGUID = this.getFriendshipGUID(configurationProperties);
            List excludedCatalogs = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.EXCLUDE_CATALOG_NAMES.getName(), configurationProperties, this.defaultExcludeCatalogs);
            List includedCatalogs = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.INCLUDE_CATALOG_NAMES.getName(), configurationProperties, this.defaultIncludeCatalogs);
            OSSUnityCatalogServerSyncCatalog syncCatalog = new OSSUnityCatalogServerSyncCatalog(this.connectorName, this.getContext(), catalogTargetName, ucServerGUID, friendshipConnectorGUID, permittedSynchronization, assetConnector, ucServerEndpoint, templateProperties, configurationProperties, excludedCatalogs, includedCatalogs, this.auditLog);
            syncCatalog.refresh();
        }
        catch (ConnectorCheckedException exception) {
            throw exception;
        }
        catch (Exception exception) {
            this.auditLog.logException("catalogCatalogs", UCAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, exception.getClass().getName(), "catalogCatalogs", exception.getMessage()), (Throwable)exception);
        }
    }

    private String getFriendshipGUID(Map<String, Object> configurationProperties) {
        String friendshipGUID = this.defaultFriendshipGUID;
        if (configurationProperties != null && configurationProperties.get(UnityCatalogConfigurationProperty.FRIENDSHIP_GUID.getName()) != null) {
            friendshipGUID = this.connectionProperties.getConfigurationProperties().get(UnityCatalogConfigurationProperty.FRIENDSHIP_GUID.getName()).toString();
        }
        return friendshipGUID;
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
    }
}

