/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum UCErrorCode implements ExceptionMessageSet
{
    NULL_URL(400, "UNITY-CATALOG-CONNECTOR-400-001", "Connection {0} has been configured without the URL to the Unity Catalog (UC)", "The connector is unable to start because the endpoint of its connection has a null address property.", "Update the connection's endpoint to include the connection string needed to connect to the desired database."),
    MISSING_PROPERTY_NAME(400, "UNITY-CATALOG-CONNECTOR-400-002", "The {0} Unity Catalog Connector has not been supplied with a {1} property value", "The connector is unable to continue because it is not sure which elements to work on.", "Add this property to either the connector's configuration properties (or if it is a governance service, to the request parameters) and retry the request."),
    UNEXPECTED_EXCEPTION(500, "UNITY-CATALOG-CONNECTOR-500-001", "The {0} Unity Catalog (UC) connector received an unexpected exception {1} during method {2}; the error message was: {3}", "The connector is unable to process the current request.", "Use the details from the error message to determine the cause of the error and retry the request once it is resolved."),
    LOGIC_ERROR(500, "UNITY-CATALOG-CONNECTOR-500-002", "The {0} Unity Catalog (UC) governance service has detected an invalid technology type in code that runs after the technology type has been validated.", "The connector ends with an exception.", "The code in the service needs to be fixed to ensure the list of valid unity catalog resources is consistent throughout."),
    CLIENT_SIDE_REST_API_ERROR(503, "UNITY-CATALOG-CONNECTOR-503-001", "A client-side exception of {0} was received from API call {1} to URL {2}.  The error message was {3}", "The connector has issued a call to the open metadata access service REST API in a remote server and has received an exception from the local client libraries.", "Look for errors in the local server's console to understand and correct the source of the error.");

    private final int httpErrorCode;
    private final String errorMessageId;
    private final String errorMessage;
    private final String systemAction;
    private final String userAction;

    private UCErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        ExceptionMessageDefinition messageDefinition = new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "UCErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + "', errorMessage='" + this.errorMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

