/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.survey;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogAnnotationType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogMetric;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.ffdc.UCErrorCode;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.BasicElementProperties;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.BasicProperties;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.CatalogNamespaceProperties;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.ColumnInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.FunctionInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.RegisteredModelInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.SchemaInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.SchemaNamespaceProperties;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.TableInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.TableProperties;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.VolumeInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.OSSUnityCatalogResourceConnector;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.survey.OSSUnityCatalogServerSurveyBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.SurveyDatabaseAnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.SurveyResourceManagerAnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalDataManagerMeasurement;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.RelationalDatabaseMetric;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceMeasureAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceProfileAnnotation;

public class OSSUnityCatalogInsideCatalogSurveyService
extends OSSUnityCatalogServerSurveyBase {
    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        this.setFinalAnalysisStep();
        try {
            List<SchemaInfo> schemaInfos;
            this.connector = this.performCheckAssetAnalysisStep(OSSUnityCatalogResourceConnector.class, OpenMetadataType.SOFTWARE_SERVER.typeName);
            OSSUnityCatalogResourceConnector ucConnector = (OSSUnityCatalogResourceConnector)this.connector;
            String catalogName = this.getCatalogName();
            AnnotationStore annotationStore = this.surveyContext.getAnnotationStore();
            annotationStore.setAnalysisStep(AnalysisStep.MEASURE_RESOURCE.getName());
            HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties> schemaList = new HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties>();
            HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties> functionList = new HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties>();
            HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties> tableList = new HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties>();
            HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties> columnList = new HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties>();
            HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties> volumeList = new HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties>();
            HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties> modelList = new HashMap<String, OSSUnityCatalogServerSurveyBase.ResourceProperties>();
            long schemaCount = 0L;
            long functionCount = 0L;
            long tableCount = 0L;
            long columnCount = 0L;
            long volumeCount = 0L;
            long modelCount = 0L;
            if (catalogName != null && (schemaInfos = ucConnector.listSchemas(catalogName)) != null) {
                for (SchemaInfo schemaInfo : schemaInfos) {
                    List<FunctionInfo> functionInfos;
                    List<RegisteredModelInfo> list;
                    List<TableInfo> tableInfos;
                    if (schemaInfo == null) continue;
                    OSSUnityCatalogServerSurveyBase.ResourceProperties resourceProperties = new OSSUnityCatalogServerSurveyBase.ResourceProperties();
                    resourceProperties.description = schemaInfo.getComment();
                    resourceProperties.creationDate = new Date(schemaInfo.getCreated_at());
                    resourceProperties.createdBy = schemaInfo.getCreated_by();
                    if (schemaInfo.getUpdated_at() != 0L) {
                        resourceProperties.lastUpdateDate = new Date(schemaInfo.getUpdated_at());
                    }
                    resourceProperties.lastUpdatedBy = schemaInfo.getUpdated_by();
                    resourceProperties.owner = schemaInfo.getOwner();
                    schemaList.put(schemaInfo.getFull_name(), resourceProperties);
                    ++schemaCount;
                    List<VolumeInfo> volumeInfos = ucConnector.listVolumes(catalogName, schemaInfo.getName());
                    if (volumeInfos != null) {
                        for (VolumeInfo volumeInfo : volumeInfos) {
                            if (volumeInfo == null) continue;
                            resourceProperties = new OSSUnityCatalogServerSurveyBase.ResourceProperties();
                            resourceProperties.description = volumeInfo.getComment();
                            resourceProperties.creationDate = new Date(volumeInfo.getCreated_at());
                            resourceProperties.createdBy = volumeInfo.getCreated_by();
                            if (volumeInfo.getUpdated_at() != 0L) {
                                resourceProperties.lastUpdateDate = new Date(volumeInfo.getUpdated_at());
                            }
                            resourceProperties.lastUpdatedBy = volumeInfo.getUpdated_by();
                            resourceProperties.owner = volumeInfo.getOwner();
                            volumeList.put(volumeInfo.getFull_name(), resourceProperties);
                            ++volumeCount;
                        }
                    }
                    if ((tableInfos = ucConnector.listTables(catalogName, schemaInfo.getName())) != null) {
                        for (Object tableInfo : tableInfos) {
                            if (tableInfo == null) continue;
                            resourceProperties = new OSSUnityCatalogServerSurveyBase.ResourceProperties();
                            resourceProperties.description = ((BasicProperties)tableInfo).getComment();
                            resourceProperties.creationDate = new Date(((TableInfo)tableInfo).getCreated_at());
                            resourceProperties.createdBy = ((TableInfo)tableInfo).getCreated_by();
                            if (((TableInfo)tableInfo).getUpdated_at() != 0L) {
                                resourceProperties.lastUpdateDate = new Date(((TableInfo)tableInfo).getUpdated_at());
                            }
                            resourceProperties.lastUpdatedBy = ((TableInfo)tableInfo).getUpdated_by();
                            resourceProperties.owner = ((BasicElementProperties)tableInfo).getOwner();
                            tableList.put(((CatalogNamespaceProperties)tableInfo).getCatalog_name() + "." + ((SchemaNamespaceProperties)tableInfo).getSchema_name() + "." + ((BasicProperties)tableInfo).getName(), resourceProperties);
                            ++tableCount;
                            if (((TableProperties)tableInfo).getColumns() == null) continue;
                            for (ColumnInfo columnInfo : ((TableProperties)tableInfo).getColumns()) {
                                OSSUnityCatalogServerSurveyBase.ResourceProperties columnResourceProperties = new OSSUnityCatalogServerSurveyBase.ResourceProperties(resourceProperties);
                                columnResourceProperties.description = columnInfo.getComment();
                                columnList.put(((CatalogNamespaceProperties)tableInfo).getCatalog_name() + "." + ((SchemaNamespaceProperties)tableInfo).getSchema_name() + "." + ((BasicProperties)tableInfo).getName() + "." + columnInfo.getName(), columnResourceProperties);
                                ++columnCount;
                            }
                        }
                    }
                    if ((list = ucConnector.listRegisteredModels(catalogName, schemaInfo.getName())) != null) {
                        Object tableInfo;
                        tableInfo = list.iterator();
                        while (tableInfo.hasNext()) {
                            RegisteredModelInfo registeredModelInfo = (RegisteredModelInfo)tableInfo.next();
                            if (registeredModelInfo == null) continue;
                            resourceProperties = new OSSUnityCatalogServerSurveyBase.ResourceProperties();
                            resourceProperties.description = registeredModelInfo.getComment();
                            resourceProperties.creationDate = new Date(registeredModelInfo.getCreated_at());
                            resourceProperties.createdBy = registeredModelInfo.getCreated_by();
                            if (registeredModelInfo.getUpdated_at() != 0L) {
                                resourceProperties.lastUpdateDate = new Date(registeredModelInfo.getUpdated_at());
                            }
                            resourceProperties.lastUpdatedBy = registeredModelInfo.getUpdated_by();
                            resourceProperties.owner = registeredModelInfo.getOwner();
                            modelList.put(registeredModelInfo.getFull_name(), resourceProperties);
                            ++modelCount;
                        }
                    }
                    if ((functionInfos = ucConnector.listFunctions(catalogName, schemaInfo.getName())) == null) continue;
                    for (FunctionInfo functionInfo : functionInfos) {
                        if (functionInfo == null) continue;
                        resourceProperties = new OSSUnityCatalogServerSurveyBase.ResourceProperties();
                        resourceProperties.description = functionInfo.getComment();
                        resourceProperties.creationDate = new Date(functionInfo.getCreated_at());
                        resourceProperties.createdBy = functionInfo.getCreated_by();
                        if (functionInfo.getUpdated_at() != 0L) {
                            resourceProperties.lastUpdateDate = new Date(functionInfo.getUpdated_at());
                        }
                        resourceProperties.lastUpdatedBy = functionInfo.getUpdated_by();
                        resourceProperties.owner = functionInfo.getOwner();
                        functionList.put(functionInfo.getFull_name(), resourceProperties);
                        ++functionCount;
                    }
                }
            }
            ResourceMeasureAnnotation resourceMeasureAnnotation = new ResourceMeasureAnnotation();
            this.setUpAnnotation((Annotation)resourceMeasureAnnotation, UnityCatalogAnnotationType.CATALOG_METRICS);
            RelationalDataManagerMeasurement relationalDataManagerMeasurement = new RelationalDataManagerMeasurement();
            relationalDataManagerMeasurement.setResourceName(catalogName);
            relationalDataManagerMeasurement.setSchemaCount(tableCount);
            relationalDataManagerMeasurement.setTableCount(tableCount);
            relationalDataManagerMeasurement.setColumnCount(columnCount);
            resourceMeasureAnnotation.setJsonProperties(this.getJSONProperties(relationalDataManagerMeasurement));
            HashMap<String, String> resourceProperties = new HashMap<String, String>();
            resourceProperties.put(RelationalDatabaseMetric.SCHEMA_COUNT.getPropertyName(), Long.toString(schemaCount));
            resourceProperties.put(UnityCatalogMetric.NO_OF_FUNCTIONS.getPropertyName(), Long.toString(functionCount));
            resourceProperties.put(RelationalDatabaseMetric.TABLE_COUNT.getPropertyName(), Long.toString(tableCount));
            resourceProperties.put(RelationalDatabaseMetric.COLUMN_COUNT.getPropertyName(), Long.toString(columnCount));
            resourceProperties.put(UnityCatalogMetric.NO_OF_VOLUMES.getPropertyName(), Long.toString(volumeCount));
            resourceProperties.put(UnityCatalogMetric.NO_OF_MODELS.getPropertyName(), Long.toString(modelCount));
            HashMap<String, Long> resourceCounts = new HashMap<String, Long>();
            resourceCounts.put(RelationalDatabaseMetric.SCHEMA_COUNT.getPropertyName(), schemaCount);
            resourceCounts.put(UnityCatalogMetric.NO_OF_FUNCTIONS.getPropertyName(), functionCount);
            resourceCounts.put(RelationalDatabaseMetric.TABLE_COUNT.getPropertyName(), tableCount);
            resourceCounts.put(RelationalDatabaseMetric.COLUMN_COUNT.getPropertyName(), columnCount);
            resourceCounts.put(UnityCatalogMetric.NO_OF_VOLUMES.getPropertyName(), volumeCount);
            resourceCounts.put(UnityCatalogMetric.NO_OF_MODELS.getPropertyName(), modelCount);
            resourceMeasureAnnotation.setJsonProperties(this.getJSONProperties(resourceCounts));
            resourceMeasureAnnotation.setResourceProperties(resourceProperties);
            annotationStore.addAnnotation((Annotation)resourceMeasureAnnotation, null);
            if (!this.finalAnalysisStep.equals(AnalysisStep.MEASURE_RESOURCE.getName())) {
                annotationStore.setAnalysisStep(AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName());
                ResourceProfileAnnotation resourceProfileAnnotation = this.getNameListAnnotation((AnnotationType)SurveyDatabaseAnnotationType.SCHEMA_LIST, schemaList);
                annotationStore.addAnnotation((Annotation)resourceProfileAnnotation, null);
                resourceProfileAnnotation = this.getNameListAnnotation((AnnotationType)SurveyResourceManagerAnnotationType.FUNCTION_LIST, functionList);
                annotationStore.addAnnotation((Annotation)resourceProfileAnnotation, null);
                resourceProfileAnnotation = this.getNameListAnnotation((AnnotationType)SurveyDatabaseAnnotationType.TABLE_LIST, tableList);
                annotationStore.addAnnotation((Annotation)resourceProfileAnnotation, null);
                resourceProfileAnnotation = this.getNameListAnnotation((AnnotationType)SurveyDatabaseAnnotationType.COLUMN_LIST, columnList);
                annotationStore.addAnnotation((Annotation)resourceProfileAnnotation, null);
                resourceProfileAnnotation = this.getNameListAnnotation((AnnotationType)SurveyResourceManagerAnnotationType.VOLUME_LIST, volumeList);
                annotationStore.addAnnotation((Annotation)resourceProfileAnnotation, null);
                resourceProfileAnnotation = this.getNameListAnnotation((AnnotationType)SurveyResourceManagerAnnotationType.MODEL_LIST, modelList);
                annotationStore.addAnnotation((Annotation)resourceProfileAnnotation, null);
                if (!this.finalAnalysisStep.equals(AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName())) {
                    annotationStore.setAnalysisStep(AnalysisStep.PRODUCE_INVENTORY.getName());
                    super.writeInventory("unityCatalog-Catalog-" + catalogName + "-Resources", null, schemaList, functionList, tableList, volumeList);
                }
            }
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(UCErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.surveyActionServiceName, error.getClass().getName(), "start", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "start");
        }
    }
}

