/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.sync;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.api.AssetManagerEventListener;
import org.odpi.openmetadata.accessservices.assetmanager.events.AssetManagerOutTopicEvent;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogConfigurationProperty;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.ffdc.UCAuditCode;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.ffdc.UCErrorCode;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.OSSUnityCatalogResourceConnector;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.sync.OSSUnityCatalogInsideCatalogSyncFunctions;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.sync.OSSUnityCatalogInsideCatalogSyncRegisteredModels;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.sync.OSSUnityCatalogInsideCatalogSyncSchema;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.sync.OSSUnityCatalogInsideCatalogSyncTables;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.sync.OSSUnityCatalogInsideCatalogSyncVolumes;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.integration.connectors.CatalogTargetIntegrator;
import org.odpi.openmetadata.frameworks.integration.ffdc.OIFAuditCode;
import org.odpi.openmetadata.frameworks.integration.properties.RequestedCatalogTarget;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementOriginCategory;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorConnector;

public class OSSUnityCatalogInsideCatalogSyncConnector
extends CatalogIntegratorConnector
implements CatalogTargetIntegrator,
AssetManagerEventListener {
    private List<String> defaultExcludeSchemaNames = null;
    private List<String> defaultIncludeSchemaNames = null;
    private List<String> defaultExcludeTableNames = null;
    private List<String> defaultIncludeTableNames = null;
    private List<String> defaultExcludeFunctionNames = null;
    private List<String> defaultIncludeFunctionNames = null;
    private List<String> defaultExcludeVolumeNames = null;
    private List<String> defaultIncludeVolumeNames = null;
    private List<String> defaultExcludeModelNames = null;
    private List<String> defaultIncludeModelNames = null;
    private Date lastRefreshCompleteTime = null;

    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        if (this.connectionProperties.getEndpoint() != null) {
            this.auditLog.logMessage("start", UCAuditCode.IGNORING_ENDPOINT.getMessageDefinition(this.connectorName));
        }
        if (this.embeddedConnectors != null && !this.embeddedConnectors.isEmpty()) {
            for (Connector embeddedConnector : this.embeddedConnectors) {
                if (!(embeddedConnector instanceof OSSUnityCatalogResourceConnector)) continue;
                this.auditLog.logMessage("start", UCAuditCode.IGNORING_ENDPOINT.getMessageDefinition(this.connectorName));
            }
        }
        this.defaultExcludeSchemaNames = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.EXCLUDE_SCHEMA_NAMES.getName(), this.connectionProperties.getConfigurationProperties());
        this.defaultIncludeSchemaNames = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.INCLUDE_SCHEMA_NAMES.getName(), this.connectionProperties.getConfigurationProperties());
        this.defaultExcludeTableNames = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.EXCLUDE_TABLE_NAMES.getName(), this.connectionProperties.getConfigurationProperties());
        this.defaultIncludeTableNames = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.INCLUDE_TABLE_NAMES.getName(), this.connectionProperties.getConfigurationProperties());
        this.defaultExcludeFunctionNames = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.EXCLUDE_FUNCTION_NAMES.getName(), this.connectionProperties.getConfigurationProperties());
        this.defaultIncludeFunctionNames = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.INCLUDE_FUNCTION_NAMES.getName(), this.connectionProperties.getConfigurationProperties());
        this.defaultExcludeVolumeNames = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.EXCLUDE_VOLUME_NAMES.getName(), this.connectionProperties.getConfigurationProperties());
        this.defaultIncludeVolumeNames = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.INCLUDE_VOLUME_NAMES.getName(), this.connectionProperties.getConfigurationProperties());
        this.defaultExcludeModelNames = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.EXCLUDE_MODEL_NAMES.getName(), this.connectionProperties.getConfigurationProperties());
        this.defaultIncludeModelNames = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.INCLUDE_MODEL_NAMES.getName(), this.connectionProperties.getConfigurationProperties());
    }

    public void refresh() throws ConnectorCheckedException {
        String methodName = "refresh";
        this.refreshCatalogTargets(this);
        if (!super.getContext().isListenerRegistered() && this.lastRefreshCompleteTime != null && super.getContext().getPermittedSynchronization() == PermittedSynchronization.BOTH_DIRECTIONS || super.getContext().getPermittedSynchronization() == PermittedSynchronization.TO_THIRD_PARTY) {
            try {
                super.getContext().registerListener((AssetManagerEventListener)this);
            }
            catch (Exception error) {
                if (this.auditLog != null) {
                    this.auditLog.logException("refresh", UCAuditCode.UNABLE_TO_REGISTER_LISTENER.getMessageDefinition(this.connectorName, error.getClass().getName(), error.getMessage()), (Throwable)error);
                }
                throw new ConnectorCheckedException(UCErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "refresh", error.getMessage()), ((Object)((Object)this)).getClass().getName(), "refresh", (Throwable)error);
            }
        }
        this.lastRefreshCompleteTime = new Date();
    }

    public void processEvent(AssetManagerOutTopicEvent event) {
        String methodName = "processEvent";
        if (!this.integrationContext.isRefreshInProgress()) {
            ElementHeader elementHeader = event.getElementHeader();
            Date lastUpdateTime = elementHeader.getVersions().getUpdateTime();
            String lastUpdateUser = elementHeader.getVersions().getUpdatedBy();
            if (lastUpdateTime == null) {
                lastUpdateTime = elementHeader.getVersions().getCreateTime();
                lastUpdateUser = elementHeader.getVersions().getCreatedBy();
            }
            try {
                if (elementHeader.getOrigin().getOriginCategory() == ElementOriginCategory.EXTERNAL_SOURCE && lastUpdateTime.after(this.lastRefreshCompleteTime) && !lastUpdateUser.equals(super.getContext().getMyUserId()) && elementHeader.getOrigin().getHomeMetadataCollectionName() != null && (this.propertyHelper.isTypeOf((ElementControlHeader)elementHeader, OpenMetadataType.SOFTWARE_CAPABILITY.typeName) || this.propertyHelper.isTypeOf((ElementControlHeader)elementHeader, OpenMetadataType.ASSET.typeName) || this.propertyHelper.isTypeOf((ElementControlHeader)elementHeader, OpenMetadataType.SCHEMA_ELEMENT.typeName))) {
                    int startFrom = 0;
                    List catalogTargetList = this.integrationContext.getCatalogTargets(startFrom, this.integrationContext.getMaxPageSize());
                    while (catalogTargetList != null) {
                        for (CatalogTarget catalogTarget : catalogTargetList) {
                            if (catalogTarget == null || !super.isActive() || !elementHeader.getOrigin().getHomeMetadataCollectionName().equals(catalogTarget.getMetadataSourceQualifiedName())) continue;
                            boolean savedExternalSourceIsHome = this.integrationContext.getExternalSourceIsHome();
                            String savedMetadataSourceQualifiedName = this.integrationContext.getMetadataSourceQualifiedName();
                            this.integrationContext.setMetadataSourceQualifiedName(catalogTarget.getMetadataSourceQualifiedName());
                            this.integrationContext.setExternalSourceIsHome(true);
                            RequestedCatalogTarget requestedCatalogTarget = new RequestedCatalogTarget(catalogTarget, null);
                            requestedCatalogTarget.setConfigurationProperties(super.combineConfigurationProperties(catalogTarget.getConfigurationProperties()));
                            if (this.propertyHelper.isTypeOf((ElementControlHeader)catalogTarget.getCatalogTargetElement(), OpenMetadataType.ASSET.typeName)) {
                                requestedCatalogTarget.setCatalogTargetConnector(this.integrationContext.getConnectedAssetContext().getConnectorToAsset(catalogTarget.getCatalogTargetElement().getGUID(), this.auditLog));
                            }
                            this.auditLog.logMessage("processEvent", OIFAuditCode.REFRESHING_CATALOG_TARGET.getMessageDefinition(new String[]{this.connectorName, requestedCatalogTarget.getCatalogTargetName()}));
                            this.integrateCatalogTarget(requestedCatalogTarget);
                            this.integrationContext.setExternalSourceIsHome(savedExternalSourceIsHome);
                            this.integrationContext.setMetadataSourceQualifiedName(savedMetadataSourceQualifiedName);
                        }
                        catalogTargetList = this.integrationContext.getCatalogTargets(startFrom += this.integrationContext.getMaxPageSize(), this.integrationContext.getMaxPageSize());
                    }
                }
            }
            catch (Exception exception) {
                this.auditLog.logException("processEvent", UCAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, exception.getClass().getName(), "processEvent", exception.getMessage()), (Throwable)exception);
            }
        }
    }

    public void integrateCatalogTarget(RequestedCatalogTarget requestedCatalogTarget) throws ConnectorCheckedException {
        String methodName = "integrateCatalogTarget";
        if (UnityCatalogDeployedImplementationType.OSS_UNITY_CATALOG_SERVER.getAssociatedTypeName().equals(requestedCatalogTarget.getCatalogTargetElement().getType().getTypeName())) {
            if (requestedCatalogTarget.getConfigurationProperties() != null && requestedCatalogTarget.getConfigurationProperties().get(UnityCatalogPlaceholderProperty.CATALOG_NAME.getName()) != null) {
                try {
                    String catalogName = requestedCatalogTarget.getConfigurationProperties().get(UnityCatalogPlaceholderProperty.CATALOG_NAME.getName()).toString();
                    String catalogQualifiedName = requestedCatalogTarget.getMetadataSourceQualifiedName();
                    String catalogGUID = requestedCatalogTarget.getConfigurationProperties().get(OpenMetadataProperty.GUID.name).toString();
                    Connector connector = this.getContext().getConnectedAssetContext().getConnectorToAsset(requestedCatalogTarget.getCatalogTargetElement().getGUID(), this.auditLog);
                    OSSUnityCatalogResourceConnector assetConnector = (OSSUnityCatalogResourceConnector)connector;
                    assetConnector.setUCInstanceName(this.connectorName + ":" + requestedCatalogTarget.getCatalogTargetName());
                    assetConnector.start();
                    String ucServerEndpoint = this.getNetworkAddress((Connector)assetConnector);
                    PermittedSynchronization permittedSynchronization = this.getContext().getPermittedSynchronization();
                    if (requestedCatalogTarget.getPermittedSynchronization() != null) {
                        permittedSynchronization = requestedCatalogTarget.getPermittedSynchronization();
                    }
                    HashMap<String, String> ucFullNameToEgeriaGUID = new HashMap<String, String>();
                    ucFullNameToEgeriaGUID.put(catalogName, requestedCatalogTarget.getCatalogTargetElement().getGUID());
                    this.refreshCatalog(catalogName, catalogGUID, catalogQualifiedName, ucFullNameToEgeriaGUID, permittedSynchronization, assetConnector, ucServerEndpoint, requestedCatalogTarget.getTemplateProperties(), requestedCatalogTarget.getConfigurationProperties());
                    assetConnector.disconnect();
                }
                catch (Exception exception) {
                    this.auditLog.logException("integrateCatalogTarget", UCAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, exception.getClass().getName(), "integrateCatalogTarget", exception.getMessage()), (Throwable)exception);
                }
            } else {
                super.throwMissingConfigurationProperty(this.connectorName, requestedCatalogTarget.getCatalogTargetName(), UnityCatalogPlaceholderProperty.CATALOG_NAME.getName(), "integrateCatalogTarget");
            }
        } else {
            super.throwWrongTypeOfAsset(requestedCatalogTarget.getCatalogTargetElement().getGUID(), requestedCatalogTarget.getCatalogTargetElement().getType().getTypeName(), UnityCatalogDeployedImplementationType.OSS_UNITY_CATALOG_SERVER.getAssociatedTypeName(), this.connectorName, "integrateCatalogTarget");
        }
    }

    private void refreshCatalog(String catalogName, String catalogGUID, String catalogQualifiedName, Map<String, String> ucFullNameToEgeriaGUID, PermittedSynchronization targetPermittedSynchronization, OSSUnityCatalogResourceConnector ucConnector, String ucServerEndpoint, Map<String, String> templates, Map<String, Object> configurationProperties) {
        String methodName = "refreshCatalog(" + catalogQualifiedName + ")";
        List excludeSchemaNames = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.EXCLUDE_SCHEMA_NAMES.getName(), configurationProperties, this.defaultExcludeSchemaNames);
        List includeSchemaNames = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.INCLUDE_SCHEMA_NAMES.getName(), configurationProperties, this.defaultIncludeSchemaNames);
        List excludeTableNames = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.EXCLUDE_TABLE_NAMES.getName(), configurationProperties, this.defaultExcludeTableNames);
        List includeTableNames = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.INCLUDE_TABLE_NAMES.getName(), configurationProperties, this.defaultIncludeTableNames);
        List excludeFunctionNames = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.EXCLUDE_FUNCTION_NAMES.getName(), configurationProperties, this.defaultExcludeFunctionNames);
        List includeFunctionNames = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.INCLUDE_FUNCTION_NAMES.getName(), configurationProperties, this.defaultIncludeFunctionNames);
        List excludeVolumeNames = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.EXCLUDE_VOLUME_NAMES.getName(), configurationProperties, this.defaultExcludeVolumeNames);
        List includeVolumeNames = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.INCLUDE_VOLUME_NAMES.getName(), configurationProperties, this.defaultIncludeVolumeNames);
        List excludeModelNames = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.EXCLUDE_MODEL_NAMES.getName(), configurationProperties, this.defaultExcludeModelNames);
        List includeModelNames = super.getArrayConfigurationProperty(UnityCatalogConfigurationProperty.INCLUDE_MODEL_NAMES.getName(), configurationProperties, this.defaultIncludeModelNames);
        try {
            OSSUnityCatalogInsideCatalogSyncSchema syncSchema = new OSSUnityCatalogInsideCatalogSyncSchema(this.connectorName, this.getContext(), catalogName, catalogGUID, catalogQualifiedName, ucFullNameToEgeriaGUID, targetPermittedSynchronization, ucConnector, ucServerEndpoint, templates, configurationProperties, excludeSchemaNames, includeSchemaNames, this.auditLog);
            ucFullNameToEgeriaGUID.putAll(syncSchema.refresh());
            OSSUnityCatalogInsideCatalogSyncVolumes syncVolumes = new OSSUnityCatalogInsideCatalogSyncVolumes(this.connectorName, this.getContext(), catalogName, catalogGUID, catalogQualifiedName, ucFullNameToEgeriaGUID, targetPermittedSynchronization, ucConnector, ucServerEndpoint, templates, configurationProperties, excludeVolumeNames, includeVolumeNames, this.auditLog);
            ucFullNameToEgeriaGUID.putAll(syncVolumes.refresh());
            OSSUnityCatalogInsideCatalogSyncTables syncTables = new OSSUnityCatalogInsideCatalogSyncTables(this.connectorName, this.getContext(), catalogName, catalogGUID, catalogQualifiedName, ucFullNameToEgeriaGUID, targetPermittedSynchronization, ucConnector, ucServerEndpoint, templates, configurationProperties, excludeTableNames, includeTableNames, this.auditLog);
            ucFullNameToEgeriaGUID.putAll(syncTables.refresh());
            OSSUnityCatalogInsideCatalogSyncFunctions syncFunctions = new OSSUnityCatalogInsideCatalogSyncFunctions(this.connectorName, this.getContext(), catalogName, catalogGUID, catalogQualifiedName, ucFullNameToEgeriaGUID, targetPermittedSynchronization, ucConnector, ucServerEndpoint, templates, configurationProperties, excludeFunctionNames, includeFunctionNames, this.auditLog);
            ucFullNameToEgeriaGUID.putAll(syncFunctions.refresh());
            OSSUnityCatalogInsideCatalogSyncRegisteredModels syncRegisteredModels = new OSSUnityCatalogInsideCatalogSyncRegisteredModels(this.connectorName, this.getContext(), catalogName, catalogGUID, catalogQualifiedName, ucFullNameToEgeriaGUID, targetPermittedSynchronization, ucConnector, ucServerEndpoint, templates, configurationProperties, excludeModelNames, includeModelNames, this.auditLog);
            ucFullNameToEgeriaGUID.putAll(syncRegisteredModels.refresh());
        }
        catch (Exception exception) {
            this.auditLog.logMessage(methodName, UCAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, exception.getClass().getName(), methodName, exception.getMessage()));
        }
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
    }
}

