/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.sync;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.ffdc.UCAuditCode;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.properties.CatalogInfo;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.resource.OSSUnityCatalogResourceConnector;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.sync.OSSUnityCatalogInsideCatalogSyncBase;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTargetProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.integration.iterator.IntegrationIterator;
import org.odpi.openmetadata.frameworks.integration.iterator.MemberAction;
import org.odpi.openmetadata.frameworks.integration.iterator.MemberElement;
import org.odpi.openmetadata.frameworks.integration.iterator.RelatedElementsIterator;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OperationalStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.integrationservices.catalog.connector.CatalogIntegratorContext;

public class OSSUnityCatalogServerSyncCatalog
extends OSSUnityCatalogInsideCatalogSyncBase {
    private final String friendshipConnectorGUID;
    private String templateGUID = null;
    private final String ucServerGUID;
    private final String parentLinkTypeName;

    public OSSUnityCatalogServerSyncCatalog(String connectorName, CatalogIntegratorContext context, String catalogTargetName, String ucServerGUID, String friendshipConnectorGUID, PermittedSynchronization targetPermittedSynchronization, OSSUnityCatalogResourceConnector ucConnector, String ucServerEndpoint, Map<String, String> templates, Map<String, Object> configurationProperties, List<String> excludeCatalogs, List<String> includeCatalogs, AuditLog auditLog) {
        super(connectorName, context, catalogTargetName, null, null, new HashMap<String, String>(), targetPermittedSynchronization, ucConnector, ucServerEndpoint, UnityCatalogDeployedImplementationType.OSS_UC_CATALOG, templates, configurationProperties, excludeCatalogs, includeCatalogs, auditLog);
        this.parentLinkTypeName = OpenMetadataType.SUPPORTED_CAPABILITY_RELATIONSHIP.typeName;
        this.ucServerGUID = ucServerGUID;
        this.friendshipConnectorGUID = friendshipConnectorGUID;
        if (templates != null) {
            this.templateGUID = templates.get(UnityCatalogDeployedImplementationType.OSS_UC_CATALOG.getDeployedImplementationType());
        }
    }

    @Override
    protected IntegrationIterator refreshEgeria() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "refreshEgeria";
        int parentAtEnd = 1;
        RelatedElementsIterator iterator = new RelatedElementsIterator(null, null, null, null, this.catalogName, this.connectorName, this.ucServerGUID, this.parentLinkTypeName, parentAtEnd, this.deployedImplementationType.getAssociatedTypeName(), this.openMetadataAccess, this.targetPermittedSynchronization, this.context.getMaxPageSize(), this.auditLog);
        while (iterator.moreToReceive()) {
            MemberElement nextElement = iterator.getNextMember();
            if (nextElement == null || nextElement.getElement() == null || !this.propertyHelper.isTypeOf((ElementControlHeader)nextElement.getElement(), OpenMetadataType.DATA_ACCESS_MANAGER.typeName)) continue;
            String deployedImplementationType = this.propertyHelper.getStringProperty(this.catalogName, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, nextElement.getElement().getElementProperties(), "refreshEgeria");
            if (!UnityCatalogDeployedImplementationType.OSS_UC_CATALOG.getDeployedImplementationType().equals(deployedImplementationType)) continue;
            CatalogInfo info = null;
            String name = this.propertyHelper.getStringProperty(this.catalogName, OpenMetadataProperty.NAME.name, nextElement.getElement().getElementProperties(), "refreshEgeria");
            if (this.context.elementShouldBeCatalogued(name, this.excludeNames, this.includeNames)) {
                try {
                    info = this.ucConnector.getCatalog(name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MemberAction memberAction = MemberAction.NO_ACTION;
                if (info == null) {
                    memberAction = nextElement.getMemberAction(null, null);
                } else if (this.noMismatchInExternalIdentifier(info.getId(), nextElement)) {
                    memberAction = nextElement.getMemberAction(this.getDateFromLong(info.getCreated_at()), this.getDateFromLong(info.getUpdated_at()));
                }
                this.takeAction(memberAction, nextElement, info);
                continue;
            }
            if (this.friendshipConnectorGUID == null) continue;
            int startingFrom = 0;
            List catalogTargets = this.context.getCatalogTargets(this.friendshipConnectorGUID, startingFrom, this.context.getMaxPageSize());
            while (catalogTargets != null) {
                for (CatalogTarget catalogTarget : catalogTargets) {
                    if (catalogTarget == null || !name.equals(catalogTarget.getCatalogTargetName())) continue;
                    this.context.removeCatalogTarget(catalogTarget.getRelationshipGUID());
                }
                catalogTargets = this.context.getCatalogTargets(this.friendshipConnectorGUID, startingFrom += this.context.getMaxPageSize(), this.context.getMaxPageSize());
            }
        }
        return iterator;
    }

    @Override
    protected void refreshUnityCatalog(IntegrationIterator iterator) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<CatalogInfo> ucCatalogList = this.ucConnector.listCatalogs();
        if (ucCatalogList != null) {
            for (CatalogInfo catalogInfo : ucCatalogList) {
                if (catalogInfo == null || this.ucFullNameToEgeriaGUID.get(catalogInfo.getName()) != null) continue;
                String ucCatalogQualifiedName = this.getQualifiedName(catalogInfo.getName());
                MemberElement memberElement = iterator.getMemberByQualifiedName(ucCatalogQualifiedName);
                MemberAction memberAction = memberElement.getMemberAction(this.getDateFromLong(catalogInfo.getCreated_at()), this.getDateFromLong(catalogInfo.getUpdated_at()));
                if (!this.noMismatchInExternalIdentifier(catalogInfo.getId(), memberElement)) continue;
                this.takeAction(memberAction, memberElement, catalogInfo);
            }
        }
    }

    private void takeAction(MemberAction memberAction, MemberElement memberElement, CatalogInfo catalogInfo) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        switch (memberAction) {
            case CREATE_INSTANCE_IN_OPEN_METADATA: {
                this.createElementInEgeria(catalogInfo);
                break;
            }
            case UPDATE_INSTANCE_IN_OPEN_METADATA: {
                this.updateElementInEgeria(catalogInfo, memberElement);
                break;
            }
            case DELETE_INSTANCE_IN_OPEN_METADATA: {
                this.deleteElementInEgeria(memberElement);
                break;
            }
            case CREATE_INSTANCE_IN_THIRD_PARTY: {
                this.createElementInThirdParty(memberElement);
                break;
            }
            case UPDATE_INSTANCE_IN_THIRD_PARTY: {
                this.updateElementInThirdParty(catalogInfo, memberElement);
                break;
            }
            case DELETE_INSTANCE_IN_THIRD_PARTY: {
                this.deleteElementInThirdParty(catalogInfo);
            }
        }
    }

    private void createElementInEgeria(CatalogInfo catalogInfo) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedName = super.getQualifiedName(catalogInfo.getName());
        boolean parentAtEnd1 = true;
        String ucCatalogGUID = this.templateGUID != null ? this.openMetadataAccess.createMetadataElementFromTemplate(null, null, this.deployedImplementationType.getAssociatedTypeName(), this.ucServerGUID, false, null, null, this.templateGUID, this.getElementProperties(qualifiedName, catalogInfo), this.getPlaceholderProperties(catalogInfo), this.ucServerGUID, this.parentLinkTypeName, this.propertyHelper.addEnumProperty(null, OpenMetadataProperty.OPERATIONAL_STATUS.name, OperationalStatus.getOpenTypeName(), OperationalStatus.ENABLED.getName()), parentAtEnd1) : this.openMetadataAccess.createMetadataElementInStore(null, null, this.deployedImplementationType.getAssociatedTypeName(), ElementStatus.ACTIVE, null, this.ucServerGUID, false, null, null, this.getElementProperties(qualifiedName, catalogInfo), this.ucServerGUID, this.parentLinkTypeName, this.propertyHelper.addEnumProperty(null, OpenMetadataProperty.OPERATIONAL_STATUS.name, OperationalStatus.getOpenTypeName(), OperationalStatus.ENABLED.getName()), parentAtEnd1);
        this.ucFullNameToEgeriaGUID.put(catalogInfo.getName(), ucCatalogGUID);
        super.addPropertyFacet(ucCatalogGUID, qualifiedName, catalogInfo, null);
        this.context.addExternalIdentifier(ucCatalogGUID, qualifiedName, this.catalogTypeName, ucCatalogGUID, this.catalogTypeName, this.getExternalIdentifierProperties(catalogInfo, null, UnityCatalogPlaceholderProperty.CATALOG_NAME.getName(), catalogInfo.getId(), PermittedSynchronization.FROM_THIRD_PARTY));
        this.addCatalogTarget(this.ucServerGUID, ucCatalogGUID, qualifiedName, catalogInfo.getName(), this.templates, this.configurationProperties);
    }

    protected void updateElementInEgeria(CatalogInfo catalogInfo, MemberElement memberElement) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String egeriaCatalogGUID = memberElement.getElement().getElementGUID();
        this.openMetadataAccess.updateMetadataElementInStore(null, null, egeriaCatalogGUID, false, this.getElementProperties(catalogInfo));
        this.context.confirmSynchronization(memberElement.getElement().getElementGUID(), super.getQualifiedName(catalogInfo.getName()), egeriaCatalogGUID, this.deployedImplementationType.getAssociatedTypeName(), catalogInfo.getId());
    }

    private void createElementInThirdParty(MemberElement memberElement) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "createElementInThirdParty";
        String catalogQualifiedName = this.propertyHelper.getStringProperty(this.connectorName, OpenMetadataProperty.QUALIFIED_NAME.name, memberElement.getElement().getElementProperties(), "createElementInThirdParty");
        CatalogInfo catalogInfo = this.ucConnector.createCatalog(this.getUCNameFromMember(memberElement), this.getUCCommentFomMember(memberElement), this.getUCPropertiesFromMember(memberElement));
        if (memberElement.getExternalIdentifier() == null) {
            this.context.addExternalIdentifier(memberElement.getElement().getElementGUID(), catalogQualifiedName, this.catalogTypeName, memberElement.getElement().getElementGUID(), this.deployedImplementationType.getAssociatedTypeName(), this.getExternalIdentifierProperties(catalogInfo, null, UnityCatalogPlaceholderProperty.CATALOG_NAME.getName(), catalogInfo.getId(), PermittedSynchronization.TO_THIRD_PARTY));
        } else {
            this.context.confirmSynchronization(memberElement.getElement().getElementGUID(), catalogQualifiedName, memberElement.getElement().getElementGUID(), this.deployedImplementationType.getAssociatedTypeName(), catalogInfo.getId());
        }
        this.addCatalogTarget(this.ucServerGUID, memberElement.getElement().getElementGUID(), catalogQualifiedName, catalogInfo.getName(), this.templates, this.configurationProperties);
    }

    private void updateElementInThirdParty(CatalogInfo catalogInfo, MemberElement memberElement) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = "updateElementInThirdParty";
        this.auditLog.logMessage("updateElementInThirdParty", UCAuditCode.CATALOG_UPDATE.getMessageDefinition(this.connectorName, memberElement.getElement().getElementGUID(), catalogInfo.getName(), this.ucServerEndpoint));
        this.context.confirmSynchronization(memberElement.getElement().getElementGUID(), this.deployedImplementationType.getAssociatedTypeName(), memberElement.getElement().getElementGUID(), this.deployedImplementationType.getAssociatedTypeName(), catalogInfo.getId());
    }

    private void deleteElementInThirdParty(CatalogInfo info) throws PropertyServerException {
        this.ucConnector.deleteCatalog(info.getName(), false);
    }

    private Map<String, String> getPlaceholderProperties(CatalogInfo info) {
        HashMap<String, String> placeholderProperties = new HashMap<String, String>();
        placeholderProperties.put(PlaceholderProperty.SERVER_NETWORK_ADDRESS.getName(), this.ucServerEndpoint);
        placeholderProperties.put(UnityCatalogPlaceholderProperty.CATALOG_NAME.getName(), info.getName());
        placeholderProperties.put(PlaceholderProperty.VERSION_IDENTIFIER.name, null);
        placeholderProperties.put(PlaceholderProperty.DESCRIPTION.name, info.getComment());
        return placeholderProperties;
    }

    private ElementProperties getElementProperties(CatalogInfo info) {
        ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.NAME.name, info.getName());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, info.getComment());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, UnityCatalogDeployedImplementationType.OSS_UC_CATALOG.getDeployedImplementationType());
        return elementProperties;
    }

    private ElementProperties getElementProperties(String qualifiedName, CatalogInfo info) {
        ElementProperties elementProperties = this.getElementProperties(info);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName);
        return elementProperties;
    }

    private void addCatalogTarget(String ucServerGUID, String ucCatalogGUID, String ucCatalogQualifiedName, String ucCatalogName, Map<String, String> templates, Map<String, Object> configurationProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addCatalogTarget";
        if (ucServerGUID != null && this.friendshipConnectorGUID != null) {
            CatalogTargetProperties catalogTargetProperties = new CatalogTargetProperties();
            catalogTargetProperties.setCatalogTargetName(ucCatalogName);
            catalogTargetProperties.setMetadataSourceQualifiedName(ucCatalogQualifiedName);
            catalogTargetProperties.setTemplateProperties(templates);
            HashMap<String, Object> targetConfigurationProperties = new HashMap<String, Object>();
            if (configurationProperties != null) {
                targetConfigurationProperties.putAll(configurationProperties);
            }
            targetConfigurationProperties.put(UnityCatalogPlaceholderProperty.CATALOG_NAME.getName(), ucCatalogName);
            targetConfigurationProperties.put(OpenMetadataProperty.GUID.name, ucCatalogGUID);
            catalogTargetProperties.setConfigurationProperties(targetConfigurationProperties);
            String relationshipGUID = this.context.addCatalogTarget(this.friendshipConnectorGUID, ucServerGUID, catalogTargetProperties);
            this.auditLog.logMessage("addCatalogTarget", UCAuditCode.NEW_CATALOG_TARGET.getMessageDefinition(this.connectorName, relationshipGUID, this.friendshipConnectorGUID, ucServerGUID, ucCatalogName));
        }
    }
}

