/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.controls;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogPlaceholderProperty;
import org.odpi.openmetadata.frameworks.governanceaction.controls.RequestParameterType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.SurveyRequestParameter;

public enum UnityCatalogSurveyRequestParameter {
    CATALOG_NAME(UnityCatalogPlaceholderProperty.CATALOG_NAME.getName(), UnityCatalogPlaceholderProperty.CATALOG_NAME.getDescription(), UnityCatalogPlaceholderProperty.CATALOG_NAME.getDataType(), UnityCatalogPlaceholderProperty.CATALOG_NAME.getExample()),
    SCHEMA_NAME(UnityCatalogPlaceholderProperty.SCHEMA_NAME.getName(), UnityCatalogPlaceholderProperty.SCHEMA_NAME.getDescription(), UnityCatalogPlaceholderProperty.SCHEMA_NAME.getDataType(), UnityCatalogPlaceholderProperty.SCHEMA_NAME.getExample());

    public final String name;
    public final String description;
    public final String dataType;
    public final String example;

    private UnityCatalogSurveyRequestParameter(String name, String description, String dataType, String example) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.example = example;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getExample() {
        return this.example;
    }

    public static List<RequestParameterType> getRequestParameterTypes() {
        ArrayList<RequestParameterType> requestParameterTypes = new ArrayList<RequestParameterType>();
        for (UnityCatalogSurveyRequestParameter requestParameter : UnityCatalogSurveyRequestParameter.values()) {
            requestParameterTypes.add(requestParameter.getRequestParameterType());
        }
        return requestParameterTypes;
    }

    public static List<RequestParameterType> getServerSurveyRequestParameterTypes() {
        ArrayList<RequestParameterType> requestParameterTypes = new ArrayList<RequestParameterType>();
        requestParameterTypes.add(SurveyRequestParameter.FINAL_ANALYSIS_STEP.getRequestParameterType());
        return requestParameterTypes;
    }

    public static List<RequestParameterType> getInsideCatalogSurveyRequestParameterTypes() {
        ArrayList<RequestParameterType> requestParameterTypes = new ArrayList<RequestParameterType>();
        requestParameterTypes.add(SurveyRequestParameter.FINAL_ANALYSIS_STEP.getRequestParameterType());
        requestParameterTypes.add(CATALOG_NAME.getRequestParameterType());
        return requestParameterTypes;
    }

    public static List<RequestParameterType> getInsideSchemaSurveyRequestParameterTypes() {
        ArrayList<RequestParameterType> requestParameterTypes = new ArrayList<RequestParameterType>();
        requestParameterTypes.add(SurveyRequestParameter.FINAL_ANALYSIS_STEP.getRequestParameterType());
        requestParameterTypes.add(CATALOG_NAME.getRequestParameterType());
        requestParameterTypes.add(SCHEMA_NAME.getRequestParameterType());
        return requestParameterTypes;
    }

    public RequestParameterType getRequestParameterType() {
        RequestParameterType requestParameterType = new RequestParameterType();
        requestParameterType.setName(this.name);
        requestParameterType.setDescription(this.description);
        requestParameterType.setDataType(this.dataType);
        requestParameterType.setExample(this.example);
        return requestParameterType;
    }

    public String toString() {
        return "RequestParameter{ name=" + this.name + "}";
    }
}

