/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.unitycatalog.provision;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.GuardType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;

public enum ProvisionUnityCatalogGuard {
    SET_UP_COMPLETE("set-up-complete", CompletionStatus.ACTIONED, "The element has been defined in Egeria.  The resource will be provisioned to Unity Catalog as soon as the integration connector receives a notification of the new asset - or it performs a refresh.."),
    NO_TECHNOLOGY_TYPE("no-technology-type", CompletionStatus.INVALID, "The technology type defining which unity catalog resource has not been provided."),
    INVALID_TECHNOLOGY_TYPE("invalid-technology-type", CompletionStatus.INVALID, "The technology type defining which unity catalog resource is not set to a supported value."),
    MISSING_PLACEHOLDER_VALUES("missing-placeholder-values", CompletionStatus.INVALID, "There are missing placeholder property values in the request parameters."),
    SERVICE_FAILED("service-failed", CompletionStatus.FAILED, "An unexpected error occurred while the governance service was running.  Messages are logged to the audit log explaining the source of the error.");

    public final String name;
    public final CompletionStatus completionStatus;
    public final String description;

    private ProvisionUnityCatalogGuard(String name, CompletionStatus completionStatus, String description) {
        this.name = name;
        this.completionStatus = completionStatus;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<GuardType> getGuardTypes() {
        ArrayList<GuardType> guardTypes = new ArrayList<GuardType>();
        for (ProvisionUnityCatalogGuard guard : ProvisionUnityCatalogGuard.values()) {
            GuardType guardType = new GuardType();
            guardType.setGuard(guard.getName());
            guardType.setDescription(guard.getDescription());
            guardType.setCompletionStatus(guard.getCompletionStatus());
            guardTypes.add(guardType);
        }
        return guardTypes;
    }

    public GuardType getGuardType() {
        GuardType guardType = new GuardType();
        guardType.setGuard(this.name);
        guardType.setDescription(this.description);
        guardType.setCompletionStatus(this.completionStatus);
        return guardType;
    }

    public String toString() {
        return "Guard{ name='" + this.name + "}";
    }
}

